/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.xjc;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaClassImpl;

public class XJCJavaFieldImpl
implements JavaField {
    private JFieldVar xjcField;
    private JCodeModel jCodeModel;
    private DynamicClassLoader dynamicClassLoader;
    private JavaClass owningClass;
    private static Field JVAR_ANNOTATIONS = null;
    private static Field JARRAYCLASS_COMPONENTTYPE = null;

    public XJCJavaFieldImpl(JFieldVar javaField, JCodeModel codeModel, DynamicClassLoader loader, JavaClass owner) {
        this.xjcField = javaField;
        this.jCodeModel = codeModel;
        this.dynamicClassLoader = loader;
        this.owningClass = owner;
    }

    @Override
    public JavaAnnotation getAnnotation(JavaClass aClass) {
        if (aClass != null) {
            Collection annotations = null;
            try {
                annotations = (Collection)PrivilegedAccessHelper.getValueFromField(JVAR_ANNOTATIONS, this.xjcField);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (annotations == null) {
                return null;
            }
            for (JAnnotationUse annotationUse : annotations) {
                XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
                if (!xjcAnnotation.getJavaAnnotationClass().getCanonicalName().equals(aClass.getQualifiedName())) continue;
                return xjcAnnotation;
            }
            return null;
        }
        return null;
    }

    @Override
    public Collection<JavaAnnotation> getAnnotations() {
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>();
        Collection annotations = null;
        try {
            annotations = (Collection)PrivilegedAccessHelper.getValueFromField(JVAR_ANNOTATIONS, this.xjcField);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (JAnnotationUse annotationUse : annotations) {
            XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
            annotationsList.add(xjcAnnotation);
        }
        return annotationsList;
    }

    @Override
    public int getModifiers() {
        return this.xjcField.mods().getValue();
    }

    @Override
    public String getName() {
        return this.xjcField.name();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public JavaClass getResolvedType() {
        type = this.xjcField.type();
        basis = null;
        isArray = false;
        isPrimitive = false;
        try {
            basisField = PrivilegedAccessHelper.getDeclaredField(type.getClass(), "basis", true);
            basis = (JClass)PrivilegedAccessHelper.getValueFromField(basisField, type);
        }
        catch (Exception e) {
            // empty catch block
        }
        classToReturn = null;
        if (type.isPrimitive()) {
            pType = (JPrimitiveType)type;
            classToReturn = pType.boxify();
        } else if (type.getClass().getName().contains("JArrayClass")) {
            isArray = true;
            classToReturn = (JClass)type;
            try {
                componentType = (JType)PrivilegedAccessHelper.getValueFromField(XJCJavaFieldImpl.JARRAYCLASS_COMPONENTTYPE, type);
                if (!componentType.isPrimitive()) ** GOTO lbl31
                isPrimitive = true;
            }
            catch (Exception e) {
                throw JAXBException.errorCreatingDynamicJAXBContext(e);
            }
        } else {
            try {
                classToReturn = this.jCodeModel._class(basis != null ? basis.fullName() : type.fullName());
            }
            catch (JClassAlreadyExistsException ex) {
                classToReturn = this.jCodeModel._getClass(basis != null ? basis.fullName() : type.fullName());
            }
        }
lbl31:
        // 5 sources

        if (basis != null) {
            try {
                argsField = PrivilegedAccessHelper.getDeclaredField(type.getClass(), "args", true);
                args = (List)PrivilegedAccessHelper.getValueFromField(argsField, type);
                for (JClass jClass : args) {
                    ((JDefinedClass)classToReturn).generify("param", jClass);
                }
            }
            catch (Exception e) {
                throw JAXBException.errorCreatingDynamicJAXBContext(e);
            }
        }
        className = classToReturn.fullName();
        if (isArray) {
            className = className + "[]";
        }
        if (((XJCJavaClassImpl)this.getOwningClass()).getJavaModel() != null) {
            return ((XJCJavaClassImpl)this.getOwningClass()).getJavaModel().getClass(className);
        }
        return new XJCJavaClassImpl((JDefinedClass)classToReturn, this.jCodeModel, this.dynamicClassLoader, isArray, isPrimitive);
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        throw new UnsupportedOperationException("isSynthetic");
    }

    @Override
    public boolean isEnumConstant() {
        return this.getOwningClass().isEnum();
    }

    @Override
    public JavaAnnotation getDeclaredAnnotation(JavaClass aClass) {
        return this.getAnnotation(aClass);
    }

    @Override
    public Collection<JavaAnnotation> getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public void setOwningClass(JavaClass owningClass) {
        this.owningClass = owningClass;
    }

    public JavaClass getOwningClass() {
        return this.owningClass;
    }

    static {
        try {
            JVAR_ANNOTATIONS = PrivilegedAccessHelper.getDeclaredField(JVar.class, "annotations", true);
            Class<?> c = Class.forName("com.sun.codemodel.JArrayClass");
            JARRAYCLASS_COMPONENTTYPE = PrivilegedAccessHelper.getDeclaredField(c, "componentType", true);
        }
        catch (Exception e) {
            throw JAXBException.errorCreatingDynamicJAXBContext(e);
        }
    }
}

