/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.auth.Authentication;
import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.FileSourceCaches;
import com.isomorphic.rpc.BuiltinRPC;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.sql.DBSandbox;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.tools.AdminConsole;
import com.isomorphic.util.DataTools;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ReifyTestTools
extends BuiltinRPC {
    public static final String DEFAULT_USERNAME = "reifyTest";
    public static final String DEFAULT_PASSWORD = "tryReify";
    public static final String WILDCARD_USERNAME = "reifyTest*";
    public static final String AUTOGEN_USERNAME = "(?i)reifyTest[0-9]+";
    private static final String[] REIFY_SOLO_DS = new String[]{"vbScreens", "vbProjects", "vbDataSources", "vbSettings"};
    private static Path temporaryWorkspace;
    private static final String[] REIFY_SHARED_DS;

    public static synchronized void testReifySoloStart(String testURL, List<String> snapshotDBList, Map globalConfigOverrides) throws Exception {
        int i;
        if (config.getBoolean((Object)"autotest.instance.running", false)) {
            log.warn((Object)"detected autotest in progress from testReifySoloStart - calling testReifySoloEnd before proceeding");
            ReifyTestTools.testReifySoloEnd(config.getString((Object)"autotest.instance.testURL", "N/A"));
        }
        if (globalConfigOverrides == null) {
            globalConfigOverrides = new HashMap<String, String>();
        }
        temporaryWorkspace = Files.createTempDirectory("workspace-", new FileAttribute[0]);
        for (i = 0; i < REIFY_SOLO_DS.length; ++i) {
            String key = "datasources." + REIFY_SOLO_DS[i] + ".config.xpath.set";
            globalConfigOverrides.put(key, "/projectFileLocations[1], " + temporaryWorkspace.toAbsolutePath());
        }
        AdminConsole.testStart(testURL, snapshotDBList, globalConfigOverrides);
        for (i = 0; i < REIFY_SOLO_DS.length; ++i) {
            String dsName = REIFY_SOLO_DS[i];
            DataStructCache.removeCachedObjectWithNoConfigFile((String)dsName);
            DataSourceManager.clearPooledInstances((String)dsName);
        }
    }

    public static synchronized void testReifySoloEnd(String testURL) throws Exception {
        AdminConsole.testEnd(testURL);
        if (temporaryWorkspace != null) {
            if (config.getBoolean((Object)"autotest.clear.db", true)) {
                FileUtils.deleteDirectory((File)temporaryWorkspace.toFile());
            }
            temporaryWorkspace = null;
        }
        for (int i = 0; i < REIFY_SOLO_DS.length; ++i) {
            String dsName = REIFY_SOLO_DS[i];
            DataStructCache.removeCachedObjectWithNoConfigFile((String)dsName);
            DataSourceManager.clearPooledInstances((String)dsName);
        }
    }

    public static synchronized void testReifyCloudStart(String testURL, RequestContext context, AuthenticatedUser user) throws Exception {
        log.info((Object)("testReifyCloudStart() called on " + testURL));
        if (config.getBoolean((Object)"autotest.instance.reify", false)) {
            log.warn((Object)"detected autotest in progress from testReifyCloudStart - calling testReifyCloudEnd before proceeding");
            ReifyTestTools.testReifyCloudEnd(config.getString((Object)"autotest.instance.testURL", "N/A"), context, user, false, false);
        } else {
            ReifyTestTools.testReifyClearDB(user);
        }
        config.put((Object)"autotest.instance.testURL", (Object)testURL);
        config.put((Object)"autotest.instance.reify", (Object)"true");
    }

    public static synchronized void testReifyCloudEnd(String testURL, boolean removeAccount) throws Exception {
        RequestContext context = RequestContext.getThreadLocal();
        AuthenticatedUser user = context != null ? (AuthenticatedUser)Authentication.getUser((RequestContext)context) : null;
        ReifyTestTools.testReifyCloudEnd(testURL, context, user, true, removeAccount);
    }

    private static synchronized void testReifyCloudEnd(String testURL, RequestContext context, AuthenticatedUser user, boolean logout, boolean removeAccount) throws Exception {
        log.info((Object)("testReifyCloudEnd() called on " + testURL));
        if (user != null) {
            ReifyTestTools.testReifyClearDB(user);
        } else {
            log.warn((Object)"No valid test user is present for testReifyCloudEnd()");
        }
        if (context == null) {
            log.warn((Object)"No request context is present for testReifyCloudEnd()");
        } else if (logout) {
            try {
                IAuthenticator authenticator = Authentication.getAuthenticator((RequestContext)context);
                if (authenticator == null) {
                    log.warn((Object)"Couldn't log out of Reify - no valid authenticator");
                } else {
                    authenticator.logout(context);
                    log.info((Object)"Logged out of Reify");
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to log out of Reify", (Throwable)e);
            }
        }
        if (user != null) {
            String username = user.getUserName();
            boolean testUser = DataTools.getBoolean((Map)user, (Object)"testUser", (boolean)false);
            if (removeAccount && testUser && username.matches(AUTOGEN_USERNAME)) {
                try {
                    Class<?> manageOrg = Class.forName("com.isomorphic.site.ManageOrg");
                    Method removeMethod = manageOrg.getDeclaredMethod("removeTestAccount", String.class);
                    removeMethod.invoke(null, username);
                    log.info((Object)("removed the auto-created test account " + username));
                }
                catch (Throwable t) {
                    log.warn((Object)("unable to remove test account " + user.getUserName()), t);
                }
            }
        }
        config.clearSubtree("autotest.instance");
    }

    private static synchronized void testReifyClearDB(AuthenticatedUser user) throws Exception {
        String username = user.getUserName();
        if (config.getBoolean((Object)"autotest.clear.db", true)) {
            try {
                boolean testUser = DataTools.getBoolean((Map)user, (Object)"testUser", (boolean)false);
                if (testUser) {
                    String sandboxPrefix = config.getString((Object)"sql.reify.sandbox.prefix", "sbx_");
                    int userid = DataTools.getInt((Number)((Number)user.get((Object)"userid")));
                    Integer orgId = DataTools.getInt((Number)((Number)user.get((Object)"organizationId")));
                    String sandboxKey = orgId != null ? "org_" + orgId : "user_" + userid;
                    new DBSandbox("reify", sandboxPrefix + sandboxKey).remove();
                    List deploymentSandboxes = DBSandbox.listSandboxes((String)"reify", (String)("*_deployment_*_" + sandboxKey));
                    for (DBSandbox sandbox : deploymentSandboxes) {
                        sandbox.remove();
                    }
                    log.info((Object)("Removed reify sandboxes for test user " + username));
                    for (int i = 0; i < REIFY_SHARED_DS.length; ++i) {
                        String dsName = REIFY_SHARED_DS[i];
                        DSRequest request = new DSRequest(dsName, "remove");
                        request.setCriteria("ownerId", (Object)username);
                        request.setAllowMultiUpdate(true);
                        request.execute();
                    }
                    DSRequest request = new DSRequest("isc_reifyCustomizations", "remove");
                    request.setAllowMultiUpdate(true);
                    AdvancedCriteria criteria = new AdvancedCriteria((Operator)DefaultOperators.Or, new Criterion[]{new SimpleCriterion("devId", "equals", (Object)userid), new SimpleCriterion("orgId", "equals", (Object)orgId)});
                    request.setAdvancedCriteria(criteria);
                    request.execute();
                    log.info((Object)("Removed shared DS records for test user " + username));
                    SQLDriver.purgeSqlConfig();
                    DataStructCache.cache.clear();
                    DataSourceManager.restartPoolManager();
                    FileSourceCaches.clearNegativeCache();
                    FileSourceCaches.clearCache();
                } else {
                    log.warn((Object)"Selenium should target Reify accounts marked as test users. Proper cleanup after each test will otherwise not occur.");
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to cleanup databases for user " + username), (Throwable)e);
            }
        }
    }

    static {
        REIFY_SHARED_DS = new String[]{"isc_sharedProjects"};
    }

    public static class ReifyTestAccounts {
    }
}

