/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.Authenticator;
import org.openqa.jetty.http.HttpConnection;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.http.UserRealm;
import org.openqa.jetty.log.LogFactory;

public class ClientCertAuthenticator
implements Authenticator {
    private static Log log = LogFactory.getLog(ClientCertAuthenticator.class);
    private int _maxHandShakeSeconds = 60;

    public ClientCertAuthenticator() {
        log.warn((Object)"Client Cert Authentication is EXPERIMENTAL");
    }

    public int getMaxHandShakeSeconds() {
        return this._maxHandShakeSeconds;
    }

    public void setMaxHandShakeSeconds(int maxHandShakeSeconds) {
        this._maxHandShakeSeconds = maxHandShakeSeconds;
    }

    @Override
    public Principal authenticate(UserRealm realm, String pathInContext, HttpRequest request, HttpResponse response) throws IOException {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (response != null && (certs == null || certs.length == 0 || certs[0] == null)) {
            Object s = HttpConnection.getHttpConnection().getConnection();
            if (!(s instanceof SSLSocket)) {
                return null;
            }
            SSLSocket socket = (SSLSocket)s;
            if (!socket.getNeedClientAuth()) {
                socket.setNeedClientAuth(true);
                socket.startHandshake();
                int i = this._maxHandShakeSeconds * 4;
                while (i-- > 0) {
                    certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
                    if (certs != null && certs.length > 0 && certs[0] != null) break;
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception exception) {
                        break;
                    }
                }
            }
        }
        if (certs == null || certs.length == 0 || certs[0] == null) {
            return null;
        }
        Principal principal = certs[0].getSubjectDN();
        if (principal == null) {
            principal = certs[0].getIssuerDN();
        }
        String username = principal == null ? "clientcert" : principal.getName();
        Principal user = realm.authenticate(username, certs, request);
        request.setAuthType("CLIENT_CERT");
        if (user != null) {
            request.setAuthUser(user.getName());
        }
        request.setUserPrincipal(user);
        return user;
    }

    @Override
    public String getAuthMethod() {
        return "CLIENT_CERT";
    }
}

