/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.VirtualXML;
import com.isomorphic.taglib.BaseTag;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public abstract class VirtualTag
extends BaseTag {
    protected static boolean virtualize;
    protected RequestContext context;

    @Override
    public void init() {
        super.init();
        virtualize = config.getBoolean((Object)"caching.taglib.virtualizeXML", false);
        try {
            this.context = RequestContext.instance(this.pageContext);
        }
        catch (Exception e) {
            this.log.error((Object)"RequestContext instantiation failed", e);
        }
    }

    public int virtualizeTag(String type, String name) throws Exception {
        JspWriter out = this.pageContext.getOut();
        return VirtualTag.virtualizeTag(type, name, (Writer)out, this.pageContext);
    }

    public static int virtualizeTag(String type, String name, Writer out, PageContext pageContext) throws Exception {
        String isomorphicURI = (String)pageContext.getRequest().getAttribute("isomorphicURI");
        if (isomorphicURI == null) {
            isomorphicURI = config.getString("isomorphicURI");
        }
        out.write(VirtualXML.generateScriptTag(isomorphicURI, type, name));
        return 0;
    }
}

