/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.IType;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.util.IDoNotAdapt;
import com.isomorphic.velocity.DataSourcesHandler;
import com.isomorphic.velocity.EditedRecordHandler;
import com.isomorphic.velocity.StoredRecordHandler;
import com.isomorphic.xml.XML;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import org.w3c.dom.Element;

public class ValidationContext
extends HashMap
implements IDoNotAdapt {
    static Logger log = new Logger(ValidationContext.class.getName());
    public static Logger velocityLog = new Logger("velocityTemplate");
    private Exception createStack;
    boolean propertiesOnly = false;
    boolean useSchema = true;
    boolean idAllowed = false;
    String strictModePath = "";
    String path = "";
    String fieldName = "";
    boolean useMockMode = false;
    boolean forComponentXML = true;
    boolean forSCServerXML = false;
    boolean skipNonTypeValidations = false;
    Element currentElement = null;
    Stack iterationCounterStack = new Stack();
    Map currentRecord = null;
    DataSource currentDataSource = null;
    DSRequest dsRequest = null;
    RPCManager rpcManager = null;
    RequestContext requestContext = null;
    Object resultingValue = null;
    boolean valueIsSet = false;
    boolean restrictedXMLMode = false;
    Map errors = null;
    Map<String, BasicDataSource> typeCache = new HashMap<String, BasicDataSource>();
    Map<String, IType> customSimpleTypeCache = new HashMap<String, IType>();
    public static int typeLookupTime;
    int count = 0;
    private String hashIdStr = null;
    protected Map templateContext;
    protected Map templateContextClassNames;
    protected StoredRecordHandler storedRecordHandler;
    protected EditedRecordHandler editedRecordHandler;
    String bundleName;
    String encoding;
    List<String> validEncodings = new ArrayList<String>(){
        {
            this.add(null);
            this.add("utf-8");
            this.add("iso-8859");
        }
    };
    private boolean encodeBinaryFields = false;
    private String source;
    private String sourceFilename;
    private String retrieverProject;
    private Map<String, DataSource> projectDS;
    private Set<String> excludedDS;
    private DataSource importingDS;

    public ValidationContext() {
        if (log.isDebugEnabled()) {
            this.createStack = new Exception();
        }
    }

    public boolean isPropertiesOnly() {
        return this.propertiesOnly;
    }

    public void setPropertiesOnly() {
        this.setPropertiesOnly(true);
    }

    public void setPropertiesOnly(boolean value) {
        this.propertiesOnly = value;
    }

    public void setUseSchema() {
        this.setUseSchema(true);
    }

    public void setUseSchema(boolean value) {
        this.useSchema = value;
    }

    public boolean idAllowed() {
        return this.idAllowed;
    }

    public void setIdAllowed() {
        this.setIdAllowed(true);
    }

    public void setIdAllowed(boolean value) {
        this.idAllowed = value;
    }

    public String getStrictModePath() {
        return this.strictModePath;
    }

    public void addStrictModePath(String segment) {
        this.strictModePath = "".equals(this.strictModePath) ? segment : this.strictModePath + "." + segment;
    }

    public void removeStrictModePathSegment() {
        int index = this.strictModePath.lastIndexOf(".");
        this.strictModePath = index < 0 ? "" : this.strictModePath.substring(0, index);
    }

    public String getPath() {
        return this.path;
    }

    public void addPath(String segment) {
        this.path = this.path + "/" + segment;
        this.fieldName = segment;
    }

    public void removePathSegment() {
        this.path = this.path.substring(0, this.path.lastIndexOf("/"));
        this.fieldName = this.path.substring(this.path.lastIndexOf("/") + 1, this.path.length());
    }

    public boolean useMockMode() {
        return this.useMockMode;
    }

    public void setUseMockMode() {
        this.setUseMockMode(true);
    }

    public void setUseMockMode(boolean value) {
        this.useMockMode = value;
    }

    public boolean forComponentXML() {
        return this.forComponentXML;
    }

    public void setForComponentXML() {
        this.setForComponentXML(true);
    }

    public void setForComponentXML(boolean value) {
        this.forComponentXML = value;
    }

    public boolean forSCServerXML() {
        return this.forSCServerXML;
    }

    public void setForSCServertXML() {
        this.setForSCServerXML(true);
    }

    public void setForSCServerXML(boolean value) {
        this.forSCServerXML = value;
    }

    public boolean shouldSkipNonTypeValidations() {
        return this.skipNonTypeValidations;
    }

    public void setSkipNonTypeValidations() {
        this.setSkipNonTypeValidations(true);
    }

    public void setSkipNonTypeValidations(boolean value) {
        this.skipNonTypeValidations = value;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setCurrentElement(Element element) {
        this.currentElement = element;
    }

    public Element getCurrentElement() {
        return this.currentElement;
    }

    public Integer getIterationCounter() {
        if (this.iterationCounterStack.empty()) {
            return null;
        }
        return (Integer)this.iterationCounterStack.peek();
    }

    public Integer popIterationCounter() {
        if (this.iterationCounterStack.empty()) {
            return null;
        }
        return (Integer)this.iterationCounterStack.pop();
    }

    public void pushIterationCounter(Integer counter) {
        this.iterationCounterStack.push(counter);
    }

    public void setCurrentRecord(Map record) {
        if (record != null && !record.equals(this.currentRecord)) {
            this.editedRecordHandler.reset();
        }
        this.currentRecord = record;
        this.storedRecordHandler.setCurrentRecord();
    }

    public Map getCurrentRecord() {
        return this.currentRecord;
    }

    public Map getStoredRecord() {
        return this.storedRecordHandler;
    }

    public void setCurrentDataSource(DataSource dataSource) {
        if (dataSource != null && !dataSource.getName().equals(this.currentDataSource == null ? null : this.currentDataSource.getName())) {
            this.editedRecordHandler.reset();
        }
        this.currentDataSource = dataSource;
        this.storedRecordHandler.setCurrentRecord();
    }

    public DataSource getCurrentDataSource() {
        return this.currentDataSource;
    }

    public void setDSRequest(DSRequest dsRequest) {
        this.dsRequest = dsRequest;
    }

    public DSRequest getDSRequest() {
        return this.dsRequest;
    }

    public void setRPCManager(RPCManager rpcManager) {
        this.rpcManager = rpcManager;
    }

    public RPCManager getRPCManager() {
        return this.rpcManager;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setResultingValue(Object value) {
        this.valueIsSet = true;
        this.resultingValue = value;
        this.editedRecordHandler.put(this.getFieldName(), value);
    }

    public Object getResultingValue() {
        return this.resultingValue;
    }

    public boolean resultingValueIsSet() {
        return this.valueIsSet;
    }

    public void clearResultingValue() {
        this.valueIsSet = false;
    }

    public void setRestrictedXMLMode(boolean restrictedXMLMode) {
        this.restrictedXMLMode = restrictedXMLMode;
    }

    public boolean getRestrictedXMLMode() {
        return this.restrictedXMLMode;
    }

    public Map getErrors() {
        return this.errors;
    }

    public void addError(Object newErrors) {
        this.addError(this.fieldName, newErrors);
    }

    public void addError(String fieldName, Object newErrors) {
        if (newErrors == null) {
            return;
        }
        if (this.errors == null) {
            this.errors = new HashMap();
        }
        log.debug("Adding validation errors at path '" + this.path + "': " + newErrors);
        String recordPath = this.getCurrentRecordPath(fieldName);
        ErrorReport report = (ErrorReport)this.errors.get(recordPath);
        if (report == null) {
            report = new ErrorReport();
            report.put("recordPath", recordPath);
            if (this.currentElement != null) {
                report.put("xpath", XML.getXPath(this.currentElement));
            }
            this.errors.put(recordPath, report);
        }
        DataTools.putCombinedList(report, fieldName, newErrors);
    }

    public boolean hasErrors() {
        return this.errors != null;
    }

    public void clearErrors() {
        this.errors = null;
    }

    public String getCurrentRecordPath(String fieldName) {
        String recordPath = this.path;
        if (fieldName != null && recordPath.endsWith("/" + fieldName)) {
            recordPath = recordPath.substring(0, recordPath.lastIndexOf("/"));
        }
        return recordPath;
    }

    public ErrorReport getCurrentErrorReport() {
        if (this.errors == null) {
            return null;
        }
        return (ErrorReport)this.errors.get(this.getCurrentRecordPath(null));
    }

    public BasicDataSource getType(String typeName) throws Exception {
        return this.getType(typeName, null);
    }

    public BasicDataSource getType(String typeName, DataTypeMap flags) throws Exception {
        if (typeName == null || "".equals(typeName)) {
            return null;
        }
        if (!this.useSchema && !"Object".equals(typeName)) {
            return null;
        }
        if (this.typeCache.containsKey(typeName)) {
            return this.typeCache.get(typeName);
        }
        if (DataSource.getBuiltinType(typeName) != null) {
            return null;
        }
        long start = System.currentTimeMillis();
        BasicDataSource ds = (BasicDataSource)DataSourceManager.getDataSource(typeName, this.getDSRequest(), this.augmentLoadFlags(flags));
        long end = System.currentTimeMillis();
        typeLookupTime = (int)((long)typeLookupTime + (end - start));
        this.typeCache.put(typeName, ds);
        return ds;
    }

    public String hashId() {
        if (this.hashIdStr == null) {
            this.hashIdStr = UUID.randomUUID().toString().substring(0, 8);
        }
        return this.hashIdStr;
    }

    public void addToTypeCache(String typeName, BasicDataSource type) {
        DataSource existing = this.typeCache.get(typeName);
        if (existing != type) {
            if (existing != null) {
                DataSourceManager.free(existing);
            }
            this.typeCache.put(typeName, type);
        }
    }

    DataTypeMap augmentLoadFlags(DataTypeMap flags) {
        if (!(flags = (DataTypeMap)((Object)DataTools.cascadeMaps(new Map[]{flags == null ? DataSource.getLoadFlags() : flags, new DataTypeMap()}))).containsKey("forComponentXML")) {
            flags.put("forComponentXML", this.forComponentXML());
        }
        if (!flags.containsKey("forSCServerXML")) {
            flags.put("forSCServerXML", this.forSCServerXML());
        }
        if (!flags.containsKey("validationContext")) {
            flags.put("validationContext", this);
        }
        return flags;
    }

    IType getCustomSimpleType(String typeName, BasicDataSource dataSource) throws Exception {
        if (typeName == null || "".equals(typeName)) {
            return null;
        }
        IType res = this.typeCache.get(typeName);
        if (res != null) {
            return res;
        }
        String typeConfigFile = DataStructCache.getInstanceFile(typeName, "datasources", "type", this.augmentLoadFlags(null));
        if (typeConfigFile == null) {
            return null;
        }
        Object typeConfig = DataStructCache.loadInstance(typeConfigFile, typeName, "type");
        res = dataSource.makeType(typeName, (Map)typeConfig);
        this.customSimpleTypeCache.put(typeName, res);
        return res;
    }

    public Map getTemplateContext() {
        return this.templateContext;
    }

    public Map getTemplateContextClassNames() {
        return this.templateContextClassNames;
    }

    public void setTemplateContext(Map templateContext) {
        this.templateContext = templateContext;
    }

    public void setTemplateContextClassNames(Map templateContextClassNames) {
        this.templateContextClassNames = templateContextClassNames;
    }

    public void addToTemplateContext(Map addMap) {
        if (this.templateContext == null) {
            this.initTemplateContext();
        }
        for (Object key : addMap.keySet()) {
            Object value = addMap.get(key);
            this.templateContext.put(key, value);
        }
    }

    public void addToTemplateContextClassNames(Map addMap) {
        if (this.templateContextClassNames == null) {
            this.initTemplateContext();
        }
        for (Object key : addMap.keySet()) {
            Object value = addMap.get(key);
            this.templateContextClassNames.put(key, value);
        }
    }

    public void addToTemplateContext(Object key, Object value) {
        this.addToTemplateContext(key, value, null);
    }

    public void addToTemplateContext(Object key, Object value, Class valueClass) {
        if (this.templateContext == null) {
            this.initTemplateContext();
        }
        this.templateContext.put(key, value);
        if (value != null) {
            this.templateContextClassNames.put(key, value.getClass().getName());
        } else if (valueClass != null) {
            this.templateContextClassNames.put(key, valueClass.getName());
        }
    }

    public void addToTemplateContextClassNames(Object key, Object value) {
        if (this.templateContextClassNames == null) {
            this.initTemplateContext();
        }
        this.templateContextClassNames.put(key, value);
    }

    private void initTemplateContext() {
        this.templateContext = new HashMap();
        this.templateContext.put("log", velocityLog);
        this.templateContext.put("rpc", this.rpcManager);
        this.templateContext.put("rpcManager", this.rpcManager);
        this.templateContext.put("dataSources", new DataSourcesHandler(this.getDSRequest()));
        this.templateContext.put("dsRequest", this.dsRequest);
        this.templateContext.put("util", new DataTools());
        this.storedRecordHandler = new StoredRecordHandler(this);
        this.templateContext.put("storedRecord", this.storedRecordHandler);
        this.editedRecordHandler = new EditedRecordHandler(this.storedRecordHandler);
        this.templateContext.put("editedRecord", this.editedRecordHandler);
        this.templateContext.put("validationContext", this);
        this.templateContextClassNames = new HashMap();
        this.templateContextClassNames.put("log", Logger.class.getName());
        this.templateContextClassNames.put("rpc", RPCManager.class.getName());
        this.templateContextClassNames.put("rpcManager", RPCManager.class.getName());
        this.templateContextClassNames.put("dataSources", DataSourcesHandler.class.getName());
        this.templateContextClassNames.put("dsRequest", DSRequest.class.getName());
        this.templateContextClassNames.put("util", DataTools.class.getName());
        this.templateContextClassNames.put("storedRecord", this.storedRecordHandler.getClass().getName());
        this.templateContextClassNames.put("editedRecord", this.editedRecordHandler.getClass().getName());
        this.templateContextClassNames.put("validationContext", ValidationContext.class.getName());
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleEncoding(String encoding) {
        if (!this.validEncodings.contains(encoding)) {
            log.warn("Ignoring attempt to use invalid ResourceBundle encoding '" + encoding + "'. Valid encoDings are: " + this.validEncodings);
        } else {
            this.encoding = encoding;
        }
    }

    public String getBundleEncoding() {
        return this.encoding;
    }

    public boolean getEncodeBinaryFields() {
        return this.encodeBinaryFields;
    }

    public void setEncodeBinaryFields(boolean encodeBinaryFields) {
        this.encodeBinaryFields = encodeBinaryFields;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setSourceFilename(String sourceFilename) {
        this.sourceFilename = sourceFilename;
    }

    public String getSourceFilename() {
        return this.sourceFilename;
    }

    public String getRetrieverProject() {
        return this.retrieverProject;
    }

    public void setRetrieverProject(String project) {
        this.projectDS = new HashMap<String, DataSource>();
        this.retrieverProject = project;
    }

    public Map<String, DataSource> getProjectDataSources() {
        return this.projectDS;
    }

    void addProjectDataSources(Map<String, DataSource> processed) {
        for (String dsName : processed.keySet()) {
            DataSource ds = processed.get(dsName);
            if (this.projectDS.containsKey(dsName)) {
                DataSourceManager.free(ds);
                continue;
            }
            this.projectDS.put(dsName, ds);
        }
    }

    public void setExcludedDS(List<String> excludedDS) {
        this.excludedDS = excludedDS != null ? new HashSet<String>(excludedDS) : null;
    }

    public boolean excludeAllDS() {
        return this.excludedDS != null && this.excludedDS.contains("*");
    }

    public Set<String> getExcludedDS() {
        return this.excludedDS;
    }

    public void setImportingDS(DataSource importingDS) {
        this.importingDS = importingDS;
    }

    public boolean hasImportingDS() {
        return this.importingDS != null;
    }

    public DataSource getImportingDS() {
        return this.importingDS;
    }

    public void finalize() throws Throwable {
        if (this.typeCache.size() > 0) {
            if (this.createStack == null) {
                log.warn("You can see the stack trace for where the ValidationContext was created if you enable debug logging.");
            } else {
                log.warn((Object)"Freeing cached DataSource instances from ValidationContext::finalize() - these should have been freed on-thread with a manual call to freeResources(). The stack that created the ValidationContext is:", this.createStack);
            }
            this.freeResources();
        }
    }

    public void freeResources() {
        Iterator<String> i = this.typeCache.keySet().iterator();
        while (i.hasNext()) {
            DataSourceManager.free(this.typeCache.get(i.next()));
        }
        this.typeCache.clear();
        if (this.projectDS != null) {
            Iterator<String> dsIter = this.projectDS.keySet().iterator();
            while (dsIter.hasNext()) {
                DataSourceManager.free(this.projectDS.get(dsIter.next()));
            }
        }
    }
}

