
package com.smartgwt.client.docs;

/**
 * <h3>JUnit + Selenium WebDriver</h3>
 * <div style="width:600px">
 * 
 *  Let's take a look at some JUnit code designed to test a standalone version of the
 *  
 * <a href='http://localhost:8080/index.html#tree_editing' target='_blank'>Smart GWT Showcase:
 * Trees &gt;&gt; Editing</a> 
 *  
 *  example.  The overall test class, TreeTest, contains a test, testTree1, targeted at the
 *  TreeGrid in the example, and a test, testTree2, targeted at the SearchForm/ListGrid.  As
 * shown in the {@link com.smartgwt.client.docs.AutomatedTesting automated testing overview}, we
 * create a
 * <a href='../../../../../server/javadoc/com/isomorphic/webdriver/SmartClientWebDriver.html'
 * target='_blank'>SmartClientWebDriver</a>
 *  instance which we'll use to execute commands such as
 * <a
 * href='../../../../../server/javadoc/com/isomorphic/webdriver/SmartClientWebDriver.html#waitForElementClickable-org.openqa.selenium.By-'
 * target='_blank'>waitForElementClickable()</a>.
 *  Usage of <code>SmartClientWebDriver</code> APIs parallels Selenese commands, so you may want
 * to review our {@link com.smartgwt.client.docs.UsingSelenium guide to writing Selenium scripts}
 * before going any
 *  further.
 *  <P>
 *  Just as <code>SmartClientWebDriver</code> Java calls cannot be directly generated by Selenium
 * IDE and require <a
 * href='../../../../../server/javadoc/com/isomorphic/webdriver/SeleneseRunner.html'
 * target='_blank'>SeleneseRunner</a>,
 *  neither can we directly generate <code>SmartClientWebDriver</code>-based JUnit4 classes.
 *  The test class TreeTest was initially generated by exporting the Selenese for testTree1 in
 *  JUnit 4 format (Java / JUnit 4 / WebDriver) to get the method declarations, but the method
 *  implementations were then filled in with Java generated by <code>SeleneseRunner</code>.
 *  Below we look at the two test cases testTree1 and testTree2.
 *  <P>
 *  To simplify the code for presentation, we've wrapped the driver APIs <code>click()</code> and
 *  <code>waitForElementClickable()</code> in local methods that automatically generate the
 * <a href='../../../../../server/javadoc/com/isomorphic/webdriver/ByScLocator.html'
 * target='_blank'>ByScLocator</a>.  If you'd like to
 *  experiment with making changes to the sample JUnit code, one improvement that might simplify
 *  things further would be to add a <code>myClick()</code> function that handles both the
 *  <code>waitForElementClickable()</code> and the <code>click()</code> on the supplied locator.
 *  Often, just assigning each unique locator or locator prefix to a local Java variable so it
 *  can be reused for multiple calls will make the code simpler to follow and maintain.
 * 
 *  <pre>
 *  import org.openqa.selenium.*;
 *  import org.openqa.selenium.remote.*;
 *  import org.openqa.selenium.firefox.*;
 * 
 *  import org.junit.*;
 *  import static org.junit.Assert.*;
 *  import java.util.regex.Pattern;
 * 
 *  public class TreeTest {
 *      private SmartClientWebDriver driver;
 * 
 *      private SmartClientWebDriver click(String scLocator) {
 *          return driver.click(ByScLocator.scLocator(scLocator));
 *      }
 * 
 *      private boolean waitForElementClickable(String scLocator) {
 *          return driver.waitForElementClickable(ByScLocator.scLocator(scLocator));
 *      }
 *  
 *      &#64;Before
 *      public void setUp() throws Exception {
 *          driver = new SmartClientFirefoxDriver();
 *          driver.setBaseUrl("http://localhost:8080/");
 *      }
 * 
 *      &#64;Test
 *      public void testTree1() throws Exception {
 *          driver.get("#tree_editing");
 * 
 *          waitForElementClickable("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=4||Name=Charles%20Madigen||0]/col[fieldName=Name||0]/open");
 *          click("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=4||Name=Charles%20Madigen||0]/col[fieldName=Name||0]/open");
 * 
 *          waitForElementClickable("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=189||Name=Gene%20Porter||8]/col[fieldName=Name||0]/open");
 *          click("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=189||Name=Gene%20Porter||8]/col[fieldName=Name||0]/open");
 * 
 *          waitForElementClickable("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=264||Name=Cheryl%20Pearson||Salary=5650||10]/col[fieldName=Salary||2]");
 *          assertEquals("5650", driver.getText(ByScLocator.
 *              scLocator("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=264||Name=Cheryl%20Pearson||Salary=5650||10]/col[fieldName=Salary||2]")));
 *      }
 *  </pre>
 * 
 *  In test testTree1, the idea is to:
 *  <ul>
 *      <li> Open the node for the top level employee, Charles Madigen,
 *      <li> Open the node for his report, Gene Porter, and
 *      <li> Verify that the Salary of Cheryl Pearson, who reports to Gene, is 5650
 *  </ul><p>
 *  For this test, everything (less simplification) but the JUnit <code>Assert.assertEquals()
 *  </code> should be generated for you by <code>SeleneseRunner</code>.  A verification in
 *  Selenese will likely be generated as a <code>verifyValue()</code> call to
 *  <code>SmartClientWebDriver</code>, but as that simply returns a boolean, we instead want to
 *  invoke the JUnit API directly on the result of <code>getText()</code>.
 *  <P>
 *  Note that though the locator for Cheryl includes the salary, it will match based on the first
 *  field, EmployeeId, which is the primary key, so the test will correctly compare the contents 
 *  of Cheryl's salary against the value 5650 and fail if it doesn't match.  If for some reason 
 *  your test requires matching a specific field rather than the default fields and ordering
 *  generated automatically, you can hand edit the locator.
 * 
 *  <pre>
 *  
 *      public void testTree2() throws Exception {
 *          driver.get("#tree_editing");
 * 
 *          // Steps 1-3: Load the ListGrid with Joan's Reports
 *          waitForElementClickable("scLocator=//SearchForm[ID="employeeSearchForm"]/item[index=0||Class=PickTreeItem]/button/");
 *          click("scLocator=//SearchForm[ID="employeeSearchForm"]/item[index=0||Class=PickTreeItem]/button/");
 * 
 *          waitForElementClickable("scLocator=//autoID[Class=SelectionTreeMenu||index=8||length=14||classIndex=0||classLength=2||roleIndex=0||roleLength=2||scRole=menu]/body/row[Name=Charles%20Madigen]/col[fieldName=title||0]");
 *          mouseMove(ByScLocator.
 *              scLocator("scLocator=//autoID[Class=SelectionTreeMenu||index=8||length=14||classIndex=0||classLength=2||roleIndex=0||roleLength=2||scRole=menu]/body/row[Name=Charles%20Madigen]/col[fieldName=title||0]"));
 * 
 *          waitForElementClickable("scLocator=//SelectionTreeMenu[ID=\"isc_SelectionTreeMenu_0_childrenSubMenu_0\"]/body/row[EmployeeId=183]/col[fieldName=title||1]");
 *          click("scLocator=//SelectionTreeMenu[ID=\"isc_SelectionTreeMenu_0_childrenSubMenu_0\"]/body/row[EmployeeId=183]/col[fieldName=title||1]");
 *  
 *          // Step 4: Sort by salary, descending, and wait for ListGrid to be redrawn with final result
 *          waitForElementClickable("scLocator=//ListGrid[ID=\"employeeGrid\"]/header/headerButton[fieldName=Salary]/");
 *          click("scLocator=//ListGrid[ID=\"employeeGrid\"]/header/headerButton[fieldName=Salary]/");
 *          waitForElementClickable("scLocator=//ListGrid[ID=\"employeeGrid\"]/header/headerButton[fieldName=Salary]/");
 *          click("scLocator=//ListGrid[ID=\"employeeGrid\"]/header/headerButton[fieldName=Salary]/");
 * 
 *          driver.waitForGridDone(ByScLocator.scLocator("scLocator=//ListGrid[ID='employeeGrid']"));
 * 
 *          // Step 5: Verify the top salary
 *          waitForElementClickable("scLocator=//ListGrid[ID=\"employeeGrid\"]/body/row[0]/col[fieldName=Salary||2]");
 *          assertEquals("9400", selenium.getText(ByScLocator.scLocator("scLocator=//ListGrid[ID=\"employeeGrid\"]/body/row[0]/col[fieldName=Salary||2]")));
 *      }
 *  </pre>
 * 
 *  In test testTree2, the idea is to:
 *  <P>
 *  1. Click on the SearchForm button, revealing a Charles Madigen popup,<BR>
 *  2. Issue a MouseMove on the Charles Madigen popup, revealing a list of his reports,<BR>
 *  3. Click on his report Joan Little, filling the ListGrid with her reports,<BR>
 *  4. Click on the salary column header twice, sorting by descending salary, and<BR>
 *  5. Verify the salary in the top row (top salary) is 9400<BR>
 *  <P>
 *  This test required more hand modification than the previous one.  In particular three
 *  modifications were made:
 *  <ul>
 *     <li> A mouseMove command was manually added to the Selenium IDE script,
 *     <li> A call to <code>waitForGridDone()</code> was added to assure the sorting was done
 *          before we ran verifyText, and
 *     <li> We manually removed all but the row qualifier from the automatically generated
 *           scLocator for step &#35;5.
 *  </ul>
 *  <p>
 *  The first modification is required because our user extensions don't record mouseMove
 *  events, and the second is needed to ensure the sorts are complete before verifyText runs--for
 * details see the User Guide (described in {@link com.smartgwt.client.docs.AutomatedTesting}). 
 * The final modification is
 *  just a reflection of what our intent is in step &#35;5; we want to operate on the top row,
 *  regardless of its contents, so we don't want our locator matching based on the EmployeeId or
 *  Name fields of the records.  (Matching by EmployeeId in the locator as automatically
 * generated would make the test verify that Kelly Fetterman's salary is 9400 rather than that
 * 9400 
 *  is the highest salary.)
 *  <pre><p>
 *      &#64;After
 *      public void tearDown() throws Exception {
 *          driver.quit();
 *      }
 *  }
 *  </pre>
 *  </div>
 */
public interface JUnitWebDriver {
}
