#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )

$symbol_pound REST Server

This example illustrates use of the SmartClient RESTHandler servlet to easily provide data access to clients other than SmartClient / SmartGWT (mobile, Swing, native, etc).  It was generated by a Maven archetype available in the SDK.  Most applications not using a SmartGWT UI would likely be able to simplify the build process by using identical code & configuration with the SmartClient SDK instead. 

_Note that SmartGWT clients_ can _talk to the Smart GWT Server using REST, but there is no benefit to this approach.  In fact, it imposes a number of inconveniences and makes a handful of server-based features less useful.  Most SmartGWT applications should be written as illustrated in the **archetype-smartgwt-quickstart** and **archetype-smartgwt-quickstart-relogin** archetypes/examples, with RESTHandler enabled where there is a need to provide data access to additional, separate, applications._

To start with a new application like this one:

1. Install Maven, if necessary 

     <https://maven.apache.org/install.html>

2. Install SmartGWT, if necessary.
              
        mvn com.isomorphic:isc-maven-plugin:1.4.5:install $symbol_escape
          -Dproduct=SMARTGWT -Dlicense=LGPL -DbuildNumber=13.0p

3. Generate a project (using LATEST as below, or the version installed for you in step 2)

        mvn archetype:generate $symbol_escape
          -DartifactId=my-application -Dmodule=MyApplication $symbol_escape
          -DgroupId=com.example -Dpackage=com.example.myapplication $symbol_escape
          -DarchetypeGroupId=com.isomorphic.archetype $symbol_escape
          -DarchetypeArtifactId=archetype-smartgwt-example-restserver $symbol_escape
          -DarchetypeVersion=LATEST -DinteractiveMode=false


Instructions are provided below for using the generated project with Eclipse and command line development environments.

If you instead want to add Smart GWT EE to an existing project, see these instructions:  

<http://www.smartclient.com/smartgwtee/javadoc/com/smartgwt/client/docs/SgwtEESetup.html>

For instructions for launching tools such as the Developer Console, Visual Builder or DataSource Wizards, see the Smart GWT FAQ:

<http://forums.smartclient.com/showthread.php?t=8159>


$symbol_pound$symbol_pound Prerequisites

Variations on the following are possible, but archetypes & sample projects were created with the following environment/s in mind:

- [Java 8](https://java.com/en/download/manual.jsp)

- [Google Web Toolkit](https://developers.google.com/web-toolkit/download) version 2.8.2 or later

- [Apache Maven](http://maven.apache.org/download.cgi) version 3.5.0 or later

- [Apache Ant](https://ant.apache.org/bindownload.cgi) version 1.9.10 or later.

  - *Ensure that the GWT_HOME environment variable is set to the location of your Google Web Toolkit SDK directory*

  - *Ensure that the ANT_HOME environment variable is set to the location of your Apache Ant directory, and the 'ant' command is in your PATH.*

- [Eclipse Java EE IDE for Web Developers](http://www.eclipse.org/downloads/packages/eclipse-ide-java-ee-developers/oxygen2), version 4.7.2 (Oxygen) or later.

$symbol_pound$symbol_pound$symbol_pound Initialization

1.  Ant users will begin by restructuring the project and removing Maven-specific resources.

        cd my-application
        ant unmaven


$symbol_pound$symbol_pound Usage: Apache Maven

$symbol_pound$symbol_pound$symbol_pound Command line tools

1. Navigate to your project directory
        
        cd my-application

2. Extract the SmartClient / SmartGWT server runtime and start the servlet container

        mvn prepare-package jetty:run -pl *-server

3. Use any other process / technology to submit an HTTP POST to the server.  The sample Java client provides a handful of test messages at src/main/resources, and you can specify the message that's posted using a command line system property.  From another prompt in the same directory:

        mvn compile exec:java -pl *-client [-Dbody=/fetchByAdvancedCriteria.xml]

   Note that SmartGWT also generates an OpenAPI Specification outlining all available operations, made available at [](http://localhost:8080/index.jsp).

$symbol_pound$symbol_pound$symbol_pound Eclipse

1. Import the generated project using the "Existing Maven Projects" wizard (File/Import/Maven/Existing Maven Projects)

2. If necessary, extract the SmartClient / SmartGWT server runtime.  You may need to refresh your project's contents.

        mvn prepare-package -P extract-runtime

   _Note that this won't be strictly necessary if you've already tested the project using Command Line Tools, but you'll need to repeat this step following any 'mvn clean' execution._:  

3.  Add the SmartGWT runtime to the server project's 'Deployment Assembly'.  Note that a refresh of the server project's 'target' folder may be necessary.
   
      **Source**: /target/my-application-server-1.0-SNAPSHOT/     
      **Deploy Path**: /    

4. Create or edit a Tomcat server with a JNDI configuration similar to those found at src/etc/tomcat/context.xml.  Servers/[YOUR SERVER]/context.xml or Servers/[YOUR SERVER]/server.xml (added to the context node)

5. Change the myapplication-server project's context root (Project properties / Web Project Settings) to '/' and add the application to the Tomcat server

6. Launch server

7. Use any other process / technology to submit an HTTP request to the server.  The sample Java client provides a handful of test messages at src/main/resources, and you can specify the message that's posted using a command line system property.  Note that if you did not change the context root as described above, so you may also need to provide the URL with a system property.  From a prompt in the project directory:

        mvn compile exec:java -pl *-client $symbol_escape
          [-Dbody=/fetchByAdvancedCriteria.xml] $symbol_escape
          [-Durl=http://localhost:8080/restapi]
  
   Note that SmartGWT also generates an OpenAPI Specification outlining all available operations, made available at [](http://localhost:8080/index.jsp).

$symbol_pound$symbol_pound Usage: Apache Ant

$symbol_pound$symbol_pound$symbol_pound Command line tools

1. Navigate to your project directory
        
        cd my-application
        
2. Extract the SmartClient / SmartGWT server runtime and start the servlet container.  _Note that this may fail the first time when Apache Ivy has not been installed, but correction should occur automatically, and subsequent attempts should be successful_.

        ant devmode

3. Use any other process / technology to submit an HTTP request to the server.  The sample Java client provides a handful of test messages at src/main/resources, and you can specify the message that's posted with a change to the build's exec-java target.

        ant exec-java
   
//>NeverShip
Reveal the following at REL-13.0
   Note that SmartGWT also generates an OpenAPI Specification outlining all available operations, made available at [](http://localhost:8080/index.jsp).
//<NeverShip

$symbol_pound$symbol_pound$symbol_pound Eclipse

1. Create a new project using the "Java Project" wizard (File/New/Project/Java Project)

2. When prompted for the 'Project name', use the name of the directory holding your project on disk.  

   **Project name: my-application**

   The wizard will automatically configure the JRE and the project layout based on the existing source.

3. Add a server runtime to the new project's build path.   

4. If necessary, run the Ant build's 'process-resources' target to retrieve dependencies and extract the SmartGWT runtime.  You may need to refresh your project's contents.

   _Note that this won't be strictly necessary if you've already tested the project using Command Line Tools, but you'll need to repeat this step following any 'ant clean' execution._

5. Create or edit a Tomcat server with a JNDI configuration similar to those found at src/etc/tomcat/context.xml.  Servers/[YOUR SERVER]/context.xml or Servers/[YOUR SERVER]/server.xml (added to the context node)

6. Add the application to the server and launch it.

7. Use any other process / technology to submit an HTTP request to the server.  The sample Java client provides a handful of test messages at src/main/resources, and you can specify the message that's posted with a change to the build's exec-java target.

        ant exec-java

$symbol_pound$symbol_pound Related Topics

- Hosted Mode is being being phased out by GWT and replaced with Super Dev Mode.  You can find an overview of SDM at:

  <http://www.gwtproject.org/articles/superdevmode.html>

- For more details about how to set up or use SDM, see our online Smart GWT SDM Troubleshooting help topic at 

  <http://www.smartclient.com/smartgwt/javadoc/com/smartgwt/client/docs/SuperDevModeTroubleshooting.html>

- See our debugging overview at <http://www.smartclient.com/smartgwt/javadoc/com/smartgwt/client/docs/Debugging.html>
