/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.util;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Provides a mechanism for canceling asynchronous operations.
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("CancellationController")
public class CancellationController extends BaseClass {

    public static CancellationController getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        BaseClass obj = BaseClass.getRef(jsObj);
        if(obj != null) {
            return (CancellationController) obj;
        } else {
            return new CancellationController(jsObj);
        }
    }

    public void setJavaScriptObject(JavaScriptObject jsObj) {
        internalSetID(jsObj);
        JSOHelper.setObjectAttribute(jsObj, SC.REF, this);
        JSOHelper.setObjectAttribute(jsObj, SC.MODULE, BeanFactory.getSGWTModule());
        if (!JSOHelper.isScClassInstance(jsObj)) {
            setConfig(jsObj);
            return;
        }
        JSOHelper.setObjectAttribute(getConfig(), SC.REF, this);
        JSOHelper.setObjectAttribute(getConfig(), SC.MODULE, BeanFactory.getSGWTModule());
        this.jsObj = jsObj;
        onBind();
    }
        


    public CancellationController(){
        scClassName = "CancellationController";
    }

    public CancellationController(JavaScriptObject jsObj){
        scClassName = "CancellationController";
        setJavaScriptObject(jsObj);
    }

    public native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.core.BaseClass::getConfig()();
        var scClassName = this.@com.smartgwt.client.core.BaseClass::scClassName;
        return $wnd.isc[scClassName].create(config);
    }-*/;

    private JavaScriptObject jsObj;
    
    @Override
    public boolean isCreated(){
        return this.jsObj != null;
    }

    @Override
    public JavaScriptObject getJsObj(){
        return this.jsObj;
    }

    @Override
    public JavaScriptObject getOrCreateJsObj() {
        if (!isCreated()) {
            this.jsObj = createJsObj();
            doInit();
        }
        return this.jsObj;
    }


    // ********************* Properties / Attributes ***********************

    /**
     * Whether {@link com.smartgwt.client.util.CancellationController#cancel cancel()} has been called.
     * <p>
     * <b>Note :</b> This method should be called only after the underlying component has been created.
     *
     * @return Current canceled value. Default value is false
     * @throws IllegalStateException if the underlying component has not yet been created.
     */
    public Boolean getCanceled() throws IllegalStateException {
        errorIfNotCreated("canceled");
        Boolean result = getAttributeAsBoolean("canceled");
        return result == null ? false : result;
    }
    

    /**
     * The reason, if any, passed to the first call to {@link com.smartgwt.client.util.CancellationController#cancel cancel()}.
     * <p>
     * <b>Note :</b> This method should be called only after the underlying component has been created.
     *
     * @return Current cancellationReason value. Default value is null
     * @throws IllegalStateException if the underlying component has not yet been created.
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getCancellationReason() throws IllegalStateException {
        errorIfNotCreated("cancellationReason");
        return getAttributeAsString("cancellationReason");
    }
    

    // ********************* Methods ***********************
	/**
     * Requests cancellation of all asynchronous operations that are polling {@link
     * com.smartgwt.client.util.CancellationController#getCanceled canceled} or  observing this method. Also cancels any {@link
     * com.smartgwt.client.util.CancellationController#createSubController sub-<code>CancellationController</code>}s of this
     * <code>CancellationController</code> that are not already canceled. <p> {@link
     * com.smartgwt.client.util.CancellationController#getCancellationReason this.cancellationReason} is set to the provided
     * <code>reason</code> only on the first call to cancel(). <p> For observers of this method, the recommended practice is to
     * capture the <code>returnVal</code> and only perform the cancellation steps if the <code>returnVal</code> was
     * <code>true</code>. This is because it could happen that cancel() is called a second time before the observers finish.
     *
     * @return <code>true</code> if this was the first call to cancel(); <code>false</code> otherwise.
     */
    public native Boolean cancel() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "cancel", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.cancel();
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;

	/**
     * Requests cancellation of all asynchronous operations that are polling {@link
     * com.smartgwt.client.util.CancellationController#getCanceled canceled} or  observing this method. Also cancels any {@link
     * com.smartgwt.client.util.CancellationController#createSubController sub-<code>CancellationController</code>}s of this
     * <code>CancellationController</code> that are not already canceled. <p> {@link
     * com.smartgwt.client.util.CancellationController#getCancellationReason this.cancellationReason} is set to the provided
     * <code>reason</code> only on the first call to cancel(). <p> For observers of this method, the recommended practice is to
     * capture the <code>returnVal</code> and only perform the cancellation steps if the <code>returnVal</code> was
     * <code>true</code>. This is because it could happen that cancel() is called a second time before the observers finish.
     * @param reason A reason for cancellation.
     * See {@link com.smartgwt.client.docs.HTMLString HTMLString}
     *
     * @return <code>true</code> if this was the first call to cancel(); <code>false</code> otherwise.
     */
    public native Boolean cancel(String reason) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "cancel", "String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.cancel(reason);
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;
	
	/**
     * Creates a new {@link com.smartgwt.client.util.CancellationController} which is canceled whenever this
     * <code>CancellationController</code> is canceled. <p> Note that the sub-<code>CancellationController</code> may be
     * independently canceled before this parent <code>CancellationController</code> is canceled.
     *
     * @return a new {@link com.smartgwt.client.util.CancellationController} that is canceled whenever this
     * <code>CancellationController</code> is canceled.
     */
    public native CancellationController createSubController() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "createSubController", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.createSubController();
        if(ret == null) return null;
        return @com.smartgwt.client.util.CancellationController::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;


    // ********************* Static Methods ***********************

    // ***********************************************************

}
