/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.TestResultDao;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.model.TestResult;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LastPassBatchDao
extends ConfiguredBase {
    private static Logger log = new Logger(BatchRunDao.class.getName());
    public static final String LAST_PASS_FIELD = "lastPass";
    public static final String LAST_FAIL_FIELD = "lastFail";

    public static void fetchLastPass(List<TestResult> results) {
        if (results.size() == 0) {
            return;
        }
        TestResult first = results.get(0);
        log.info((Object)("Received " + results.size() + " results to fill in with last pass batches for batch " + first.getBatchStartTime() + ", branch " + first.getBranch() + ", test suite " + first.getTestSuite()));
        try {
            DSRequest dsReq = new DSRequest("lastPassBatch", "fetch");
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("branch", first.getBranch());
            criteria.put("suiteName", first.getTestSuiteAsKey());
            dsReq.setCriteria(criteria);
            DSResponse dsResp = dsReq.execute();
            List data = dsResp.getDataList();
            Map<String, TestResult> resultMap = TestRunner.processBatch(results);
            for (Object dataRow : data) {
                Map row = (Map)dataRow;
                String testName = (String)row.get("testFile");
                int testNumber = (Integer)row.get("testNumber");
                TestResult result = resultMap.get(testName + "_" + testNumber);
                if (result == null) continue;
                result.setLastPassBatchStartTime((Date)row.get(LAST_PASS_FIELD));
                Integer countState = (Integer)row.get("countState");
                if (countState == null) continue;
                result.setResultCountState(countState);
            }
        }
        catch (Exception e) {
            log.error((Object)("unable to fetch last pass info for batch " + first.getBatchStartTime() + ", branch " + first.getBranch() + ", test suite " + first.getTestSuite()), (Throwable)e);
        }
    }

    public static void updateLastPass(List<TestResult> results) {
        if (results.size() == 0) {
            return;
        }
        TestResult first = results.get(0);
        log.info((Object)("Received " + results.size() + " results to process for 'update last passing batch' operation for batch " + first.getBatchStartTime() + ", branch " + first.getBranch() + ", test suite " + first.getTestSuite()));
        HashSet<String> bindings = new HashSet<String>();
        Date newest = null;
        try {
            DSRequest dsReq = new DSRequest("lastPassBatch", "fetch");
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("branch", first.getBranch());
            criteria.put("suiteName", first.getTestSuiteAsKey());
            dsReq.setCriteria(criteria);
            DSResponse dsResp = dsReq.execute();
            List data = dsResp.getDataList();
            for (Object dataRow : data) {
                Date failDate;
                Map row = (Map)dataRow;
                String testName = (String)row.get("testFile");
                int testNumber = (Integer)row.get("testNumber");
                Date passDate = (Date)row.get(LAST_PASS_FIELD);
                if (passDate != null && (newest == null || newest.before(passDate))) {
                    newest = passDate;
                }
                if ((failDate = (Date)row.get(LAST_FAIL_FIELD)) != null && (newest == null || newest.before(failDate))) {
                    newest = failDate;
                }
                bindings.add(testName + "_" + testNumber);
            }
        }
        catch (Exception e) {
            log.error((Object)("unable to fetch pass/fail info for batch " + first.getBatchStartTime() + ", branch " + first.getBranch() + ", test suite " + first.getTestSuite()), (Throwable)e);
        }
        ArrayList<DSRequest> batch = new ArrayList<DSRequest>();
        boolean after = newest == null ? true : first.getBatchStartTime().after(newest);
        for (int i = 0; i < results.size(); ++i) {
            TestResult tr = results.get(i);
            if (!tr.isSuccess() && !tr.isFailure()) continue;
            try {
                DSRequest dsReq;
                boolean hasBinding = bindings.contains(tr.getTestKey());
                if (!hasBinding) {
                    dsReq = new DSRequest("lastPassBatch", "add");
                    HashMap<String, Object> rows = new HashMap<String, Object>();
                    rows.put("branch", tr.getBranch());
                    rows.put("testFile", tr.getTestFile());
                    rows.put("testNumber", tr.getTestNumber());
                    rows.put("suiteName", tr.getTestSuiteAsKey());
                    rows.put(tr.isSuccess() ? LAST_PASS_FIELD : LAST_FAIL_FIELD, tr.getBatchStartTime());
                    dsReq.setValues(rows);
                    dsReq.forceInvalidateCache(true);
                    batch.add(dsReq);
                    continue;
                }
                if (!after) continue;
                dsReq = new DSRequest("lastPassBatch", "update");
                HashMap<String, Object> criteria = new HashMap<String, Object>();
                criteria.put("branch", tr.getBranch());
                criteria.put("testFile", tr.getTestFile());
                criteria.put("testNumber", tr.getTestNumber());
                criteria.put("suiteName", tr.getTestSuiteAsKey());
                dsReq.setCriteria(criteria);
                dsReq.setFieldValue((Object)(tr.isSuccess() ? LAST_PASS_FIELD : LAST_FAIL_FIELD), (Object)tr.getBatchStartTime());
                dsReq.forceInvalidateCache(true);
                batch.add(dsReq);
                continue;
            }
            catch (Exception e) {
                log.error((Object)("unable to build last pass/fail add/update DSRequest for test result " + tr.getTestKey() + ", batch " + tr.getBatchStartTime() + ", test suite " + tr.getTestSuite()), (Throwable)e);
            }
        }
        if (batch.size() == 0) {
            return;
        }
        log.info((Object)("about to commit " + batch.size() + " DSRequests to update last pass/fail info for batch " + first.getBatchStartTime() + ", branch " + first.getBranch() + ", test suite " + first.getTestSuite()));
        try {
            SQLDataSource testResultDS = (SQLDataSource)((DSRequest)batch.get(0)).getDataSource();
            SQLDataSource.executeAsBatch(batch);
        }
        catch (Exception e) {
            log.error((Object)("unable to update last pass/fail info for batch " + first.getBatchStartTime() + ", branch " + first.getBranch() + ", test suite " + first.getTestSuite()), (Throwable)e);
        }
    }

    public static void updateCountState(List<TestResult> results) {
        if (results.size() == 0) {
            return;
        }
        TestResult first = results.get(0);
        HashMap<String, TestResult> map = new HashMap<String, TestResult>();
        for (int i = 0; i < results.size(); ++i) {
            TestResult testResult = results.get(i);
            map.put(testResult.getTestKey(), testResult);
        }
        String branch = first.getBranch();
        String suiteName = first.getTestSuiteAsKey();
        ArrayList<DSRequest> batch = new ArrayList<DSRequest>();
        try {
            DSRequest dsReq = new DSRequest("lastPassBatch", "fetch");
            HashMap<String, Object> criteria = new HashMap<String, Object>();
            criteria.put("branch", branch);
            criteria.put("suiteName", suiteName);
            dsReq.setCriteria(criteria);
            DSResponse dsResp = dsReq.execute();
            List data = dsResp.getDataList();
            for (Object dataRow : data) {
                int notificationCount;
                Map row = (Map)dataRow;
                String testName = (String)row.get("testFile");
                int testNumber = (Integer)row.get("testNumber");
                TestResult testResult = (TestResult)map.get(testName + "_" + testNumber);
                if (testResult == null || !testResult.isSuccess() && !testResult.isFailure() || (notificationCount = testResult.getNotificationCount()) == 0) continue;
                Integer countState = (Integer)row.get("countState");
                Integer countDelta = testResult.isSuccess() ? 1 : -1;
                if (countState != null && countState * countDelta < 0) {
                    countState = countState + countDelta;
                }
                if (countState == null || countState * countDelta >= 0) {
                    countState = notificationCount * countDelta;
                }
                try {
                    dsReq = new DSRequest("lastPassBatch", "update");
                    criteria = new HashMap();
                    criteria.put("branch", branch);
                    criteria.put("testFile", testName);
                    criteria.put("testNumber", testNumber);
                    criteria.put("suiteName", suiteName);
                    dsReq.setCriteria(criteria);
                    dsReq.setFieldValue((Object)"countState", (Object)countState);
                    dsReq.forceInvalidateCache(true);
                    batch.add(dsReq);
                }
                catch (Exception e) {
                    log.error((Object)("unable to build countState update DSRequest for test result " + testResult.getTestKey() + ", batch " + testResult.getBatchStartTime() + ", test suite " + suiteName), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"updateCountState(): unable to complete countState update", (Throwable)e);
        }
        if (batch.size() == 0) {
            return;
        }
        log.info((Object)("about to commit " + batch.size() + " DSRequests to update wobbler countState data for batch " + first.getBatchStartTime() + ", branch " + branch + ", test suite " + suiteName));
        try {
            SQLDataSource testResultDS = (SQLDataSource)((DSRequest)batch.get(0)).getDataSource();
            SQLDataSource.executeAsBatch(batch);
        }
        catch (Exception e) {
            log.error((Object)("unable to update wobbler countState data for batch " + first.getBatchStartTime() + ", branch " + branch + ", test suite " + suiteName), (Throwable)e);
        }
    }

    private static void addOldResult(Map<String, String> map, String key, boolean forceReport, Date lastPass, Date lastFail) {
        String oldResult = null;
        if (lastPass != null && (lastFail == null || lastPass.after(lastFail))) {
            oldResult = "success";
        }
        if (lastFail != null && (lastPass == null || lastFail.after(lastPass))) {
            oldResult = "failure";
        }
        LastPassBatchDao.addOldResult(map, key, forceReport, oldResult);
    }

    private static void addOldResult(Map<String, String> map, String key, boolean forceReport, String oldResult) {
        String binding = map.get(key);
        if (binding != null || oldResult == null) {
            return;
        }
        if (forceReport) {
            oldResult = "unknown";
        }
        map.put(key, oldResult);
    }

    public static Map<String, String> getLastTestResults(List<TestResult> baselineResults) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (baselineResults.size() == 0) {
            return map;
        }
        boolean livePredecessorBatch = false;
        TestResult first = baselineResults.get(0);
        try {
            List<Date> batchTimes = TestResultDao.getLastBatchesTime(first.getTestSuite(), first.getBranch());
            for (int i = 0; i < batchTimes.size(); ++i) {
                Date currentBatchStartTime = batchTimes.get(i);
                if (currentBatchStartTime.after(first.getBatchStartTime())) continue;
                if (BatchRunDao.isBatchAnalyzed(currentBatchStartTime)) {
                    try {
                        DSRequest dsReq = new DSRequest("lastPassBatch", "fetch");
                        HashMap<String, String> criteria = new HashMap<String, String>();
                        criteria.put("branch", first.getBranch());
                        criteria.put("suiteName", first.getTestSuiteAsKey());
                        dsReq.setCriteria(criteria);
                        DSResponse dsResp = dsReq.execute();
                        List data = dsResp.getDataList();
                        for (Object dataRow : data) {
                            Map row = (Map)dataRow;
                            String testName = (String)row.get("testFile");
                            int testNumber = (Integer)row.get("testNumber");
                            Date passDate = (Date)row.get(LAST_PASS_FIELD);
                            Date failDate = (Date)row.get(LAST_FAIL_FIELD);
                            LastPassBatchDao.addOldResult(map, testName + "_" + testNumber, livePredecessorBatch, passDate, failDate);
                        }
                        break;
                    }
                    catch (Exception e) {
                        log.error((Object)("can't add last pass/fail results from pass/fail table for batch " + currentBatchStartTime + ", test suite " + first.getTestSuite()), (Throwable)e);
                        break;
                    }
                }
                if (!BatchRunDao.isTestSuiteDone(currentBatchStartTime, first.getTestSuite())) {
                    livePredecessorBatch = true;
                }
                try {
                    List<TestResult> oldResults = TestResultDao.getTestsForBatch(currentBatchStartTime, first.getTestSuite(), first.getBranch());
                    for (TestResult oldResult : oldResults) {
                        LastPassBatchDao.addOldResult(map, oldResult.getTestKey(), livePredecessorBatch, oldResult.getResult());
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("can't add last pass/fail results from committed test results for batch " + currentBatchStartTime + ", test suite " + first.getTestSuite()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"getLastTestResults(): unable to complete generation of the last test results", (Throwable)e);
        }
        return map;
    }
}

