/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.JenkinsBuild;
import com.isomorphic.base.Base;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.HttpUtil;
import com.isomorphic.util.SimpleHttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.client.HttpClient;

public class Jenkins
extends Base {
    private static Logger log = new Logger(Jenkins.class.getName());
    public static boolean debug = false;
    public String baseURL = config.getString((Object)"jenkins.baseURL");
    public String username = config.getString((Object)"jenkins.username");
    public String password = config.getString((Object)"jenkins.password");
    HttpClient httpClient;

    public Jenkins() throws Exception {
        this.setBaseURL(this.baseURL);
        this.httpClient = HttpUtil.getHttpClient();
    }

    public Jenkins(String baseURL, String username, String password) throws Exception {
        this.setBaseURL(baseURL);
        this.username = username;
        this.password = password;
    }

    public void setBaseURL(String baseURL) throws Exception {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public JenkinsBuild triggerBuild(String buildName) throws Exception {
        return this.triggerBuild(buildName, null, null);
    }

    public JenkinsBuild triggerBuild(String buildName, Map buildParams) throws Exception {
        return this.triggerBuild(buildName, buildParams, null);
    }

    public JenkinsBuild triggerBuild(String buildName, Map buildParams, Map _opts) throws Exception {
        String jobURL = this.baseURL + "/job/" + buildName;
        if (buildParams != null) {
            jobURL = jobURL + "/buildWithParameters";
        } else {
            jobURL = jobURL + "/build";
            buildParams = new DataTypeMap();
        }
        DataTypeMap opts = _opts == null ? new DataTypeMap() : new DataTypeMap(_opts);
        JenkinsBuild jenkinsBuild = new JenkinsBuild(this, buildName, buildParams, (Map)opts);
        SimpleHttpResponse httpResponse = this.httpPostWithCrumb(jobURL, buildParams);
        if (!httpResponse.isSuccess()) {
            throw new Exception("Build " + buildName + " FAILED (during submission to Jenkins at endpoint" + jobURL + " - http response code:" + httpResponse.getStatusCode() + ").  Check your buildName and params, if correct, could be network or server failure server said:" + httpResponse.getBodyAsString());
        }
        String queueURL = null;
        HeaderIterator hi = httpResponse.headerIterator("Location");
        if (hi.hasNext()) {
            Header h = (Header)hi.next();
            queueURL = h.getValue();
        }
        if (queueURL == null) {
            throw new Exception("Build " + buildName + " FAILED (during submission to Jenkins at endpoint" + jobURL + " - no queueURL returned).  Check your buildName and params, if correct, could be network or server failure server said:" + httpResponse.getBodyAsString());
        }
        jenkinsBuild.setQueueURL(queueURL);
        long timeout = opts.getLong((Object)"timeout", -1L);
        if (opts.getBoolean((Object)"block", false)) {
            DataTypeMap dataTypeMap = jenkinsBuild.waitForExecutionComplete(timeout);
        }
        return jenkinsBuild;
    }

    public DataTypeMap jsonGet(String url) throws Exception {
        String responseBody;
        if (!url.contains("/api/json")) {
            url = url + "/api/json";
        }
        if ((responseBody = HttpUtil.httpGet((String)url, (Map)DataTools.buildMap((Object[])new Object[]{"httpClient", this.httpClient})).getBodyAsString()) == null) {
            return null;
        }
        Map m = (Map)JSTranslater.instance().fromJS(responseBody);
        if (m == null) {
            return null;
        }
        return new DataTypeMap(m);
    }

    protected SimpleHttpResponse httpPostWithCrumb(String url, Map params) throws Exception {
        return HttpUtil.httpPost((String)url, (Map)DataTools.buildMap((Object[])new Object[]{"params", params, "headers", this.addCrumbHeader(null), "username", this.username, "password", this.password, "httpClient", this.httpClient}));
    }

    protected Map addCrumbHeader(Map headers) throws Exception {
        if (headers == null) {
            headers = new DataTypeMap();
        }
        String crumbURL = this.baseURL + "/crumbIssuer/api/xml?xpath=concat(//crumbRequestField,%22:%22,//crumb)";
        String crumbHeader = HttpUtil.httpGet((String)crumbURL, (Map)DataTools.buildMap((Object[])new Object[]{"numRetriesFileNotFound", 12, "username", this.username, "password", this.password, "httpClient", this.httpClient})).getBodyAsString();
        if (crumbHeader == null) {
            throw new Exception("Couldn't obtain crumb - server returned: " + crumbHeader);
        }
        List s = DataTools.simpleSplit((String)crumbHeader, (String)":");
        if (s.size() != 2) {
            throw new Exception("Couldn't obtain crumb - server returned: " + crumbHeader);
        }
        String crumbRequestField = (String)s.get(0);
        String crumb = (String)s.get(1);
        headers.put(crumbRequestField, crumb);
        return headers;
    }

    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        String cmdLineSyntax = "Jenkins [options] jobName [parameter=value] [parameter2=value]";
        Options options = new Options();
        options.addOption("d", "debug", false, "Output debugging messages");
        OptionBuilder.withArgName((String)"parameter=value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"use value for given parameter");
        Option property = OptionBuilder.create((String)"D");
        options.addOption(property);
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("d")) {
                debug = true;
            }
            if (line.hasOption("h")) {
                Jenkins.outputHelp(cmdLineSyntax, options);
                System.exit(1);
            }
            Properties jobParams = line.getOptionProperties("D");
            List jobNames = line.getArgList();
            if (jobNames.size() == 0) {
                System.err.println("No jobNames specified");
                Jenkins.outputHelp(cmdLineSyntax, options);
                System.exit(1);
            }
            Jenkins jenkins = new Jenkins();
            for (String jobName : jobNames) {
                JenkinsBuild jenkinsBuild = jenkins.triggerBuild(jobName, jobParams);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Caught Exception in main() method", (Throwable)e);
            System.exit(1);
        }
        System.exit(0);
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "\nLaunch a Jenkins job");
    }
}

