/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hsqldb.jdbc.JDBCBlobFile;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.lib.KMPSearchAlgorithm;

public class JDBCClobFile
implements Clob {
    public static final String TEMP_FILE_PREFIX = "hsql_jdbc_clob_file_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private final File m_file;
    private boolean m_closed;
    private boolean m_deleteOnFree;
    private String m_encoding;
    private Charset m_charset;
    private CharsetEncoder m_encoder;
    private boolean m_fixedWidthCharset;
    private int m_maxCharWidth;
    private List m_streams = new ArrayList();

    @Override
    public long length() throws SQLException {
        this.checkClosed();
        if (this.m_fixedWidthCharset) {
            return this.m_file.length() / (long)this.m_maxCharWidth;
        }
        ReaderAdapter readerAdapter = null;
        try {
            long l;
            readerAdapter = new ReaderAdapter(this.m_file, 0L, Long.MAX_VALUE);
            long l2 = l = readerAdapter.skip(Long.MAX_VALUE);
            return l2;
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            if (readerAdapter != null) {
                try {
                    readerAdapter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        Reader reader = null;
        CharArrayWriter charArrayWriter = null;
        try {
            int n2 = Math.min(8192, n);
            reader = this.getCharacterStream(l, n);
            charArrayWriter = new CharArrayWriter(n2);
            InOutUtil.copy(reader, charArrayWriter, (long)n);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return charArrayWriter.toString();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.getCharacterStream(1L, Long.MAX_VALUE);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        JDBCBlobFile.InputStreamAdapter inputStreamAdapter;
        try {
            inputStreamAdapter = new JDBCBlobFile.InputStreamAdapter(this.m_file, 0L, Long.MAX_VALUE){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.m_streams.add(inputStreamAdapter);
        return inputStreamAdapter;
    }

    public long position(char[] cArray, long l) throws SQLException {
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l);
        }
        if (cArray == null || cArray.length == 0 || l > this.length()) {
            return -1L;
        }
        Reader reader = null;
        try {
            reader = this.getCharacterStream(l, Long.MAX_VALUE);
            long l2 = KMPSearchAlgorithm.search(reader, cArray, KMPSearchAlgorithm.computeTable(cArray));
            long l3 = l2 == -1L ? -1L : l + l2;
            return l3;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public long position(String string, long l) throws SQLException {
        return this.position(string == null ? null : string.toCharArray(), l);
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        char[] cArray;
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l);
        }
        long l2 = clob == null ? 0L : clob.length();
        if (l2 == 0L) {
            return -1L;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw JDBCUtil.outOfRangeArgument("pattern.length(): " + l2);
        }
        if (clob instanceof JDBCClob) {
            cArray = ((JDBCClob)clob).data().toCharArray();
        } else {
            Reader reader = null;
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            try {
                reader = clob.getCharacterStream();
                InOutUtil.copy(reader, charArrayWriter, l2);
            }
            catch (IOException iOException) {
                throw JDBCUtil.sqlException(iOException);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            cArray = charArrayWriter.toCharArray();
        }
        return this.position(cArray, l);
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string == null ? 0 : string.length());
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (string == null) {
            throw JDBCUtil.nullArgument("str");
        }
        Writer writer = null;
        try {
            writer = this.setCharacterStream(l);
            writer.write(string, n, n2);
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        return n2;
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        JDBCBlobFile.OutputStreamAdapter outputStreamAdapter;
        if (l < 1L) {
            throw JDBCUtil.invalidArgument("pos: " + l);
        }
        this.checkClosed();
        this.createFile();
        try {
            outputStreamAdapter = new JDBCBlobFile.OutputStreamAdapter(this.m_file, l - 1L){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.m_streams.add(outputStreamAdapter);
        return outputStreamAdapter;
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        BufferedWriter bufferedWriter;
        if (l < 1L) {
            throw JDBCUtil.invalidArgument("pos: " + l);
        }
        this.checkClosed();
        this.createFile();
        try {
            WriterAdapter writerAdapter = new WriterAdapter(this.m_file, l - 1L){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
            bufferedWriter = new BufferedWriter(writerAdapter);
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.m_streams.add(bufferedWriter);
        return bufferedWriter;
    }

    @Override
    public void truncate(long l) throws SQLException {
        if (l < 0L) {
            throw JDBCUtil.invalidArgument("len: " + l);
        }
        this.checkClosed();
        ReaderAdapter readerAdapter = null;
        RandomAccessFile randomAccessFile = null;
        try {
            readerAdapter = new ReaderAdapter(this.m_file, l, Long.MAX_VALUE);
            long l2 = readerAdapter.getFilePointer();
            readerAdapter.close();
            randomAccessFile = new RandomAccessFile(this.m_file, "rw");
            randomAccessFile.setLength(l2);
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            if (readerAdapter != null) {
                try {
                    readerAdapter.close();
                }
                catch (Exception exception) {}
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.m_streams);
        this.m_streams = null;
        for (Object e : arrayList) {
            if (e instanceof InputStream) {
                try {
                    ((InputStream)e).close();
                }
                catch (Exception exception) {}
                continue;
            }
            if (!(e instanceof OutputStream)) continue;
            try {
                ((OutputStream)e).close();
            }
            catch (Exception exception) {}
        }
        if (this.m_deleteOnFree) {
            try {
                this.m_file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        ReaderAdapter readerAdapter;
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        --l;
        if (l2 < 0L) {
            throw JDBCUtil.outOfRangeArgument("length: " + l2);
        }
        try {
            readerAdapter = new ReaderAdapter(this.m_file, l, l2){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.m_streams.add(readerAdapter);
        return readerAdapter;
    }

    public File getFile() {
        return this.m_file;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public boolean isDeleteOnFree() {
        return this.m_deleteOnFree;
    }

    public void setDeleteOnFree(boolean bl) {
        this.m_deleteOnFree = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            try {
                this.free();
            }
            catch (Throwable throwable) {}
        }
    }

    public JDBCClobFile() throws SQLException {
        this((String)null);
    }

    public JDBCClobFile(String string) throws SQLException {
        try {
            this.setEncoding(string);
            this.m_file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            this.m_deleteOnFree = true;
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
    }

    public JDBCClobFile(File file) throws SQLException {
        this(file, null);
    }

    public JDBCClobFile(File file, String string) throws SQLException {
        if (file == null) {
            throw JDBCUtil.nullArgument("file");
        }
        try {
            this.setEncoding(string);
            this.m_file = file.getCanonicalFile();
            this.checkIsFile(false);
            this.m_deleteOnFree = false;
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
    }

    protected final void setEncoding(String string) throws UnsupportedEncodingException {
        boolean bl;
        Charset charset = JDBCClobFile.charsetForName(string);
        CharsetEncoder charsetEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        float f = charsetEncoder.maxBytesPerChar();
        float f2 = charsetEncoder.averageBytesPerChar();
        this.m_fixedWidthCharset = bl = f == (float)Math.round(f) && f == f2;
        this.m_maxCharWidth = Math.round(f);
        this.m_charset = charset;
        this.m_encoder = charsetEncoder;
        this.m_encoding = this.m_charset.name();
    }

    protected static Charset charsetForName(String string) throws UnsupportedEncodingException {
        String string2 = string;
        if (string2 == null) {
            string2 = Charset.defaultCharset().name();
        }
        try {
            if (Charset.isSupported(string2)) {
                return Charset.forName(string2);
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        throw new UnsupportedEncodingException(string2);
    }

    protected final void checkIsFile(boolean bl) throws SQLException {
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = this.m_file.exists();
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        if (bl2) {
            try {
                bl3 = this.m_file.isFile();
            }
            catch (Exception exception) {
                throw JDBCUtil.sqlException(exception);
            }
        }
        if (bl2) {
            if (!bl3) {
                throw JDBCUtil.invalidArgument("Is not a file: " + this.m_file);
            }
        } else if (bl) {
            throw JDBCUtil.invalidArgument("Does not exist: " + this.m_file);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    protected void createFile() throws SQLException {
        try {
            if (!this.m_file.exists()) {
                FileUtil.getFileUtil().makeParentDirectories(this.m_file);
                this.m_file.createNewFile();
            }
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.checkIsFile(true);
    }

    protected class ReaderAdapter
    extends Reader {
        private static final int CHARBUFFER_CAPACTIY = 128;
        private final Reader m_reader;
        private long m_remaining = Long.MAX_VALUE;
        private long m_filePointer;
        private ByteBuffer m_byteBuffer;
        private CharBuffer m_charBuffer;

        public ReaderAdapter(File file, long l, long l2) throws FileNotFoundException, IOException {
            int n;
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (l < 0L) {
                throw new IllegalArgumentException("pos: " + l);
            }
            if (l2 < 0L) {
                throw new IllegalArgumentException("length: " + l2);
            }
            if (!JDBCClobFile.this.m_fixedWidthCharset) {
                int n2 = 128 * JDBCClobFile.this.m_maxCharWidth;
                this.m_charBuffer = CharBuffer.allocate(128);
                this.m_byteBuffer = ByteBuffer.allocate(n2);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, JDBCClobFile.this.m_charset);
            this.m_reader = inputStreamReader;
            for (long i = 0L; i < l && (n = this.read()) != -1; ++i) {
            }
            this.m_remaining = l2;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3;
            int n4;
            long l = this.m_remaining;
            if (l <= 0L) {
                return -1;
            }
            if (l < (long)n2) {
                n2 = (int)l;
            }
            if ((n4 = this.m_reader.read(cArray, n, n2)) == -1) {
                return -1;
            }
            if ((long)n4 > l) {
                n4 = (int)l;
                this.m_remaining = 0L;
            } else {
                this.m_remaining -= (long)n4;
            }
            if (JDBCClobFile.this.m_fixedWidthCharset) {
                n3 = JDBCClobFile.this.m_maxCharWidth * n4;
            } else {
                boolean bl = n4 > this.m_charBuffer.capacity();
                CharBuffer charBuffer = bl ? CharBuffer.allocate(n4) : this.m_charBuffer;
                ByteBuffer byteBuffer = bl ? ByteBuffer.allocate(n4 * JDBCClobFile.this.m_maxCharWidth) : this.m_byteBuffer;
                charBuffer.clear();
                byteBuffer.clear();
                charBuffer.put(cArray, n, n4);
                charBuffer.flip();
                JDBCClobFile.this.m_encoder.encode(charBuffer, byteBuffer, true);
                byteBuffer.flip();
                n3 = byteBuffer.limit();
                if (bl) {
                    this.m_byteBuffer = byteBuffer;
                    this.m_charBuffer = charBuffer;
                }
            }
            this.m_filePointer += (long)n3;
            return n4;
        }

        @Override
        public void close() throws IOException {
            this.m_reader.close();
        }

        public long getFilePointer() {
            return this.m_filePointer;
        }
    }

    protected class WriterAdapter
    extends Writer {
        private final RandomAccessFile m_randomAccessFile;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WriterAdapter(File file, long l) throws FileNotFoundException, IOException {
            long l2;
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (l < 0L) {
                throw new IllegalArgumentException("pos: " + l);
            }
            ReaderAdapter readerAdapter = null;
            try {
                readerAdapter = new ReaderAdapter(file, l, Long.MAX_VALUE);
                l2 = readerAdapter.getFilePointer();
            }
            finally {
                if (readerAdapter != null) {
                    try {
                        readerAdapter.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.m_randomAccessFile = new RandomAccessFile(file, "rw");
            this.m_randomAccessFile.seek(l2);
        }

        @Override
        public void flush() throws IOException {
            this.m_randomAccessFile.getFD().sync();
        }

        @Override
        public void close() throws IOException {
            this.m_randomAccessFile.close();
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = JDBCClobFile.this.m_encoding == null ? new OutputStreamWriter(byteArrayOutputStream) : new OutputStreamWriter((OutputStream)byteArrayOutputStream, JDBCClobFile.this.m_charset);
            outputStreamWriter.write(cArray, n, n2);
            outputStreamWriter.close();
            this.m_randomAccessFile.write(byteArrayOutputStream.toByteArray());
        }
    }
}

