/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.NightlyBuildStatusDao;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestResultDao;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.Utils;
import com.isomorphic.autotest.model.TestResult;
import com.isomorphic.base.ISCInit;
import com.isomorphic.devenv.DevUtil;
import com.isomorphic.log.Logger;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class BatchEvaluator {
    private static Logger log = new Logger(BatchEvaluator.class.getName());
    protected static final int OPTIONS_MISSING = 5;
    protected static final int NO_NEW_COMMITS = 10;
    protected static final int NEVER_VALIDATED = 15;
    protected static final int BATCH_RUN_FAILED = 20;
    protected static final int THRESHOLD_REJECT = 30;
    protected static final int BATCH_CHECK_INTERVAL = 60000;

    public static void main(String[] args) throws Exception {
        String status;
        int checkAttempt;
        ISCInit.go((String)BatchEvaluator.class.getName());
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        Option branchOption = new Option("br", "branch", true, "Branch to evaluate");
        branchOption.setRequired(true);
        options.addOption(branchOption);
        TestRunnerLauncher config = new TestRunnerLauncher();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            TestRunner.setConfiguration(config);
            config.installOptionValues(line);
            config.initFileRoot();
        }
        catch (MissingOptionException moe) {
            Utils.outputHelp("batchEvaluator [OPT1] [ARG1] [OPT2] [ARG2] ...", options, moe.getMessage());
            System.exit(5);
        }
        String branch = config.getBranch();
        Date targetBatch = BatchRunDao.getLastBatchFromPreviousDay(branch);
        if (targetBatch == null) {
            System.exit(10);
        }
        int maxAttempts = (config.getJenkinsMaximumLifespan() + 1200000) / 60000;
        for (checkAttempt = 0; checkAttempt < maxAttempts && !BatchRunDao.isBatchValidated(targetBatch); ++checkAttempt) {
            Thread.sleep(60000L);
        }
        if (checkAttempt >= maxAttempts) {
            System.exit(15);
        }
        if (!"success".equals(status = BatchRunDao.getBatchProperty(targetBatch, "completionStatus"))) {
            System.exit(20);
        }
        List<String> showcases = ShowcaseSpecifier.getValidShowcases(branch, null);
        for (int i = 0; i < showcases.size(); ++i) {
            double passRatio;
            double d = passRatio = DevUtil.compareBranches(branch, "MAIN") < 0 ? 0.95 : 0.9;
            if (!(BatchEvaluator.getPassRatio(targetBatch, showcases.get(i), branch) < passRatio)) continue;
            System.exit(30 + i);
        }
        String awsInstanceId = BatchRunDao.getAwsInstanceId(targetBatch);
        try {
            NightlyBuildStatusDao.add(branch, awsInstanceId);
            log.info((Object)("Adding binding for branch " + branch + " in NightlyBuildStatus table to " + awsInstanceId));
        }
        catch (Exception e) {
            NightlyBuildStatusDao.update(branch, awsInstanceId);
            log.info((Object)("Replacing binding for branch " + branch + " in NightlyBuildStatus table with " + awsInstanceId));
        }
        System.exit(0);
    }

    protected static double getPassRatio(Date targetBatch, String showcase, String branch) throws Exception {
        List<TestResult> tests = TestResultDao.getTestsForBatch(targetBatch, showcase, branch);
        TestRunner.compareBatches(tests, tests);
        double ratio = TestRunner.getPassRatio();
        TestRunner.clearTestResults();
        return ratio;
    }

    protected static boolean isStatusError(int status) {
        return status != 0 && status != 10;
    }
}

