/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css.ast;

import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssCompilerException;
import com.google.gwt.resources.css.ast.CssNode;
import com.google.gwt.resources.css.ast.CssVisitor;
import java.util.List;

public class CssModVisitor
extends CssVisitor {
    private boolean didChange;

    protected static void checkReplacement(CssNode origNode, CssNode newNode) {
        if (newNode == null) {
            throw new CssCompilerException("Cannot replace with null");
        }
        if (newNode == origNode) {
            throw new CssCompilerException("The replacement is the same as the original");
        }
    }

    public boolean didChange() {
        return this.didChange;
    }

    @Override
    protected void doAcceptWithInsertRemove(List<? extends CssNode> list) {
        ListContext context = new ListContext();
        context.traverse(list);
    }

    private class ListContext<T extends CssNode>
    implements Context {
        private int index;
        private List list;
        private boolean removed;
        private boolean replaced;

        private ListContext() {
        }

        @Override
        public boolean canInsert() {
            return true;
        }

        @Override
        public boolean canRemove() {
            return true;
        }

        @Override
        public void insertAfter(CssNode node) {
            this.checkRemoved();
            this.list.add(this.index + 1, node);
            CssModVisitor.this.didChange = true;
        }

        @Override
        public void insertBefore(CssNode node) {
            this.checkRemoved();
            this.list.add(this.index++, node);
            CssModVisitor.this.didChange = true;
        }

        @Override
        public void removeMe() {
            this.checkState();
            this.list.remove(this.index--);
            this.removed = true;
            CssModVisitor.this.didChange = true;
        }

        @Override
        public void replaceMe(CssNode node) {
            this.checkState();
            CssModVisitor.checkReplacement((CssNode)this.list.get(this.index), node);
            this.list.set(this.index, node);
            this.replaced = true;
            CssModVisitor.this.didChange = true;
        }

        protected void traverse(List<? extends CssNode> list) {
            this.list = list;
            this.index = 0;
            while (this.index < list.size()) {
                this.replaced = false;
                this.removed = false;
                CssModVisitor.this.doTraverse(list.get(this.index), this);
                ++this.index;
            }
        }

        private void checkRemoved() {
            if (this.removed) {
                throw new CssCompilerException("Node was already removed");
            }
        }

        private void checkState() {
            this.checkRemoved();
            if (this.replaced) {
                throw new CssCompilerException("Node was already replaced");
            }
        }
    }
}

