/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.MemoryDataSource;
import com.isomorphic.datasource.MemoryStore;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.xml.XML;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class FileDataSource
extends MemoryDataSource {
    private static Logger log = new Logger(FileDataSource.class.getName());
    DataTypeMap serverConfig;
    String fileName;
    String dataFormat;
    String storeName;

    @Override
    public void initRequest(DSRequest dsRequest) throws Exception {
        this.serverConfig = this.getServerConfig(dsRequest);
        if (this.serverConfig == null) {
            throw new Exception("You must define a serverConfig");
        }
        this.fileName = this.serverConfig.getString("fileName");
        if (this.fileName == null) {
            throw new Exception("You must define a fileName");
        }
        this.storeName = this.fileName.intern();
        this.dataFormat = this.serverConfig.getString("dataFormat", this.getConfig().getString("dataFormat"));
        if (this.dataFormat == null) {
            this.dataFormat = "json";
        }
        if (!"xml".equals(this.dataFormat) && !"json".equals(this.dataFormat)) {
            throw new Exception("Unsupported dataFormat: " + this.dataFormat);
        }
        this.getConfig().put("tableName", this.fileName);
        super.initRequest(dsRequest);
    }

    @Override
    public DSResponse executeFetch(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeUpdate(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeAdd(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeRemove(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeCustom(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeReplace(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeDownload(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DSResponse processRequest(DSRequest dsRequest) throws Exception {
        this.initRequest(dsRequest);
        String opType = dsRequest.getOperationType();
        DataSource dataSource = dsRequest.getDataSource();
        String string = this.storeName;
        synchronized (string) {
            DSResponse dsResponse;
            MemoryStore.deleteStore(this.storeName);
            MemoryStore.createStore(this.storeName, dataSource);
            Collection data = null;
            ISCFile iscFile = ISCFile.newInstance(this.fileName);
            if (iscFile.exists() && iscFile.length() != 0L) {
                Reader reader = iscFile.getReader();
                if ("json".equals(this.dataFormat)) {
                    data = (Collection)JSTranslater.instance().fromJS(iscFile.getReader());
                } else if ("xml".equals(this.dataFormat)) {
                    data = (Collection)XML.toDSRecords(iscFile);
                }
            } else {
                log.info("Will create: " + this.fileName);
                data = new ArrayList();
            }
            for (Map row : data) {
                MemoryStore.insert(this.storeName, row);
            }
            if (FileDataSource.isAdd(opType)) {
                dsResponse = super.executeAdd(dsRequest);
            } else if (FileDataSource.isUpdate(opType)) {
                dsResponse = super.executeUpdate(dsRequest);
            } else if (FileDataSource.isFetch(opType)) {
                dsResponse = super.executeFetch(dsRequest);
            } else if (FileDataSource.isRemove(opType)) {
                dsResponse = super.executeRemove(dsRequest);
            } else {
                throw new Exception("Operation: " + opType + " not supported");
            }
            if (!FileDataSource.isFetch(opType) || this.serverConfig.getBoolean((Object)"storeOnFetch", false)) {
                Collection<Map<String, Object>> store = MemoryStore.getStore(this.storeName);
                Writer writer = iscFile.getWriter();
                if ("json".equals(this.dataFormat)) {
                    JSTranslater.instance().enablePrettyPrinting().toJS(store, writer);
                } else if ("xml".equals(this.dataFormat)) {
                    XML.collectionsToXML(writer, store, "records");
                }
                writer.close();
            }
            MemoryStore.deleteStore(this.storeName);
            return dsResponse;
        }
    }
}

