// This creates the chart from the inline data.
// Note that the inline data is defined in the next tab.
isc.FacetChart.create({
    autoDraw: false,
    ID: "multiSeriesChart",
    title: "Revenue",
    minWidth: 550,
    minHeight: 400,

    // You use facets to define the ways in which you would like the chart to
    // break down the data. In this case, our data has two dimensions: time and region.
    // Time is listed first so that it will become the data axis for the chart. Time can't be
    // used as the legend facet, though, because there are way too many values (dates) for
    // this to be sensible.
    facets: [{
        id: "time",
        title: "Period",
        canBeLegendFacet: false
    },{
        id: "region",  // the key used for this facet in the data
        title: "Region" // the user-visible title you want in the chart
    }],

    data: data,  // This is a reference to the inline data supplied above
    valueProperty: "value", // the property in the data that is the numerical value to chart
    chartType: "Area",
    allowedChartTypes: ["Area", "Column", "Line", "Radar"]
});

// This is a form which you can use to change the chart type
isc.DynamicForm.create({
    autoDraw: false,
    ID: "chartSelector",
    wrapItemTitles: false,
    items: [{
        name: "chartType",
        title: "Chart Type",
        type: "select",
        valueMap: multiSeriesChart.allowedChartTypes,
        defaultValue: multiSeriesChart.chartType,
        changed : function (form, item, value) {
            multiSeriesChart.setChartType(value)
        }
    }]
});

// Have the chartSelector update itself if the context menu is used to change chartType
chartSelector.observe(multiSeriesChart, "setChartType", "chartSelector.getItem('chartType').setValue(multiSeriesChart.chartType)");

// Overall layout
isc.VLayout.create({
    ID: "multiSeriesChartLayout",
    width: "100%",
    height: "100%",
    membersMargin: 20,
    members: [chartSelector, multiSeriesChart]
});
