/* Auto-Generated React */
import React from 'react';
import 'smartclient-lgpl/release';
import 'smartclient-lgpl/skins/Tahoe';

import { SC, ButtonItem, CheckboxItem, ComboBoxItem, DynamicForm, Label, ListGrid, TextItem, VLayout, Validator } from 'smartclient-lgpl/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

let onCustom_urlChanged = function (form, _, value) {
    const urlItem = form.getItem('parquet_custom_url');
    urlItem.setRequired(value);
    form.markForRedraw();
};
let onParquet_custom_urlShowIf = function(item,value,form,values) {return form.getValue('custom_url') === true;};
let onLoadDataClick = function () {
    const useCustom = parquetForm.getValue('custom_url') === true;
    let dsID = null;
    if (useCustom) {
        if (!parquetForm.validate()) {
            isc.warn('Please provide a valid Parquet URL.');
            return;
        }
        let url = parquetForm.getValue('parquet_custom_url');
        if (!url || !url.trim()) {
            isc.warn('Custom URL is required when \'Custom Dataset\' is checked.');
            return;
        }
        url = ensureParquetExtension(url.trim());
        dsID = 'parquet-url-' + base64url(url);
    } else {
        const preset = parquetForm.getValue('datasets');
        if (!preset) {
            isc.warn('Please select a dataset.');
            return;
        }
        dsID = preset;
    }
    isc.DataSource.load(dsID, function () {
        listGridContent.setDataSource(isc.DataSource.get(dsID));
        listGridContent.fetchData();
    });
};

function base64url(input) {
    const utf8 = unescape(encodeURIComponent(input));
    const b64 = btoa(utf8);
    return b64.replace(/\+/g, '-').replace(/\//g, '_').replace(/=+$/g, '');
}
function ensureParquetExtension(u) {
    if (!u)
        return u;
    const q = u.indexOf('?');
    const path = q >= 0 ? u.substring(0, q) : u;
    if (!/\.parquet$/i.test(path))
        return u + '.parquet';
    return u;
}

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <VLayout membersMargin="10" width="100%" height="100%">
        <members>
            <DynamicForm ID="parquetForm" numCols="2" titleWidth="200" width="100%">
                <fields>
                    <ComboBoxItem defaultValue="parquet-titanic" name="datasets" title="Parquet Datasets" width="100%">
                        <valueMap>
                                <value id="parquet-titanic">Titanic Passengers</value>
                                <value id="parquet-weather">Weather Data</value>
                                <value id="parquet-mtcars">Motor Trend Car Road Tests</value>
                        </valueMap>
                    </ComboBoxItem>
                    <CheckboxItem name="custom_url" title="Custom Dataset" value="false" changed={onCustom_urlChanged}/>
                    <TextItem defaultValue="https://www.tablab.app/sample-datasets/titanic.parquet" name="parquet_custom_url" title="URL parquet dataset" width="100%" showIf={onParquet_custom_urlShowIf} required="false">
                        <validators>
                            <Validator type="requiredIf" expression="item.form.getValue(&apos;custom_url&apos;)===true"/>
                            <Validator type="regexp" errorMessage="URL must start with http(s)://">
                                <expression>
                                </expression>
                            </Validator>
                        </validators>
                    </TextItem>
                    <ButtonItem title="Load Data" click={onLoadDataClick}/>
                </fields>
            </DynamicForm>
            <Label contents="You can load data from public parquet datasets files such as titanic Passengers, Motor Trend Car Road Tests, and Weather Data; you can also load your customr parquet urls" title="parquetInfo" ID="parquetInfo" width="100%" height="12" autoDraw="true"/>
            <ListGrid ID="listGridContent" showFilterEditor="true" autoFetchData="true" width="100%" height="400"/>
        </members>
    </VLayout>,
    document.getElementById(target)
);
