/* Auto-Generated React */
import React from 'react';
import 'smartclient-lgpl/release';
import 'smartclient-lgpl/skins/Tahoe';

import { SC, Calendar, DSField, DataSource, Validator } from 'smartclient-lgpl/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

let onEventCalendarGetDayBodyHTML = function (date, events, calendar, rowNum, colNum) {
    var returnStr = date.getDate() + ' ';
    if (events && events.length > 0) {
        returnStr += this.imgHTML('[SAMPLE]icons/16/approved.png', 16, 16, 'image');
    }
    return returnStr;
};
let onEventCalendarDayBodyClick = function (date, events, calendar, rowNum, colNum) {
    var nameStr = '';
    if (events.length == 0)
        nameStr = 'No events';
    for (var i = 0; i < events.length; i++) {
        nameStr += isc.Time.toShortTime(events[i].startDate) + ' ' + events[i].name + '<BR/>';
    }
    isc.say(nameStr, { title: date.toUSShortDate() });
};

var _today = new Date(2021, 4, 23);
var _start = _today.getDate() - _today.getDay();
var _month = _today.getMonth();
var _year = _today.getFullYear();
var eventData = [
    {
        eventId: 1,
        name: 'Meeting',
        description: 'Shareholders meeting: monthly forecast report',
        startDate: new Date(_year, _month, _start + 2, 9),
        endDate: new Date(_year, _month, _start + 2, 14)
    },
    {
        eventId: 2,
        name: 'Realtor',
        description: 'This canvas is styled by color settings on the CalendarEvent',
        startDate: new Date(_year, _month, _start + 3, 8),
        endDate: new Date(_year, _month, _start + 3, 10),
        headerTextColor: 'black',
        headerBackgroundColor: 'orange',
        headerBorderColor: 'darkorange',
        textColor: 'darkgreen',
        borderColor: 'darkorange',
        backgroundColor: '#ffffcc'
    },
    {
        eventId: 3,
        name: 'Soccer',
        description: 'Little league soccer finals',
        startDate: new Date(_year, _month, _start + 4, 13),
        endDate: new Date(_year, _month, _start + 4, 16)
    },
    {
        eventId: 4,
        name: 'Sleep',
        description: 'Catch up on sleep',
        startDate: new Date(_year, _month, _start + 4, 5),
        endDate: new Date(_year, _month, _start + 4, 9)
    },
    {
        eventId: 5,
        name: 'Inspection',
        description: 'This canvas is styled and disabled by custom styleName and canEdit settings on the CalendarEvent',
        startDate: new Date(_year, _month, _start + 4, 10),
        endDate: new Date(_year, _month, _start + 4, 12),
        styleName: 'testStyle',
        canEdit: false
    },
    {
        eventId: 6,
        name: 'Airport run',
        description: 'This canvas is styled by color settings on the CalendarEvent',
        startDate: new Date(_year, _month, _start + 4, 1),
        endDate: new Date(_year, _month, _start + 4, 3),
        headerTextColor: 'white',
        headerBackgroundColor: 'green',
        headerBorderColor: 'green',
        textColor: 'darkgreen',
        borderColor: 'darkgreen',
        backgroundColor: 'lightgreen'
    },
    {
        eventId: 7,
        name: 'Dinner Party',
        description: 'Prepare elaborate meal for friends',
        startDate: new Date(_year, _month, _start + 4, 17),
        endDate: new Date(_year, _month, _start + 4, 20)
    },
    {
        eventId: 8,
        name: 'Poker',
        description: 'Poker at Steve\'s house',
        startDate: new Date(_year, _month, _start + 4, 21),
        endDate: new Date(_year, _month, _start + 4, 23)
    },
    {
        eventId: 9,
        name: 'Directors Meeting',
        description: 'Board of directors meeting: discussion of next months strategy',
        startDate: new Date(_year, _month, _start + 5, 11),
        endDate: new Date(_year, _month, _start + 5, 15)
    }
];
eventData.getDataStartDate = function () {
    return new Date(2021, 4, 23);
};

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <>
        <DataSource ID="eventDS" title="eventDS" clientOnly="true" testData={eventData}>
            <fields>
                <DSField canFilter="true" name="eventId" type="sequence" primaryKey="true" title="Event Id" canEdit="false" readOnlyDisplay="static">
                    <validators>
                        <Validator type="isInteger" stopIfFalse="true" typeCastValidator="true" ID="_3" defaultErrorMessage="Must be a whole number.">
                            <resultingValue></resultingValue>
                        </Validator>
                    </validators>
                </DSField>
                <DSField name="name" title="Name"/>
                <DSField name="description" title="Description"/>
                <DSField name="startDate" title="Start Date"/>
                <DSField name="endDate" title="End Date"/>
            </fields>
        </DataSource>

        <Calendar dataSource="eventDS" canCreateEvents="false" showDateChooser="false" disableWeekends="false" showDayHeaders="false" showOtherDays="false" showDayView="false" showWeekView="false" autoFetchData="true" ID="eventCalendar" width="500" height="250" showDatePickerButton="false" showAddEventButton="false" startDate={eventData.getDataStartDate()} allowLongEvents="false" getDayBodyHTML={onEventCalendarGetDayBodyHTML} dayBodyClick={onEventCalendarDayBodyClick}/>
    </>,
    document.getElementById(target)
);
