/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2026-02-04/LGPL Development Only (2026-02-04)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/

var isc = window.isc ? window.isc : {};if(window.isc&&!window.isc.module_History){isc.module_History=1;isc._moduleStart=isc._History_start=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc._moduleEnd&&(!isc.Log||(isc.Log && isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={ message:'History load/parse time: ' + (isc._moduleStart-isc._moduleEnd) + 'ms', category:'loadTime'};
if(isc.Log && isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime');
else if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM;
else isc._preLog=[isc._pTM]}isc.definingFramework=true;


if (!window.isc || typeof isc.Packager != "object") {


//> @object isc
// <code>window.isc</code> is the base object for the Isomorphic SmartClient framework.
// Every SmartClient class is available on this object as <code>isc.<i>ClassName</i></code>.
// The <code>isc</code> also contains a number of static utility methods.
// <P>
// See also +link{group:simpleNamesMode,Simple Names mode}.
//
// @treeLocation Client Reference/System
// @visibility external
//<

//> @groupDef simpleNamesMode
// When SmartClient runs in "simple names" mode (the default), all ISC Classes and several
// global methods are installed as JavaScript global variables, that is, properties of the
// browser's "window" object.  When simple names mode is disabled (called "portal mode"),
// the framework uses only the global variable: "isc" and global variables prefixed with
// "isc_".
// <P>
// Portal mode is intended for applications which must integrate with fairly arbitrary
// JavaScript code written by third-party developers, and/or third party JavaScript frameworks,
// where it is important that each framework stays within it's own namespace.
// <P>
// <smartclient>
// In portal mode, all references to ISC classes and global functions must be prefixed with
// "isc.", for example:<pre>
//
//      Canvas.create(addProperties({}, myDefaults))
//
// </pre>would become<pre>
//
//      isc.Canvas.create(isc.addProperties({}, myDefaults));
//
// </pre>
// </smartclient>
// Portal mode is enabled by setting <code>window.isc_useSimpleNames = false</code> <b>before</b>
// SmartClient is loaded, generally inside the &lt;head&gt; element.
//
// @treeLocation Client Reference/System
// @title Simple Names mode
// @visibility external
//<





var isc = window.isc ? window.isc : {};
isc._start = new Date().getTime();

// versioning - values of the form ${value} are replaced with user-provided values at build time.
// Valid values are: version, date, project (not currently used)
isc.version = "SNAPSHOT_v15.0d_2026-02-04/LGPL Development Only";
isc.versionNumber = "SNAPSHOT_v15.0d_2026-02-04";
isc.buildDate = "2026-02-04";
isc.expirationDate = "";

isc.scVersion = "15.0d";
isc.scVersionNumber = "15.0";
isc.sgwtVersion = "15.0d";
isc.sgwtVersionNumber = "15.0";

// these reflect the latest stable version relative to the branch from which this build is
// created.  So for example for 11.0d/6.0d, this will be 10.1/5.1.  But for 10.0/5.0 this will
// be 10.0/5.0.
isc.scParityStableVersionNumber = "14.1";
isc.sgwtParityStableVersionNumber = "14.1";

// license template data
isc.licenseType = "LGPL";
isc.licenseCompany = "Isomorphic Software";
isc.licenseSerialNumber = "ISC_LGPL_NIGHTLY";
isc.licensingPage = "http://smartclient.com/product/";

isc._$debugModules = "debugModules";
isc._$nonDebugModules = "nonDebugModules";
isc.checkForDebugAndNonDebugModules = function () {
    if (isc.checkForDebugAndNonDebugModules._loggedWarning) return;
    var debugModules = isc['_' + this._$debugModules],
        haveDebugModules = debugModules != null && debugModules.length > 0,
        nonDebugModules = isc['_' + this._$nonDebugModules],
        haveNonDebugModules = nonDebugModules != null && nonDebugModules.length > 0;

    if (haveDebugModules && haveNonDebugModules) {
        isc.logWarn("Both Debug and non-Debug modules were loaded; the Debug versions of '" +
        debugModules.join("', '") + "' and the non-Debug versions of '" + nonDebugModules.join("', '") +
        "' were loaded. Mixing Debug and non-Debug modules is not supported and may lead to " +
        "JavaScript errors and/or unpredictable behavior. " +
        "To fix, ensure that only modules in the modules/ folder or the modules-debug/ " +
        "folder are loaded and clear the browser cache. If using Smart GWT, also clear the " +
        "GWT unit cache and recompile.");
        isc.checkForDebugAndNonDebugModules._loggedWarning = true;
    }
};

isc._optionalModules = {
    SCServer: {present: "false", name: "SmartClient Server", serverOnly: true, isPro: true},
    Drawing: {present: "true", name: "Drawing Module"},
    PluginBridges: {present: "true", name: "PluginBridges Module"},
    RichTextEditor: {present: "true", name: "RichTextEditor Module"},
    Calendar: {present: "true", name: "Calendar Module"},
    Analytics: {present: "false", name: "Analytics Module"},
    Charts: {present: "false", name: "Charts Module"},
    Tools: {present: "false", name: "Dashboards and Tools Module"},
    NetworkPerformance: {present: "true", name: "Network Performance Module"},
    Tour: {present: "false", name:"Tour"},
    AI: {present: "false", name: "AI Module"},

    // alias for NetworkPerformance
    FileLoader: {present: "true", name: "Network Performance Module"},
    RealtimeMessaging: {present: "false", name: "RealtimeMessaging Module"},
    // Enterprise Features
    serverCriteria: {present: "false", name: "Server Advanced Filtering", serverOnly: true, isFeature: true},
    customSQL: {present: "false", name: "SQL Templating", serverOnly: true, isFeature: true},
    chaining: {present: "false", name: "Transaction Chaining", serverOnly: true, isFeature: true},
    batchDSGenerator: {present: "false", name: "Batch DS-Generator", serverOnly: true, isFeature: true},
    batchUploader: {present: "false", name: "Batch Uploader", serverOnly: true, isFeature: true},
    transactions: {present: "false", name: "Automatic Transaction Management", serverOnly: true, isFeature: true}
};
isc.canonicalizeModules = function (modules) {
    if (!modules) return null;

    // canonicalize to Array, split on comma
    if (isc.isA.String(modules)) {
        if (modules.indexOf(",") != -1) {
            modules = modules.split(",");
            var trimLeft = /^\s+/, trimRight = /\s+$/;
            for (var i=0; i<modules.length; i++) {
                modules[i] = modules[i].replace(trimLeft, "").replace(trimRight, "");
            }
        } else modules = [modules];
    }
    return modules;
};
isc.hasOptionalModules = function (modules) {
    // ease of use shortcut, null value means no optional module requirements
    if (!modules) return true;

    modules = isc.canonicalizeModules(modules);
    for (var i = 0; i < modules.length; i++) if (!isc.hasOptionalModule(modules[i])) return false;
    return true;
};
isc.getMissingModules = function (requiredModules) {
    var result = [];
    requiredModules = isc.canonicalizeModules(requiredModules);
    for (var i = 0; i < requiredModules.length; i++) {
        var module = requiredModules[i];
        if (!isc.hasOptionalModule(module)) result.add(isc._optionalModules[module]);
    }
    return result;
};
isc.hasOptionalModule = function (module) {
    var v = isc._optionalModules[module];
    if (!v) {
        if(isc.Log) isc.Log.logWarn("isc.hasOptionalModule - unknown module: " + module);
        return false;
    }
    // has module or devenv
    return v.present == "true" || v.present.charAt(0) == "$";
};
isc.getOptionalModule = function (module) {
    return isc._optionalModules[module];
};


isc.$P5hy05Xgj7AN = function (moduleName) {
    if (this.hasOptionalModule(moduleName)) return;
    var moduleEntry = isc._optionalModules[moduleName];
    if (moduleEntry) moduleEntry.present = !!moduleName + "";
};

// default to "simple names" mode, where all ISC classes are defined as global variables
isc._useSimpleNames = window.isc_useSimpleNames;
if (isc._useSimpleNames == null) isc._useSimpleNames = true;

// register with the OpenAjax hub, if present
if (window.OpenAjax) {
    // OpenAjax insists on only numbers and dots.  This regex will convert eg 5.6b3 to 5.6.03,
    // which is not really accurate
    isc._numericVersion = isc.versionNumber.replace(/[a-zA-Z_]+/, ".0");
    OpenAjax.registerLibrary("SmartClient", "http://smartclient.com/SmartClient",
                             isc._numericVersion,
                             { namespacedMode : !isc._useSimpleNames,
                               iscVersion : isc.version,
                               buildDate : isc.buildDate,
                               licenseType : isc.licenseType,
                               licenseCompany : isc.licenseCompany,
                               licenseSerialNumber : isc.licenseSerialNumber });
    OpenAjax.registerGlobals("SmartClient", ["isc"]);
}

// add a property to global scope.  This property will always be available as "isc[propName]" and
// will also be available as "window[propName]" if we are in "simpleNames" mode.
// NOTE: even in simpleNames mode, where we assume it's OK to put things into global scope, we
// should still think carefully about creating globals.  Eg a variable like "params" which holds the
// current URL parameters (which we used to have) could easily get clobbered by some sloppy global
// JS, causing mysterious crashes.  Consider creating a class method (eg Page.getWidth()) or class
// property (Log.logViewer) instead, or making the variable isc.myMethod() or isc.myProperty.
isc._$iscPrefix = "isc.";
isc.addGlobal = function (propName, propValue) {
    if (propName.indexOf(isc._$iscPrefix) == 0) propName = propName.substring(4);
    isc[propName] = propValue;
    if (isc._useSimpleNames) window[propName] = propValue;
}





//>Offline

//XXX need to determine this flag correctly at load time
isc.onLine = true;

isc.isOffline = function () {
    return !isc.onLine;
};
isc.goOffline = function () { isc.onLine = false; };
isc.goOnline = function () { isc.onLine = true; };
if (window.addEventListener) {
    window.addEventListener("online", isc.goOnline, false);
    window.addEventListener("offline", isc.goOffline, false);
}
//<Offline


}






// Polyfill for Object.hasOwn()
// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/hasOwn

isc.Object_hasOwn = function (obj, property) {
    if (obj == null) throw new TypeError("can't convert " + obj + " to an object");
    return Object.prototype.hasOwnProperty.call(Object(obj), property);
};
Object.hasOwn = Object.hasOwn || isc.Object_hasOwn;




if (typeof isc.Browser != "object") {



//> @class Browser
// The <code>Browser</code> class contains various class attributes that indicate basic properties
// of the browser and whether certain features are enabled.
// <P>
// These flags represent a "best effort" at browser detection based on the user agent string
// and other indicators. Browser detection is inherently imperfect - browsers may spoof their
// user agent, new browser versions may change behavior, and unusual browser configurations
// may not be detected correctly. These properties should not be considered a fully supported
// API for all edge cases - applications with unusual browser compatibility requirements may
// need to implement their own detection logic.
// @treeLocation Client Reference/Foundation
// @visibility external
//<
isc.addGlobal("Browser", {
    isSupported: false


    , _assert : function (b, message, category) {
        if (!b) {
            message = "assertion failed" + (message ? " with message: '" + message + "'" : "");

            if (isc.logWarn) {
                isc.logWarn(message + ". Stack trace:" + isc.Class.getStackTrace());

            } else if (console) { // useful fallback crash info before logging loads
                console.log(message);
                console.trace();
            }
        }
    }


});

// Server environment detection - runs BEFORE ServerExclude strips browser detection code.
// In Node.js and other server environments, we need these properties for stack trace handling
// and other server-side functionality. V8 (Node.js runtime) uses Chrome's stack trace API.
if (typeof process !== 'undefined' && process.versions && process.versions.node) {
    isc.Browser.isNode = true;
    isc.Browser.isChrome = true;  // V8 engine uses Chrome's Error.prepareStackTrace API
    isc.Browser.isDesktop = true;
    isc.Browser.version = parseInt(process.versions.node);
}

// GraalJS environment detection - runs inside Java VM via GraalJS polyglot engine.
// GraalJS can be accessed two ways:
//   1. JSR-223 ScriptEngine API (via servletEngine) - Java interop available
//   2. Polyglot Context API (standalone) - Java interop when allowAllAccess(true)
//
// GraalJS provides the Java global object for Java interop, which distinguishes it from
// browser and Node.js environments. This allows SmartClient modules to run inside the
// Java server for server-side scripting (e.g., in DataSource operationBindings).
if (typeof Java !== 'undefined' && typeof Java.type === 'function') {
    isc.Browser.isGraalJS = true;
    isc.Browser.isDesktop = true;
    // GraalJS with js.stack-trace-api option supports V8-compatible Error.prepareStackTrace and
    // Error.captureStackTrace APIs. Setting isChrome allows ChromeStackTrace to be used, giving
    // rich stack traces with function arguments and SmartClient-specific formatting.
    isc.Browser.isChrome = true;
    // GraalJS version detection - Java.type returns a Java class reference
    try {
        var System = Java.type('java.lang.System');
        var graalVersion = System.getProperty('org.graalvm.version');
        if (graalVersion) {
            isc.Browser.graalVersion = graalVersion;
        }
    } catch (e) {
        // Ignore version detection errors
    }
}

// Polyglot Context API detection - standalone GraalJS outside servletEngine.
// When using Context.newBuilder("js").allowAllAccess(true), the Polyglot global is available.
// This distinguishes standalone Polyglot usage from JSR-223 ScriptEngine usage.
if (typeof Polyglot !== 'undefined' && typeof Polyglot.import === 'function') {
    isc.Browser.isPolyglot = true;
    // If not already detected as GraalJS (e.g., no Java interop), still mark as GraalJS
    if (!isc.Browser.isGraalJS) {
        isc.Browser.isGraalJS = true;
        isc.Browser.isDesktop = true;
    }
}

// Unified server-side JavaScript flag - true for any non-browser JS environment.
// This provides a simple check for code that needs to behave differently on server vs browser.
if (isc.Browser.isNode || isc.Browser.isGraalJS) {
    isc.Browser.isServerJS = true;

    // Stub functions for server environments - these are defined inside ServerExclude
    // for browsers but are needed by Canvas.js and other UI classes even in server builds.
    // In server environments, touch scrolling is not applicable.
    isc.Browser._getSupportsNativeTouchScrolling = function() {
        return false;  // No touch scrolling support in server environments
    };

    // hasDualInput is used by Canvas.js for overflow style detection
    isc.Browser.hasDualInput = false;
}

//> @classAttr Browser.isNode (boolean : varies : R)
// True when running in a Node.js environment. Node.js mode is used for standalone
// server-side processing such as batch operations and internal tooling (for example,
// Isomorphic uses Node.js to generate +link{group:typeScriptSupport,TypeScript definitions}
// from SmartClient's JSDoc metadata).
// <P>
// When <code>isNode</code> is true, +link{Browser.isServerJS} is also true.
// @visibility external
//<

//> @classAttr Browser.isGraalJS (boolean : varies : R)
// True when running in a GraalJS environment (either JSR-223 ScriptEngine or Polyglot
// Context API). GraalJS provides full Java interop, allowing JavaScript code to
// instantiate Java classes and call Java methods directly via <code>Java.type()</code>.
// <P>
// To distinguish between JSR-223 and Polyglot modes, check +link{Browser.isPolyglot}.
// When <code>isGraalJS</code> is true, +link{Browser.isServerJS} is also true.
// <P>
// See +link{group:serverScript} for documentation on using JavaScript in DataSource
// server scripts.
// @visibility external
//<

//> @classAttr Browser.isPolyglot (boolean : varies : R)
// True when running in GraalJS via the Polyglot Context API (as opposed to JSR-223
// ScriptEngine). The Polyglot API is typically used in standalone Java applications
// that embed SmartClient JavaScript processing, while JSR-223 is used for declarative
// server scripts in .ds.xml files.
// <P>
// When <code>isPolyglot</code> is true, +link{Browser.isGraalJS} and
// +link{Browser.isServerJS} are also true.
// <P>
// See +link{group:graalPolyglotDMI} for documentation on using the Polyglot API from DMI.
// @visibility external
//<

//> @classAttr Browser.isServerJS (boolean : varies : R)
// True in any server-side JavaScript environment (Node.js or GraalJS). This is a unified
// flag for code that needs to behave differently on server vs browser without caring
// which specific server runtime is in use.
// <P>
// Use this flag when:
// <ul>
// <li>Skipping UI operations that aren't supported server-side</li>
// <li>Using alternative logging (server-side doesn't have browser console)</li>
// <li>Bypassing browser-specific APIs (DOM, timers, events)</li>
// </ul>
// <P>
// To detect the specific server runtime, check +link{Browser.isNode},
// +link{Browser.isGraalJS}, or +link{Browser.isPolyglot}.
// @visibility external
//<

//>ServerExclude
// ----------------------------------------------------------------
// Detecting browser type
// ----------------------------------------------------------------
// Bot/Crawler discriminators.  In many cases the bots will use something approximating a
// browser engine to "run your javascript", but the UA string, which we use to determine the
// proper rendering path, either does not reflect the engine type at all or reflects a generic
// "Mozilla/5.0" or similar.  So first, we detect the bot type, and then this is used below to
// also set browser type - e.g. isGoogleBot -> isChrome + specific version from docs

// https://support.google.com/webmasters/answer/1061943?hl=en
isc.Browser.isGoogleBot = navigator.userAgent.indexOf("Googlebot/") != -1;
// https://www.bing.com/webmaster/help/which-crawlers-does-bing-use-8c184ec0
isc.Browser.isBingBot = navigator.userAgent.indexOf("bingbot/") != -1;
// https://perishablepress.com/list-all-user-agents-top-search-engines/
// Note that DuckDuckGo appears to use Bing, Yahoo, and Yandex and only go out directly for
// "answers": https://duck.co/help/results/sources
isc.Browser.isDuckDuckBot = navigator.userAgent.indexOf("DuckDuckBot/") != -1;
// https://help.yahoo.com/kb/SLN22600.html?guccounter=1
isc.Browser.isYahooBot = navigator.userAgent.indexOf("Slurp;") != -1;
// http://www.baiduguide.com/baidu-spider/
isc.Browser.isBaiduBot = navigator.userAgent.indexOf("Baiduspider") != -1;
// https://yandex.com/support/webmaster/robot-workings/check-yandex-robots.xml
isc.Browser.isYandexBot = navigator.userAgent.indexOf("YandexBot/") != -1;

// generic bot discriminator
isc.Browser.isBot = isc.Browser.isGoogleBot || isc.Browser.isBingBot ||
        isc.Browser.isDuckDuckBot || isc.Browser.isYahooBot || isc.Browser.isBaiduBot ||
        isc.Browser.isYandexBot;

//>    @classAttr    Browser.isOpera        (boolean : ? : R)
//        Are we in Opera ?
//<

isc.Browser.isOpera = (navigator.appName == "Opera" ||
                    navigator.userAgent.indexOf("Opera") != -1);

//console.log("navigator.appName:" + navigator.appName
//            + ", navigator.userAgent:" + navigator.userAgent);
//console.log("is opera?:" + isc.Browser.isOpera);

//>    @classAttr    Browser.isNS (boolean : ? : R)
//        Are we in Netscape (including Navigator 4+, NS6 & 7, and Mozilla)
//      Note: Safari also reports itself as Netscape, so isNS is true for Safari.
//<
isc.Browser.isNS = (navigator.appName == "Netscape" && !isc.Browser.isOpera);
//console.log("is NS?:" + isc.Browser.isNS);

//>    @classAttr    Browser.isIE        (boolean : ? : R)
//        Are we in Internet Explorer?
// @visibility external
//<
isc.Browser.isIE = (navigator.appName == "Microsoft Internet Explorer" &&
                    !isc.Browser.isOpera) ||
                   navigator.userAgent.indexOf("Trident/") != -1;
//console.log("is IE?:" + isc.Browser.isIE);

//>    @classAttr    Browser.isMSN        (boolean : ? : R)
//      Are we in the MSN browser (based on MSIE, so isIE will be true in this case)
//<
isc.Browser.isMSN = (isc.Browser.isIE && navigator.userAgent.indexOf("MSN") != -1);
//console.log("is MSN?:" + isc.Browser.isMSN);


//>    @classAttr    Browser.isMoz        (boolean : ? : R)
//        Are we in any Mozilla-derived browser, that is, a browser based on Netscape's Gecko
//      engine? (includes Mozilla and Netscape 6+)
//<
isc.Browser.isMoz = (navigator.userAgent.indexOf("Gecko") != -1) &&
    // NOTE: Safari sends "(like Gecko)", but behaves differently from Moz in many ways

    (navigator.userAgent.indexOf("Safari") == -1) &&
    (navigator.userAgent.indexOf("AppleWebKit") == -1) &&
    !isc.Browser.isIE;
//console.log("is Moz?:" + isc.Browser.isMoz);

//>    @classAttr    Browser.isCamino (boolean : false : R)
//  Are we in Mozilla Camino?
//<
isc.Browser.isCamino = (isc.Browser.isMoz && navigator.userAgent.indexOf("Camino/") != -1);
//console.log("is Camino?:" + isc.Browser.isCamino);


//>    @classAttr    Browser.isFirefox (boolean : false : R)
//  Are we in Mozilla Firefox?
//<
isc.Browser.isFirefox = (isc.Browser.isMoz && navigator.userAgent.indexOf("Firefox/") != -1);
//console.log("is Fire Fox?:" + isc.Browser.isFirefox);


//> @classAttr  Browser.isAIR    (boolean : ? : R)
// Is this application running in the Adobe AIR environment?
//<
isc.Browser.isAIR = (navigator.userAgent.indexOf("AdobeAIR") != -1);
//console.log("is AIR?:" + isc.Browser.isAIR);


//>    @classAttr    Browser.isWebKit (boolean : ? : R)
// Are we in a WebKit-based browser (Safari, Chrome, mobile Safari and Android, others).
//<
isc.Browser.isWebKit = navigator.userAgent.indexOf("WebKit") != -1;
//console.log("is webkit?:" + isc.Browser.isWebKit);


//>    @classAttr    Browser.isSafari (boolean : ? : R)
// Are we in Apple's "Safari" browser? Note that this property will also be set for other
// WebKit based browsers (such as Google Chrome).
//<
// As far as we know all "true" Safari implementations identify themselves in the userAgent with
// the string "Safari", but so does Microsoft Edge, so that can't be used to identify "true"
// Safari.  GWT hosted mode browser on OSX is also based on apple webkit and should be treated
// like Safari but is not a Safari browser and doesn't identify itself as such in the userAgent.
// Reported UserAgent:
//  Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_5; en-us) AppleWebKit/525.18 (KHTML, like Gecko)
isc.Browser.isSafari = isc.Browser.isAIR || navigator.userAgent.indexOf("Safari") != -1 ||
        navigator.userAgent.indexOf("AppleWebKit") != -1 ||
        // GoogleBot uses the Chrome engine: https://developers.google.com/search/docs/guides/rendering
        // and isChrome implies isSafari (see below in the isChrome definition)
        isc.Browser.isGoogleBot;
//console.log("is Safari?:" + isc.Browser.isSafari);

//> @classAttr Browser.isEdge (boolean : ? : R)
// Are we in the Microsoft Edge browser (not the version based on Chromium)?
//<

isc.Browser.isEdge = isc.Browser.isSafari && (navigator.userAgent.indexOf("Edge/") != -1);
//console.log("is Edge (legacy)?:" + isc.Browser.isEdge);

//> @classAttr Browser.isChromiumEdge (boolean : ? : R)
// Are we in the Microsoft Edge browser (the version based on Chromium)?
//<

isc.Browser.isChromiumEdge = isc.Browser.isSafari && (navigator.userAgent.indexOf("Edg/") != -1);


//> @classAttr Browser.isChrome (boolean : ? : R)
// Are we in the Google Chrome browser?
//<
// Behaves like Safari in most ways.  Note: do not detect Edge as Chrome - causes odd scrollbar
// misrenderings.  As of 7/30/2015 appears to work better with the isSafari codepaths
// Note: the Google crawler does not identify itself as Chrome, even though it is in fact using
// the Chrome engine.  This leads to us mis-detecting the render path and producing all sorts
// of errors that result in a failure to render at all as far as the crawler is concerned.
isc.Browser.isChrome = (isc.Browser.isSafari && !isc.Browser.isEdge &&
                        (navigator.userAgent.indexOf("Chrome/") != -1)) ||
        // GoogleBot uses the Chrome engine: https://developers.google.com/search/docs/guides/rendering
        isc.Browser.isGoogleBot;
//console.log("is Chrome?:" + isc.Browser.isChrome);

//>    @classAttr    Browser.isSafariStrict (boolean : ? : R)
// Are we in Apple's "Safari" browser? This property is only set on "true" Safari browsers.
//<

isc.Browser.isSafariStrict = isc.Browser.isSafari &&
        !isc.Browser.isAIR && !isc.Browser.isEdge && !isc.Browser.isChrome;
//console.log("is \"true\" Safari?:" + isc.Browser.isSafariStrict);


if (!isc.Browser.isIE && !isc.Browser.isOpera && !isc.Browser.isMoz &&
    !isc.Browser.isAIR && !isc.Browser.isWebkit && !isc.Browser.isSafari)
{
    if (navigator.appVersion.indexOf("MSIE") != -1) {
        isc.Browser.isIE = true;
        //console.log("is IE (inside embedded browser, etc)?:" + isc.Browser.isIE);

    }
}

//>    @classAttr    Browser.isChromeoS (boolean : ? : R)
// Is the operating system for the browser Chrome OS?
//<

//isc.Browser.isChromeOS = navigator.userAgent.match("\\([^)]*CrOS x86_64[^(]*\\)") != null;
isc.Browser.isChromeOS = navigator.userAgent.indexOf("CrOS x86_64") != -1;


// ----------------------------------------------------------------
// END Detecting browser type
// ----------------------------------------------------------------


//>    @classAttr Browser.minorVersion        (number : ? : R)
//        Browser version, with minor revision included (4.7, 5.5, etc).
//
// NOTE: In Firefox 16+, Browser.minorVersion will equal Browser.version by design.
//<

if (navigator.userAgent.indexOf("Trident/") >= 0 &&
    navigator.userAgent.lastIndexOf("rv:") >= 0)
{

    isc.Browser.minorVersion = parseFloat(navigator.userAgent.substring(navigator.userAgent.lastIndexOf("rv:") + "rv:".length));
} else {
    isc.Browser.minorVersion = parseFloat(isc.Browser.isIE
                                      ? navigator.appVersion.substring(navigator.appVersion.indexOf("MSIE") + 5)
                                      : navigator.appVersion );
}

if (isc.Browser.isIE) {
    // IE won't allow a documentMode higher than the version you are on.

    if (document.documentMode != null) {
        isc.Browser.minorVersion = Math.max( isc.Browser.minorVersion, document.documentMode );
    }
} else (function () {



    // per https://developers.google.com/search/docs/guides/rendering, accurate as of 6/5/2018
    // This number is not surfaced by the bot, so must hardcode
    if (isc.Browser.isGoogleBot) {
        isc.Browser.minorVersion = 41;
        return;
    }

    var needle, pos;
    if (navigator.appVersion) {
        // Safari
        needle = "Version/";
        pos = navigator.appVersion.indexOf(needle);
        if (pos >= 0) {
            isc.Browser.minorVersion = parseFloat(navigator.appVersion.substring(pos + needle.length));
            return;
        }
    }

    var ua = navigator.userAgent;

    needle = "Chrome/";
    pos = ua.indexOf(needle);
    if (pos >= 0) {
        isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
        return;
    }

    // Handle Camino before Firefox because Camino includes "(like Firefox/x.x.x)" in the UA.
    needle = "Camino/";
    pos = ua.indexOf(needle);
    if (pos >= 0) {
        isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
        return;
    }

    needle = "Firefox/";
    pos = ua.indexOf(needle);
    if (pos >= 0) {
        isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
        return;
    }

    if (ua.indexOf("Opera/") >= 0) {
        needle = "Version/";
        pos = ua.indexOf(needle);
        if (pos >= 0) {
            isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
            return;
        } else {
            // Opera 9.64
            needle = "Opera/";
            pos = ua.indexOf(needle);
            isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
            return;
        }
    }
})();

//>    @classAttr    Browser.version        (number : ? : R)
//        Browser major version number (integer: 4, 5, etc).
// @visibility external
//<
isc.Browser.version = parseInt(isc.Browser.minorVersion);

// actually means IE6 or earlier, which requires radically different optimization techniques
isc.Browser.isIE6 = isc.Browser.isIE && isc.Browser.version <= 6;

//> @classAttr Browser.supportsHTML5Audio (boolean : varies : RA)
// Does this browser support HTML5 Audio via the &lt;AUDIO&gt; element?
//<
isc.Browser.supportsHTML5Audio = (document.createElement("audio") != null) ? "play" : null;

//> @classAttr Browser.supportsECMA2015 (boolean : varies : RA)
// Does this browser provide full support for ECMA 2015 (ES6) features?
//<
isc.Browser.supportsECMA2015 = isc.Browser.isChrome && isc.Browser.version >= 51 ||
                             isc.Browser.isMoz          && isc.Browser.version >= 54 ||
                             isc.Browser.isEdge         && isc.Browser.version >= 15 ||
                             isc.Browser.isOpera        && isc.Browser.version >= 38 ||
                             isc.Browser.isSafariStrict && isc.Browser.version >= 10;

//>    @classAttr    Browser.caminoVersion (String : ? : R)
//        For Camino-based browsers, the Camino version number.
//<
if (isc.Browser.isCamino) {
    // Camino Version is the last thing in the userAgent
    isc.Browser.caminoVersion =
        navigator.userAgent.substring(navigator.userAgent.indexOf("Camino/") +7);
}

if (isc.Browser.isFirefox) {
//>    @classAttr    Browser.firefoxVersion (String : ? : R)
//        For Firefox-based browsers, the Firefox version number.
//          - 0.10.1    is Firefox PR 1
//      After this the version numbers reported match those in the about dialog
//          - 1.0       is Firefox 1.0
//          - 1.0.2     is Firefox 1.0.2
//          - 1.5.0.3   is Firefox 1.5.0.3
//<
    var userAgent = navigator.userAgent,
        firefoxVersion = userAgent.substring(userAgent.indexOf("Firefox/")+ 8),
        majorMinorVersion = firefoxVersion.replace(/([^.]+\.[^.]+)\..*/, "$1");
    isc.Browser.firefoxVersion          = firefoxVersion;
    isc.Browser.firefoxMajorMinorNumber = parseFloat(majorMinorVersion);
}

//>    @classAttr    Browser.geckoVersion (Integer : ? : R)
//        For Gecko-based browsers, the Gecko version number.
//      Looks like a datestamp:
//          - 20011019 is Netscape 6.2
//          - 20020530 is Mozilla 1.0
//          - 20020823 is Netscape 7.0
//          - 20020826 is Mozilla 1.1
//          - 20021126 is Mozilla 1.2
//          - 20030312 is Mozilla 1.3
//          - 20030624 is Mozilla 1.4
//          - 20031007 is Mozilla 1.5
//          - 20031120 is Mozilla 1.5.1 (Mac only release)
//          - 20040113 is Mozilla 1.6
//          - 20040616 is Mozilla 1.7
//          - 20040910 is Mozilla 1.73
//          - 20041001 is Mozilla Firefox PR1 (-- also see firefox version)
//          - 20041107 is Mozilla Firefox 1.0
//          - 20050915 is Mozilla Firefox 1.0.7
//          - 20051107 is Mozilla Firefox 1.5 RC2
//          - 20051111 is Mozilla Firefox 1.5 final
//          - 20060426 is Mozilla Firefox 1.5.0.3
//          - 20061010 is Mozilla Firefox 2.0
//          - 20070321 is Netscape 8.1.3 - LIES - really based on Firefox 1.0 codebase
//          - 20071109 is Firefox 3.0 beta 1
//          - 20080529 is Firefox 3.0
//          - 20100101 is Firefox 4.0.1
//<

if (isc.Browser.isMoz) {
    isc.Browser._geckoVIndex = navigator.userAgent.indexOf("Gecko/") + 6;
    // The 'parseInt' actually means we could just grab everything from the
    // end of "Gecko/" on, as we know that even if the gecko version is followed
    // by something, there will be a space before the next part of the UA string
    // However, we know the length, so just use it
    isc.Browser.geckoVersion = parseInt(
        navigator.userAgent.substring(
            isc.Browser._geckoVIndex, isc.Browser._geckoVIndex+8
        )
    );



    if (isc.Browser.isFirefox) {
        // clamp 1.0.x series to last known pre 1.5 version (1.0.7)
        if (isc.Browser.firefoxVersion.match(/^1\.0/)) isc.Browser.geckoVersion = 20050915;
        // clamp 2.0.x series to one day before near-final FF3 beta
        else if (isc.Browser.firefoxVersion.match(/^2\.0/)) isc.Browser.geckoVersion = 20071108;
    }


    if (isc.Browser.version >= 17) isc.Browser.geckoVersion = 20121121;
}

// Doctypes
//  Are we in strict standards mode.  This applies to IE6+ and all Moz 1.0+.
//
//  In strict mode, browsers attempt to behave in a more standards-compliant manner.  Of course,
//  standards interpretation varies pretty drastically between browser makers, so this is in effect
//  just another fairly arbitrary set of behaviors which continues to vary across browser makers,
//  and now also across modes within the same browser.
//
// Traditionally, we have essentially 3 cases to consider:
// - BackCompat / Quirks mode. This is the rendering used if docType is not specified, or if
//   specified as 'Transitional' or 'Frameset' / with no URI
//   (EG: <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">)
//   This is the default mode.
// - Strict. Completely standards complient.
//   Triggered by
//   <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
// - "Almost Strict" (AKA Transitional).
//   In IE this matches Strict mode completely.
//   In Moz it matches strict mode except for rendering of images within tables - see
//   http://developer.mozilla.org/en/docs/Images%2C_Tables%2C_and_Mysterious_Gaps
//   Triggered "transitional" doctype with URI
//   Reports document.compatMode as "CSS1Compat"
// - http://developer.mozilla.org/en/docs/Gecko%27s_%22Almost_Standards%22_Mode
// - http://www.htmlhelp.com/reference/html40/html/doctype.html
// - http://developer.mozilla.org/en/docs/Mozilla%27s_DOCTYPE_sniffing
//
// - we also have the HTML5 doctype to consider - <!DOCTYPE html>. Only applies to modern
//   browsers, and required for some of our more recent features (EG some drawing approaches)
//   We don't explicitly have a flag to differentiate between this and "isStrict"

//> @classAttr  Browser.isStrict    (boolean : ? : R)
//  Are we in strict standards mode.
//<
// HACK: Netscape6 does not report document.compatMode, so we can't tell that a DOCTYPE has been
// specified, but Netscape6 IS affected by a DOCTYPE.  So, in Netscape6, assume we're always in
// strict mode.  At the moment (3/30/03) all strict mode workarounds have identical behavior in
// normal mode.

isc.Browser.isStrict = document.compatMode == "CSS1Compat";
if (isc.Browser.isStrict && isc.Browser.isMoz) {
    // If the doctype is not available, use the default value for publicId and systemId:
    // "Unless explicitly given when a doctype is created, its public ID and system ID are the empty string."
    // https://dom.spec.whatwg.org/#concept-doctype-publicid
    isc.Browser._docTypePublicID = (document.doctype && document.doctype.publicId) || "";
    isc.Browser._docTypeSystemID = (document.doctype && document.doctype.systemId) || "";
}

// See http://developer.mozilla.org/en/docs/Mozilla%27s_DOCTYPE_sniffing
// See Drawing.test.html for some test cases
isc.Browser.isTransitional = /.*(Transitional|Frameset)/.test((document.all && document.all[0] && document.all[0].nodeValue) || (document.doctype && document.doctype.publicId));

isc.Browser.isIE7 = isc.Browser.isIE && isc.Browser.version == 7;

//> @classAttr Browser.isIE8 (boolean : ? : R)
// Returns true if we're running IE8 and we're in IE8 mode
// IE8 has a 'back-compat' type mode whereby it can run using IE7 rendering logic.
// This is explicitly controlled via the meta tags:
//
//    &lt;meta http-equiv="X-UA-Compatible" content="IE=8" /&gt;
// or
//    &lt;meta http-equiv="X-UA-Compatible" content="IE=7" /&gt;
//
// In beta versions IE8 reported itself version 7 and ran in IE7 mode unless the explicit IE8
// tag was present
// In final versions (observed on 8.0.6001.18702) it reports a browser version of 8 and runs
// in IE8 mode by default - but can be switched into IE7 mode via the explicit IE=7 tag.
//
// We therefore want to check the document.documentMode tag rather than just the standard
// browser version when checking for IE8
//<
isc.Browser.isIE8 = isc.Browser.isIE && isc.Browser.version>=8 && document.documentMode == 8;

//<
//> @classAttr Browser.isIE8Strict (boolean : ? : R)
// Are we in IE8 [or greater] strict mode.
// <P>
// In IE8 when the meta tag is present to trigger IE7 / IE8 mode the document is in
//
//    &lt;meta http-equiv="X-UA-Compatible" content="IE=8" /&gt;
//    &lt;meta http-equiv="X-UA-Compatible" content="IE=7" /&gt;
//
// If this tag is present, the document is in strict mode even if no DOCTYPE was present.
// The presence of this tag can be detected as document.documentMode being 8 rather than 7.
// document.compatMode still reports "CSS1Compat" as with earlier IE.
//<
// IE9 running in IE9 mode will report as IE8Strict:true. This makes sense since rendering quirks
// introduced in IE8 Strict, such as requiring explicit "overflow:hidden" in addition
// to table-layout-fixed in order to clip cells horizontally in tables apply in both places.
// For cases where we really need to distinguish we can check isc.Browser.version or isc.Browser.isIE9

isc.Browser.isIE8Strict = isc.Browser.isIE &&
                            (isc.Browser.isStrict && document.documentMode ==8) ||
                            document.documentMode > 8;

//> @classAttr Browser.isIE9 (boolean : ? : R)
// True if we're running IE9 or later, actually running in the IE9+ documentMode.
//<

isc.Browser.isIE9 = isc.Browser.isIE && isc.Browser.version>=9 && document.documentMode >= 9;

isc.Browser.isIE10 = isc.Browser.isIE && isc.Browser.version >= 10;

isc.Browser.isIE11 = isc.Browser.isIE && isc.Browser.version >= 11;

//> @classAttr  Browser.AIRVersion (String : ? : R)
// If this application running in the Adobe AIR environment, what version of AIR is
// running. Will be a string, like "1.0".
//<
isc.Browser.AIRVersion = (isc.Browser.isAIR ? navigator.userAgent.substring(navigator.userAgent.indexOf("AdobeAir/") + 9) : null);


//>    @classAttr    Browser.safariVersion (number : ? : R)
//        in Safari, what is is the reported version number
//<

if (isc.Browser.isSafari) {

    if (isc.Browser.isAIR) {

        isc.Browser.safariVersion = 530;
    } else {
        if (navigator.userAgent.indexOf("Safari/") != -1) {
            isc.Browser.rawSafariVersion = navigator.userAgent.substring(
                        navigator.userAgent.indexOf("Safari/") + 7
            );
        } else if (navigator.userAgent.indexOf("AppleWebKit/") != -1) {
            isc.Browser.rawSafariVersion = navigator.userAgent.substring(
                        navigator.userAgent.indexOf("AppleWebKit/") + 12
            );

        } else {
            isc.Browser.rawSafariVersion = "530";
        }



        isc.Browser.safariVersion = (function () {
            var rawVersion = isc.Browser.rawSafariVersion,
                currentDot = rawVersion.indexOf(".");

            if (currentDot == -1) return parseInt(rawVersion);
            var version = rawVersion.substring(0,currentDot+1),
                nextDot;
            while (currentDot != -1) {
                // Check AFTER the dot
                currentDot += 1;
                nextDot = rawVersion.indexOf(".", currentDot);
                version += rawVersion.substring(currentDot,
                                                (nextDot == -1 ? rawVersion.length: nextDot));
                currentDot = nextDot;
            }
            return parseFloat(version);
        })();
    }
}

// -------------------------------------------------------------------
// Platform information
// -------------------------------------------------------------------

//>    @classAttr    Browser.isWin        (boolean : ? : R)
//        Is this a Windows computer ?
//<
isc.Browser.isWin = navigator.platform.toLowerCase().indexOf("win") > -1;
if (isc.Browser.isWin) {
    // install winVersion as float
    isc.Browser.winVersion = function() {
        var windowsMatch = navigator.userAgent.match(/Windows NT[ ]*([0-9.]+)[^0-9.]/i);
        if (!windowsMatch && navigator.oscpu) {
            // on Windows, Browser emulation modes like iPhone with iOS report real iOS
            // userAgent strings and don't mention that the machine is Windows - this meant
            // that SC pages, like the showcase, crashed outright in this function if you
            // reloaded the page while emulating such a device, because there was no
            // windowsMatch found above.  To deal with this, fall back to checking
            // navigator.oscpu which has the Widows version
            windowsMatch = navigator.oscpu.match(/Windows NT[ ]*([0-9.]+)[^0-9.]/i);
        }

        if (windowsMatch) return parseFloat(windowsMatch[1]);
    }();

}

// NT 5.0 is Win2k, NT 5.0.1 is Win2k SP1
isc.Browser.isWin2k = isc.Browser.winVersion >= 5.0 && isc.Browser.winVersion < 5.1;


//>    @classAttr    Browser.isMac        (boolean : ? : R)
//        Is this a Macintosh computer ?
//<
isc.Browser.isMac = navigator.platform.toLowerCase().indexOf("mac") > -1;

isc.Browser.isUnix = (!isc.Browser.isMac &&! isc.Browser.isWin);

//> @groupDef mobileDevelopment
// SmartClient is designed to automatically adapt to smaller screen sizes and the lower
// accuracy of touch-based interfaces.
// <p>
// In general, a SmartClient application written with complete ignorance of mobile development
// will still be highly usable on tablet or handset-sized touch devices.  This topic explains
// all the automatic behaviors that make this possible, and the few areas developers need to
// consider in order to optimize the mobile experience, the most important being:
// <p>
// <ul>
// <li> read about potential issues created by the automatically shown and hidden browser
//      toolbars in Safari on iOS7+, discussed under "minimal-ui" below.  SmartClient
//      automatically handles this, but most applications will want to create a non-interactive
//      banner to fill the blank screen area that is rendered unusable by iOS' behavior
// <li> read about "Automatic touch scrolling" below - if your application does not already
//      have alternative UIs for performing drag operations (as is required anyway for
//      +link{group:accessibility,accessibility reasons}), this section discusses options for
//      controlling drag scrolling vs dragging of data
// <li> review your application for the rare screen that has a fixed, very wide width and
//      doesn't allow scrolling.  Such screens would already be unusable for narrow desktop
//      browsers but are more of a problem for fixed-size mobile screens.  The section
//      "Exceptionally wide screens" below explains strategies for dealing with this.
// </ul>
// <p>
// <h3>Supported Browsers</h3>
// <P>
// <ul>
// <li> Safari on iOS devices (iPad, iPhone, iPod Touch)
// <li> Android's default (WebKit-based) browser <b>*</b>
// <li> Windows Phone default browser, latest release only <b>**</b>
// <li> Blackberry 10+ default (WekKit-based) browser <b>**</b>
// </ul>
// <b>*</b>: Android issues that occur <i>exclusively</i> on rare devices (under a certain
// percent of market share) will not normally be covered by a Support plan.  This is a
// necessity because highly customized versions of Android are used for a variety of niche
// devices (even microsatellites)<br>
// <b>**</b>: These browsers generally work and bug reports are accepted, but they do not yet
// fall under the normal Enterprise+ Support guarantee of fixing every confirmed bug
// <p>
// If you would like to check whether a specific device falls under normal Support, or would
// like a quote for a Support plan that would include a specific device or platform,
// +externalLink{http://smartclient.com/company/contact.jsp,contact Isomorphic here}.
// <P>
// <h3>Adaptive Components</h3>
// <p>
// Many SmartClient components automatically change their behavior and/or appearance when used
// with touch devices in general, or tablets and handsets specifically.  There are too many
// adaptations to comprehensively list, but some of the more obvious behaviors are listed below:
// <ul>
// <li> +link{SelectItem} and +link{ComboBoxItem} controls automatically fill the entire screen
//      or a major portion of the screen when activated, and add a control to dismiss the
//      full-screen interface.  See +link{ComboBoxItem.pickListPlacement} for details
// <li> +link{Menu} components likewise fill the entire screen or a major portion, and offer
//      submenu navigation via a slide-in animation and back button instead of displaying the
//      origin menu and submenu simultaneously
// <li> +link{Calendar.minimalUI,Calendar} eliminates the tabs normally used to switch between
//      Day, Week and Month view, instead using device pivot to switch between Day and Week
//      views and offering a compact link to Month view
// <li> Windows and Dialogs fill the screen by default and remove rounded edges to save space
// <li> many controls implement an expanded hit area for clicks or drags so that finger touches
//      that are technically outside of the drawn area of the control still activate the
//      control.  This accommodates the imprecision of finger touches as compared to mouse
//      clicks, while still showing the same compact appearance as is used for desktop
//      interfaces.  This includes the +link{Slider} thumb, +link{Window.headerControls},
//      +link{canvas.resizeFrom,edge-based resizing}, and many other controls.
// <li> +link{SpinnerItem} switches to side-by-side +/- controls instead of the very small,
//      vertically stacked +/- control typical of desktop interfaces
// <li> +link{AdaptiveMenu} can either display menu items inline, or in a drop-down,
//        or mix the two modes according to available space.
// </ul>
// <p>
// In addition to automatic behavior, SmartClient offers Adaptive Layout whereby a +link{Layout}
// member may be <i>designed</i> to render itself at multiple possible sizes, in order to fit
// into the amount of space available in the Layout.  Unlike simply indicating a flexible size
// on a member, setting an adaptive width or height indicates that the member has two (or more)
// different <i>ways</i> of rendering itself with different <i>discrete</I> sizes, but does not
// have the ability to use every additional available pixel.
// <p>
// For more guidance, see the documentation under +link{canvas.canAdaptWidth} and the
// +explorerExample{inlinedMenuMobileSample, Inlined Menu Mobile} and
// +explorerExample{adaptiveMenuMobileSample, Adaptive Menu} samples.
// <p>
// <h3>Finger / touch event handling</h3>
// <P>
// Mobile and touch devices support "touch events" that correspond to finger actions on the
// screen.  By default, SmartClient simply sends touch events to UI components as normal mouse
// events.  Specifically:
// <ul>
// <li> a finger tap gesture will trigger mouseDown, mouseUp and click events
// <li> a touch-and-slide interaction will trigger drag and drop, firing the normal SmartClient
//      sequence of dragStart, dragMove, and dragStop
// <li> a touch-and-hold interaction will trigger a contextMenu event, and will trigger a hover
//      if no contextMenu is shown
// </ul>
// This means that most applications that are written with mouse interaction in mind will
// function with a touch-based UI without special efforts.  Some interfaces which rely heavily
// on mouse hovers may want to display instructions to explicitly tell the user that they have
// to touch a given element to see more information.
// <p>
// <h3>Automatic touch scrolling</h3>
// <p>
// Components that normally show scrollbars on desktop browsers will, by default, hide
// scrollbars and allow scrolling via finger dragging instead.
// <p>
// If you are using drag and drop features such as +link{listGrid.canReorderRecords}, this
// obviously conflicts with using finger drags for scrolling.  There are two options:
// <p>
// <ol>
// <li> Leave touch scrolling active for the grid, but provide additional controls, such as
//      buttons, that enable users to perform the drag operation in a different way.
//      Optionally display scrollbars <em>in addition to</em> leaving touch scrolling active
//      by setting +link{Canvas.alwaysShowScrollbars} to <code>true</code>.
// <li> Set +link{canvas.useTouchScrolling,useTouchScrolling} to <code>false</code> on the component.
//      Scrollbars will be shown, and finger drags will no longer cause scrolling, so that
//      finger drags can now be used for the drag and drop operation configured on the
//      component
// </ol>
// Option #1 above is generally preferred, since it is also considered an
// +link{group:accessibility} violation if drag and drop is the sole way to trigger an
// operation (keyboard-only users cannot use drag and drop), and also because scrollbars are
// not usually found in touch interfaces.
// <p>
// If your application is not required to be keyboard accessible, and you prefer to show
// scrollbars and use finger drags for normal drag operations, you can use
// +link{Canvas.disableTouchScrollingForDrag} to make this choice system-wide or on a
// per-component-type basis.
// <p>
// <h3>Exceptionally wide screens / forms</h3>
// <p>
// If you have designed a screen for desktop use and it is too wide to fit on a handset or
// tablet-sized screen, there are several possible strategies:
// <ul>
// <li> <b>use +link{SplitPane}</b>: any time you have two or more panes where a choice in one
//      pane decides what is displayed in the other.  See the "SplitPane" section further down
//      for details
// <li> <b>rely on horizontal scrolling</b>: if you have something like a +link{DynamicForm}
//      that has 3 columns of input fields, as long as the form itself or some parent has
//      +link{canvas.overflow,overflow:"auto"} set, horizontal touch scrolling will be
//      available to reach fields that initially render offscreen.  Most of the time, there is
//      already an <code>overflow:"auto"</code> parent component as a result of default
//      framework behaviors or application settings that also make sense for desktop mode,
//      so nothing needs to be done.
//      <p>
//      However, consider whether scrolling is already in use for other purposes: if you have a
//      grid plus an adjacent component to the right, if the adjacent component is entirely
//      offscreen, attempting touch scrollng on the grid will just scroll the grid as such and
//      won't reveal the adjacent component.  In this kind of situation, you can:
//   <ul>
//   <li> <i>use +link{SplitPane}</i> as described above, a grid with something adjacent is
//        frequently a good candidate for conversion to <code>SplitPane</code>
//   <li> <i>make the scrolling component smaller or flexible size</i>.  Whether it's a grid or
//        other scrollable component on the left, this situation usually arises because an
//        inappropriately large fixed size has been set, instead of a
//        +link{canvas.width,flexible size}.
//   <li> <i>leave some blank space</i> above or below the grid - this gives the user somewhere
//        to use touch scrolling to move both the grid and adjacent component
//   <li> <i>force scrollbars to appear</i> by setting
//        +link{canvas.useTouchScrolling,useTouchScrolling} to false.  This is another way to
//        give the user a place they can touch in order to scroll the both the grid and
//        adjacent component together
//   </ul>
// <li> <b>use +link{FlowLayout}</b>: a <code>FlowLayout</code> can automatically take two
//      side-by-side elements and switch them to vertical stacking when the screen is narrow
// </ul>
// <p>
// <h3>SplitPane</h3>
// <p>
// The +link{SplitPane} component implements the common pattern of rendering
// two or three panes simultaneously on desktop machines and on tablets in landscape
// orientation, while switching to showing a single pane for handset-sized devices or tablets
// in portrait orientation.
// <p>
// Use <code>SplitPane</code> anywhere you have two or more panes in your application where a
// choice in one pane decides what is displayed in the other pane.  For example, you may have a
// list of Records where details of a single selected Record are shown next to the list.  A
// <code>SplitPane</code> is well-suited to this interface since it provides automatic "Back"
// navigation and a place to show the title of the selected record when only the detail view is
// showing.
// <p>
// Note that you do not need to use a <code>SplitPane</code> as your top-level component
// containing the whole application, and it <i>does</i> makes sense to use multiple
// <code>SplitPane</code> components in a single application.  For example, your top-level
// container component might be a +link{TabSet}, and a +link{SplitPane} would be used to manage
// components in tabs which normally show 2 panes side-by-side on desktop browsers.
// <P>
// <h3>Device type and overriding</h3>
// <p>
// In most cases SmartClient will correctly detect the device running your application, and set
// the flags +link{Browser.isTouch}, +link{Browser.isHandset}, +link{Browser.isTablet} and
// +link{Browser.isDesktop} appropriately.
// <p>
// For any uncommon device for which these variables are not set correctly, you can use
// +link{Browser.setIsTablet()}, +link{Browser.setIsHandset()} and +link{Browser.setIsTouch()}
// to override the auto-detected settings.  If you use these APIs, call them <b>before</b>
// creating or drawing any SmartClient components or using any other SmartClient APIs.
// <p>
// Note that the various automatic behaviors triggered by flags on the +link{Browser} class can
// be overriden at a fine-grained level on individual components.  For example,
// +link{SplitPane} will use 2-pane display when a tablet is detected, however, for a
// particularly large, high-resolution tablet device, you could instead use 3-pane display by
// setting +link{SplitPane.deviceMode} to "desktop".
// <p>
// <h3>Mobile look and feel</h3>
// <P>
// We recommend using either the Shiva, Tahoe, Twilight, Stratus or Obsidian skins for applications
// that support mobile (or a custom skin based on one of these skins).  These skins make
// maximum use of CSS3 to minimize the number of images that need to be loaded and the number
// of DOM elements used to create components.
// <p>
// We also do <b>not</b> recommend attempting to mimic the native UI of each particular mobile
// platform, because:
// <ul>
// <li> if users access the same application via desktop and mobile browsers, consistent
// appearance and behavior between the desktop and mobile rendering of the application is more
// important for familiarity than looking similar to other applications on the mobile device
// <li> mobile platform design overhauls, such as the major changes from iOS6 to iOS7, can
// easily invalidate efforts to look like native applications on the device
// <li> there is no single consistent appearance across Android devices because different
// manufacturers customize the platform a great deal, so efforts to closely mimic any one
// device won't yield any real consistency
// </ul>
// <P>
// <h3>iOS 7, browser toolbars and "minimal-ui" setting</h3>
// <p>
// Safari in iOS 7.0 will automatically hide and show browser toolbars as the user scrolls
// around a normal web page, pivots, or touches near edges of the screen.  This creates serious
// problems for web applications, partly because notifications are not reliably fired when
// toolbars are shown and hidden, and partly because it introduces "dead zones" where an
// application cannot place interactive controls, since touching there shows browser toolbars
// instead.
// <p>
// iOS 7.1 introduces a "minimal-ui" setting on the viewport <code>meta</code> tag which
// eliminates most of these problems, by requiring that the user specifically touch the
// URL bar to reveal browser toolbars.  Even with this setting, the top 20px of space <i>in
// landscape orientation only</i> is still a "dead zone".
// <p>
// SmartClient automatically uses the minimal-ui setting whenever iOS is detected, and also
// sets +link{canvas.defaultPageSpace} to 20px in landscape orientation to avoid components
// being placed in the dead zone.  These default behaviors can be disabled by defining the
// <code>isc_useMinimalUI</code> global variable with the value <code>false</code> before the
// framework is loaded:
// <pre> &lt;script type="text/javascript"&gt;
// window.isc_useMinimalUI = false;
// &lt;/script&gt;</pre>
// <p>
// Whether minimal-ui is used or not, it is recommend to place some kind of non-interactive
// widget or content in the dead zones created by browser toolbars, for example, a +link{Label}
// showing your company name or application name.  When using +link{canvas.defaultPageSpace} to have
// all components avoid a dead zone at the top of the page, you can set
// +link{canvas.leavePageSpace,leavePageSpace:0} to allow individual components to place
// themselves in a dead zone.
// <p>
// <h3>Configuring the viewport</h3>
// <p>
// When a SmartClient application loads, by default a viewport &ltmeta&gt; tag is added to the
// page which, on touch devices, fixes the page zoom to 100% and disables the pinch-zoom gesture.
// This is usually the expected behavior of a touch-enabled web application because it makes
// the application look and feel more like a native app. This default setting can be disabled
// by defining the <code>isc_useDefaultViewport</code> global variable with the value
// <code>false</code> before the framework is loaded:
// <pre> &lt;script type="text/javascript"&gt;
// window.isc_useDefaultViewport = false;
// &lt;/script&gt;</pre>
// For more information on the mobile device viewport, see:
// <ul>
// <li>+externalLink{https://developer.mozilla.org/en-US/docs/Web/HTML/Viewport_meta_tag,Using the viewport meta tag to control layout on mobile browsers [MDN]}</li>
// <li>+externalLink{https://www.w3schools.com/css/css_rwd_viewport.asp,Responsive Web Design - The Viewport [w3schools]}</li>
// </ul>
// <p>
// <h3>Orientation Change &amp; Screen Size</h3>
// <P>
// When orientation changes, this is treated identically to resizing the browser on a desktop
// machine.  If you've already created a UI that fills the browser and makes good use of
// available screen space for desktop browsers, the same behaviors will automatically apply
// when your application runs on mobile devices and the device is pivoted.
// <P>
// If you want to build specialized interfaces that respond to device orientation, the
// +link{Page.getOrientation()} API may be used to determine the current orientation of the
// application, and +link{pageEvent,the page orientationChange event} will fire whenever the
// user rotates the screen allowing applications or components to directly respond to the user
// pivoting their device.
// <p>
// <h3>Launching native helper apps (phone, facetime, maps..)</h3>
// <p>
// Generally, all that's required to launch native mobile apps is to create an ordinary HTML
// hyperlink (<code>&lt;a&gt;</code> tag) with a special prefix for the URL specified in the
// <code>href</code> attribute.  For example, the following HTML link will place a call when
// the user finger-taps it:
// <pre>
//   &lt;a href="tel:8675309"&gt;Call Jenny&lt;/a&gt;</pre>
// You can provide HTML like this as +link{HTMLFlow.contents}.  Or use a field of
// +link{type:FieldType,type:"link"} to cause various
// +link{DataBoundComponent,DataBoundComponents} to render a DataSourceField value as a
// clickable URL.
// <p>
// The URL prefixes that are valid for iOS are documented
// +externalLink{https://developer.apple.com/library/ios/featuredarticles/iPhoneURLScheme_Reference/Introduction/Introduction.html#//apple_ref/doc/uid/TP40007899-CH1-SW1,at Apple.com}.
// Typically, the same prefixes also work for Android, Windows Phone and others.
// <p>
// <h3>Configure the soft keyboard</h3>
// <p>
// +link{TextItem.browserInputType} can be set to various values such as "email" or "tel"
// (telephone number) to hint to mobile devices to use a different software keyboard with
// specialized keys appropriate for entering certain types of data values.
// <p>
// <h3>Note on mobile platform performance</h3>
// <p>
// When the first modern smartphones were released, it was necessary to use tiny,
// mobile-specific frameworks to get adequate performance for mobile web applications.
// <p>
// The situation is now completely different: through a combination of hardware improvements,
// optimizations in mobile browsers and vastly improved network speeds, typical mobile devices
// are easily able to run applications built with full-featured web platforms like SmartClient.
// For an application that supports both desktop and mobile interfaces, the worst case scenario
// for platform performance is often <b>not</b> a mobile phone, but an older desktop machine
// running Internet Explorer.
// <p>
// Unfortunately, there is a lot of out-of-date advice on the web about mobile web development
// that still advises using ultra-light, feature-poor frameworks for performance reasons.
// Carefully consider the source and recency of any such advice - the reality is that using
// such feature-poor frameworks means you will under-deliver with both your desktop <i>and</i>
// mobile interfaces.
// <p>
// For more background on choosing the right technologies for mobile and desktop web
// applications, see the
// +externalLink{http://smartclient.com/product/mobileStrategy.jsp,Mobile Strategy Page} at
// smartclient.com.
// <P>
// <h3>Offline Operation</h3>
// <P>
// SmartClient applications support "offline" operation (continuing to work without network
// access).
// <P>
// Permanent caching of resources such as .js, .css files and images are handled via the standard
// +externalLink{https://www.google.com/search?q=html5+manifest,HTML5 Manifest} - just list all
// the static files your application needs in a manifest file and mobile browsers will cache
// those resources.
// <P>
// Dynamic data is handled via the +link{Offline} APIs as well as special DataSource support
// enabled by +link{DataSource.useOfflineStorage}.
// <P>
// The end result is that you can bookmark a SmartClient application to a phone's home screen
// and use it offline with cached data, much like an installed native application.
// <P>
// <h2>Packaging as a native application</h2>
// <P>
// Via "packaging" technologies such as PhoneGap/Cordova and Titanium, a SmartClient web application
// can be packaged as an installable native application that can be delivered via the "App Store"
// for the target mobile platform.  Applications packaged in this way have access to phone-specific
// data and services such as contacts stored on the phone, or the ability to invoke the device's camera.
// <P>
// Both Titanium and PhoneGap provide access to the underlying native device APIs such as the
// accelerometer, geolocation, and UI. Both frameworks enable application development using
// only JavaScript, CSS and HTML. Additionally they provide development environments that work
// across a wide variety of devices.
// <P>
// PhoneGap has good support for native device APIs as noted +externalLink{http://www.phonegap.com/about/feature,here}.
// Titanium has similar support. There are differences between the two environments and how they
// expose their APIs, though both provide Xcode-compatible projects that can be compiled and run from the Xcode IDE.
// See +link{titaniumIntegration,Integration with Titanium} and +link{phonegapIntegration,Integration with PhoneGap}
// for more information.
//
// @title Mobile Application Development
// @treeLocation Concepts
// @visibility external
//<


//> @groupDef titaniumIntegration
// Titanium provides an extensive Javascript API to access a native device's UI, phone, camera, geolocation, etc.
// Documentation, getting started, programming guides are +externalLink{http://developer.appcelerator.com/documentation,here}.
// Titanium provides a consistent API across devices including the ability to mix webviews with native controls.
// <P>
// The Titanium sample application provides an example of accessing a device's Contacts db using SmartClient.
// The application presents 2 tabs 'Customers' and 'Contacts' and allows the user to import Customer contacts into
// his/her contacts db resident on the device. Selecting a Customer's Contact address will show a map of the contact.
// Selecting a Customer's phone number will call the customer or prompt to import the contact into the user's
// contacts. The latter option is default behavior on the iPad. Calling the customer contact is default behavior for
// devices such as the iPhone or Android.
// <P>
// The Titanium Contact object holds the following properties:
// <ul>
// <li>URL</li>
// <li>address</li>
// <li>birthday</li>
// <li>created</li>
// <li>date</li>
// <li>department</li>
// <li>email</li>
// <li>firstName</li>
// <li>firstPhonetic</li>
// <li>fullName</li>
// <li>image</li>
// <li>instantMessage</li>
// <li>jobTitle</li>
// <li>kind</li>
// <li>lastName</li>
// <li>lastPhonetic</li>
// <li>middleName</li>
// <li>middlePhonetic</li>
// <li>modified</li>
// <li>nickname</li>
// <li>note</li>
// <li>organization</li>
// <li>phone</li>
// <li>prefix</li>
// <li>relatedNames</li>
// <li>suffix</li>
// </ul>
// <P>
// The following Titanium API's are used:
// <ul>
// <li>Titanium.App.addEventListener</li>
// <li>Titanium.App.fireEvent</li>
// <li>Titanium.Contacts.getAllPeople</li>
// <li>Titanium.Geolocation.forwardGeocoder</li>
// <li>Titanium.Map.STANDARD_TYPE,</li>
// <li>Titanium.Map.createView</li>
// <li>Titanium.UI.createTab</li>
// <li>Titanium.UI.createTabGroup</li>
// <li>Titanium.UI.createWebView</li>
// <li>Titanium.UI.createWindow</li>
// <li>Titanium.UI.setBackgroundColor</li>
// </ul>
// <P>
// The following SmartClient Components are used
// <ul>
// <smartclient>
// <li>isc.DataSource</li>
// <li>isc.ListGrid</li>
// </smartclient>
// <smartgwt>
// <li>DataSource</li>
// <li>ListGrid</li>
// </smartgwt>
// </ul>
// <P>
// The following SmartClient Resources are bundled in the Titanium application
// <ul>
// <li>ISC_Containers.js</li>
// <li>ISC_Core.js</li>
// <li>ISC_DataBinding.js</li>
// <li>ISC_Foundation.js</li>
// <li>ISC_Grids.js</li>
// <li>load_skin.js</li>
// <li>skins/Mobile/images/black.gif</li>
// <li>skins/Mobile/images/blank.gif</li>
// <li>skins/Mobile/images/checked.png</li>
// <li>skins/Mobile/images/formula_menuItem.png</li>
// <li>skins/Mobile/images/grid.gif</li>
// <li>skins/Mobile/images/group_closed.gif</li>
// <li>skins/Mobile/images/group_opened.gif</li>
// <li>skins/Mobile/images/headerMenuButton_icon.gif</li>
// <li>skins/Mobile/images/loading.gif</li>
// <li>skins/Mobile/images/loadingSmall.gif</li>
// <li>skins/Mobile/images/opacity.png</li>
// <li>skins/Mobile/images/pinstripes.png</li>
// <li>skins/Mobile/images/row_collapsed.gif</li>
// <li>skins/Mobile/images/row_expanded.gif</li>
// <li>skins/Mobile/images/sort_ascending.gif</li>
// <li>skins/Mobile/images/sort_descending.gif</li>
// <li>skins/Mobile/skin_styles.css</li>
// </ul>
//
// @title Integration with Titanium
// @treeLocation Concepts/Mobile Application Development
// @visibility external
//<

//> @groupDef phonegapIntegration
// <P>
// PhoneGap documentation, quick start information, and programming guides are available at +externalLink{http://phonegap.com,http://phonegap.com}.
// <P>
// PhoneGap exposes a Contacts API which allows one to find, create and remove contacts from the device's contacts database.
// Unlike Titanium, which provides many native UI components, PhoneGap relies on 3rd party frameworks for
// UI components. Additionally, PhoneGap provides no transitions or other animation effects normally
// accessible in native applications.
// <P>
// <em>In the following guide, the name "MyMobileApp" refers to a SmartClient mobile application.
// The instructions are intended to be general, and applicable to other apps by simply substituting
// the application name and the few other app-specific details.</em>
//
// <h3>Installing PhoneGap</h3>
// Beginning with PhoneGap 2.9.0, PhoneGap is an NPM (Node.js Packager Manager) package.
// You will need to install Node.js first in order to install PhoneGap. (<b>Tip for Mac users:</b>
// +externalLink{http://brew.sh,Homebrew} is a simple and easy way
// to install the latest version of Node.js and npm: <code>brew install node</code>)
//
// <p>Once Node.js is installed, see +externalLink{http://phonegap.com/install/,http://phonegap.com/install/} for
// instructions on installing PhoneGap.
//
// <h3>Creating the PhoneGap Project</h3>
// Use the +externalLink{http://docs.phonegap.com/en/edge/guide_cli_index.md.html,<code>phonegap</code> command line utility}
// to create a new folder containing the project files:
//
// <pre style="white-space:nowrap">phonegap create --id com.mycompany.apps.MyMobileApp --name "MyMobileApp" path/to/project_folder</pre>
//
// <p>The project ID and name should be changed for your app.
//
// <h3>General Instructions</h3>
// Within the project folder, PhoneGap creates a special <code>www/</code> folder which contains
// the application JavaScript code and other assets. Within this folder, only <code>config.xml</code>
// is needed. All other files of the default "Hello PhoneGap" app can be deleted.
//
// <p>You will need to open the application's main HTML file in a text editor to make a few changes:
// <ul>
//   <li>Change the DOCTYPE to the HTML5 DOCTYPE: <code>&lt;!DOCTYPE html&gt;</code></li>
//   <li>Add a <code>&lt;script&gt;</code> tag to the <code>&lt;head&gt;</code> element to load <code>cordova.js</code>:
//       <pre>&lt;script type="text/javascript" charset="UTF-8" src="cordova.js"&gt;&lt;/script&gt;</pre>
//
//       <p><b>NOTE:</b> The <code>www/</code> folder should not contain <code>cordova.js</code>.
//       In other words, don't try to copy <code>cordova.js</code> into the <code>www/</code> folder.
//       PhoneGap automatically adds the appropriate version of this script, which is different for
//       each platform.</li>
//   <li>Ensure that the following <code>&lt;meta&gt;</code> tags are used, also in the <code>&lt;head&gt;</code> element:
//       <pre>&lt;meta http-equiv="Content-Type" content="text/html;charset=UTF-8"&gt;
//&lt;meta name="format-detection" content="telephone=no"&gt;
//&lt;meta name="viewport" content="initial-scale=1, width=device-width, user-scalable=no, minimum-scale=1, maximum-scale=1"&gt;</pre></li>
// </ul>
//
// <p>After making those changes, you will need to defer starting the application until the
//    <code>+externalLink{http://docs.phonegap.com/en/edge/cordova_events_events.md.html#deviceready,deviceready}</code> event has fired,
//    particularly if your application invokes any PhoneGap API function.
//
//        <smartclient>In SmartClient, deferring the application can be accomplished by wrapping all application code within a 'deviceready' listener:
//        <pre class="sourcefile">&lt;script type="text/javascript"&gt;
//document.addEventListener("deviceready", function onDeviceReady() {
//    // application code goes here
//}, false);
//&lt;/script&gt;</pre></smartclient>
//
//        <smartgwt>To accomplish this in Smart&nbsp;GWT, it is helpful to use a utility class together with a bit of JavaScript.
//
// <p>The following utility class can be used to defer the <code>onModuleLoad</code> code until PhoneGap is ready:
//
// <pre class="sourcefile">package com.mycompany.client;
//
//import com.google.gwt.core.client.EntryPoint;
//
//public abstract class CordovaEntryPoint implements EntryPoint {
//
//    &#x40;Override
//    public final native void onModuleLoad() &#x2F;*-{
//        var self = this;
//        if ($wnd.isDeviceReady) self.&#x40;com.mycompany.client.CordovaEntryPoint::onDeviceReady()();
//        else {
//            var listener = $entry(function () {
//                $doc.removeEventListener("deviceready", listener, false);
//                self.&#x40;com.mycompany.client.CordovaEntryPoint::onDeviceReady()();
//            });
//            $doc.addEventListener("deviceready", listener, false);
//        }
//    }-*&#x2F;;
//
//    protected abstract void onDeviceReady();
//}</pre>
//
// <p>The <code>CordovaEntryPoint</code> class is used in conjunction with the following JavaScript,
//        which should be added before the closing <code>&lt/body&gt;</code> tag:
//
//     <pre class="sourcefile">&lt;script type="text/javascript"&gt;
//document.addEventListener("deviceready", function onDeviceReady() {
//    window.isDeviceReady = true;
//    document.removeEventListener("deviceready", onDeviceReady, false);
//}, false);
//&lt;/script&gt;</pre>
//
// <p>After compiling your application with PhoneGap/Cordova support, copy the compiled Smart&nbsp;GWT
// application to the <code>www/</code> folder.
// </smartgwt>
//
// <h3>iOS Platform (iPhone &amp; iPad)</h3>
//
// <ol>
// <li>Open <b>Terminal</b>, <code>cd</code> into the project folder, and run:
// <pre>phonegap build ios</pre></li>
// <li>Within the newly-created <code>platforms/ios/</code> folder, open the Xcode project <code>MyMobileApp.xcodeproj</code>.</li>
// <li>In Xcode, set the active scheme to <b>MyMobileApp &gt; iPhone Retina (4-inch) &gt; iOS 7.0</b> or some other simulator destination.
//     Then click the <b>Run</b> button. Xcode will start the iPhone Simulator and run the app.</li>
// <li>When you are finished testing the application in the simulator, click the <b>Stop</b> button.</li>
// </ol>
//
// <p>It is helpful to pay attention to the output window when testing the app within iOS Simulator.
// The output window contains all logs to <code>+externalLink{https://developer.mozilla.org/en-US/docs/Web/API/console,window.console}</code> and messages from the Cordova
// framework itself. One common issue is <code>ERROR whitelist rejection: url='SOMEURL'</code>,
// which means that SOMEURL has not been added to <code>&lt;access origin="..."/&gt;</code> in <code>config.xml</code>.
// Refer to the +externalLink{http://docs.phonegap.com/en/edge/guide_whitelist_index.md.html#Domain%20Whitelist%20Guide,Domain Whitelist Guide}
// for more information.
//
// <p>Once you have completely tested the application within the simulator, you should test the app on
// real hardware. Refer to Apple's +externalLink{https://developer.apple.com/library/ios/documentation/IDEs/Conceptual/AppDistributionGuide/Introduction/Introduction.html,App Distribution Guide} for complete instructions on provisioning the app for testing devices, in particular, the section titled
// +externalLink{https://developer.apple.com/library/ios/documentation/IDEs/Conceptual/AppDistributionGuide/TestingYouriOSApp/TestingYouriOSApp.html#//apple_ref/doc/uid/TP40012582-CH8-SW1,Beta Testing Your iOS App}.
//
// <p>Apple has deprecated UIWebView and we recommend switching to the officially supported
// +externalLink{https://github.com/apache/cordova-plugin-wkwebview-engine,WKWebView} plugin to
// resolve momentum scrolling issues and obtain more Safari-like behavior.
//
// <h3>Android Platform</h3>
// To begin targeting Android devices, follow the instructions on the
// +externalLink{http://docs.phonegap.com/en/edge/guide_platforms_android_index.md.html,Android Platform Guide}.
//
// <p>It is helpful to monitor the LogCat view in Eclipse to verify that your application is working correctly.
// Common errors include:
// <ul>
// <li><code>Application Error The protocol is not supported. (gap://ready)</code>
//     <p>This means that the incorrect <code>cordova.js</code> script is being used. You
//     must use the <code>cordova.js</code> for Android.<!-- http://community.phonegap.com/nitobi/topics/error_starting_app_on_android -->
//     <p>Try updating the 'android' platform to fix the problem:
//     <pre>phonegap platform update android</pre>
//     </li>
// <li><code>Data exceeds UNCOMPRESS_DATA_MAX</code>
//     <p>In older versions of Android (pre-2.3.3), there is a 1 Megabyte limit on the size of individual
//        Android app assets. This error message means that one asset file exceeds this limit.
//        You should see a popup alert dialog containing the name of the problematic file, and then the app will crash.
//     <p>The "Data exceeds UNCOMPRESS_DATA_MAX" error can be seen if, for example, the SmartGWT.mobile application
//        was compiled in DETAILED or PRETTY mode.
//     </li>
// </ul>
//
// <h3>Samples</h3>
// <smartclient>
// <p>The SmartClient SDK package has a sample application called MyContacts which demonstrates how
// to work with the PhoneGap API in a SmartClient app. The main SmartClient code is located in
// <code>smartclientSDK/examples/phonegap/MyContacts</code>. An Xcode project used to package the app for iOS
// devices is located at <code>smartclientSDK/examples/phonegap/MyContacts-iOS</code>. An Eclipse project used
// to package the app for Android devices is located at <code>smartclientSDK/examples/phonegap/MyContacts-Android</code>.
// </smartclient><smartgwt>
// <p>The Smart&nbsp;GWT Google Code project has a sample application called
// +externalLink{https://github.com/isomorphic-software/smartgwt/tree/master/samples/phonegap/MyContacts,MyContacts}
// which demonstrates how to work with the PhoneGap API in a Smart&nbsp;GWT app. The main Smart&nbsp;GWT code is located at
// <code>+externalLink{https://github.com/isomorphic-software/smartgwt/tree/master/samples/phonegap/MyContacts,trunk/samples/phonegap/MyContacts}</code>.
// An Xcode project used to package the app for iOS devices is located at <code>
// +externalLink{https://github.com/isomorphic-software/smartgwt/tree/master/samples/phonegap/MyContacts-iOS,trunk/samples/phonegap/MyContacts-iOS}</code>.
// An Eclipse project used to package the app for Android devices is located at <code>
// +externalLink{https://github.com/isomorphic-software/smartgwt/tree/master/samples/phonegap/MyContacts-Android,trunk/samples/phonegap/MyContacts-Android}</code>.
//
// <p>This sample application utilizes the script changer technique to load the correct <code>cordova.js</code>.
// Additionally, GWT's +externalLink{http://www.gwtproject.org/doc/latest/DevGuideCodingBasicsOverlay.html,JavaScript overlay types}
// feature is used to easily wrap the PhoneGap Contacts API for use by the Smart&nbsp;GWT app.
// </smartgwt>
//
// @title Integration with PhoneGap
// @treeLocation Concepts/Mobile Application Development
// @visibility external
//<

isc.Browser.isAndroid = navigator.userAgent.indexOf("Android") > -1;

if (isc.Browser.isAndroid) {
    var pos = navigator.userAgent.indexOf("Android");
    if (pos >= 0) {
        isc.Browser.androidMinorVersion = parseFloat(navigator.userAgent.substring(pos + "Android".length));
        // Firefox for Android does not say which version of Android it's running on.
        // See also:
        // - https://developer.mozilla.org/en/Gecko_user_agent_string_reference#Mobile_and_Tablet_indicators
        // - Bug 625238 - Add device info to User-Agent
        //   https://bugzilla.mozilla.org/show_bug.cgi?id=625238
        if (window.isNaN(isc.Browser.androidMinorVersion)) delete isc.Browser.androidMinorVersion;
    }

    // Is the browser a WebView? This is true for the stock Android Browser and third-party apps'
    // WebViews (such as when using Cordova/PhoneGap), but should be false for other Android browsers.
    // From https://developers.google.com/chrome/mobile/docs/webview/overview#what_is_the_default_user-agent
    // "If you're attempting to differentiate between the WebView and Chrome for Android, you
    // should look for the presence of the Version/X.X string in the WebView user-agent string.
    // Don't rely on the specific Chrome version number, 30.0.0.0 as this may change with future
    // releases."
    isc.Browser.isAndroidWebView = navigator.userAgent.indexOf("Version/") >= 0;
}


isc.Browser.isRIM = isc.Browser.isBlackBerry =
    navigator.userAgent.indexOf("BlackBerry") > -1 || navigator.userAgent.indexOf("PlayBook") > -1;

isc.Browser.isMobileIE = navigator.userAgent.indexOf("IEMobile") > -1;

// Is the browser Mobile Firefox?
// https://wiki.mozilla.org/Compatibility/UADetectionLibraries
// https://developer.mozilla.org/en-US/docs/Gecko_user_agent_string_reference#Mobile_and_Tablet_indicators
isc.Browser.isMobileFirefox = isc.Browser.isFirefox && (navigator.userAgent.indexOf("Mobile") > -1 ||
                                                        navigator.userAgent.indexOf("Tablet") > -1);


isc.Browser.isMobileWebkit = (isc.Browser.isSafari &&
        (navigator.userAgent.indexOf(" Mobile/") > -1 || navigator.userAgent.indexOf("(iPad") > -1)
    || isc.Browser.isAndroid
    || isc.Browser.isBlackBerry) && !isc.Browser.isFirefox;


isc.Browser.isMobileWebkitDesktopMode = isc.Browser.isSafari &&
    navigator.platform == "MacIntel" && navigator.maxTouchPoints > 0;
if (window.isc_ignoreMobileSafariDesktopMode !== false && isc.Browser.isMobileWebkitDesktopMode) {
    isc.Browser.isMobileWebkit = true;
}


// intended for general mobile changes (performance, etc)
isc.Browser.isMobile = (isc.Browser.isMobileFirefox ||
                        isc.Browser.isMobileIE ||
                        isc.Browser.isMobileWebkit);

//> @classAttr browser.supportsDualInput (boolean : varies : RW)
// Does the browser support both mouse and touch input?
// @visibility external
//<

isc.Browser.supportsDualInput = window.isc_useDualInput != false &&
        (isc.Browser.isWin && isc.Browser.winVersion >= 6.2 || isc.Browser.isChromeOS) &&
        (isc.Browser.isMoz ||
         ((isc.Browser.isChrome || isc.Browser.isIE11 || isc.Browser.isEdge) &&
          navigator.maxTouchPoints > 0));

isc.Browser._useTouchMoveImageCSS = isc.Browser.supportsDualInput &&
        (isc.Browser.isIE11 || isc.Browser.isEdge);

isc.Browser._useTouchMoveCanvasCSS = isc.Browser._useTouchMoveImageCSS &&
        window.isc_useNativeTouchScrolling == false;


if (isc.Browser.supportsDualInput && isc.Browser.isChrome) {
    isc.Browser.minDualInputThumbLength = 28;
}

//> @classAttr browser.isTouch (boolean : auto-detected based on device : RW)
// Is the application running on a touch device (e.g. iPhone, iPad, Android device, etc.)?
// <p>
// SmartClient's auto-detected value for <code>isTouch</code> can be overridden via
// +link{Browser.setIsTouch()}.
//
// @visibility external
//<




isc.Browser._mobileBrowsers = (isc.Browser.isMobileFirefox ||
                                isc.Browser.isMobileIE || isc.Browser.isMobileWebkit);

isc.Browser.isTouch = isc.Browser.isWin || isc.Browser.isChromeOS ?
        isc.Browser._mobileBrowsers ||
            (isc.Browser.supportsDualInput && !!window.isc_useDualInput)
     :
        (( 'ontouchstart' in window ) ||
         (navigator.maxTouchPoints != null && navigator.maxTouchPoints > 0));

//> @classMethod browser.setIsTouch() (A)
// Setter for +link{Browser.isTouch} to allow this global variable to be changed at runtime.
// This advanced method is provided to override SmartClient's auto-detection logic, since the
// framework can only detect touch devices that existed at the time the platform was released.
// Any change to +link{Browser.isTouch} must be made before any component is created;
// <strong>it is an application error</strong> to attempt to change <code>isTouch</code> after
// components have been created.
// <p>
// Note that setting <code>Browser.isTouch</code> might affect the values of
// +link{Browser.isDesktop}, +link{Browser.isTablet}, and/or +link{Browser.isHandset}.
//
// @param isTouch (boolean) new setting for <code>Browser.isTablet</code>.
// @visibility external
//<
isc.Browser.setIsTouch = function (isTouch) {
    var Browser = this;

    isTouch = Browser.isTouch = !!isTouch;

    if (Browser.isDesktop) {
        Browser.isHandset = false;
        Browser.isTablet = false;
    } else {
        Browser.isHandset = isTouch && !Browser.isTablet;
        Browser.isTablet = !Browser.isHandset;
    }

    Browser.hasNativeDrag = !isTouch && "draggable" in document.documentElement &&
        !(Browser.isIE || Browser.isEdge);

    Browser.nativeMouseMoveOnCanvasScroll = !isTouch && (Browser.isSafari || Browser.isChrome);


};

//> @classAttr browser.pointerEnabled (boolean : varies : RW)
// Does the browser support pointer events as a means of capturing both touch and mouse
// interactions?  This simplifies event handling for capable browsers.
//<

isc.Browser.pointerEnabled = window.PointerEvent != null &&
        navigator.pointerEnabled != false && navigator.msPointerEnabled != false &&
        (isc.Browser.isIE || isc.Browser.isEdge) && !isc.Browser.isMobileIE;

//> @classAttr browser.hasDualInput (boolean : false : RW)
// is the browser currently sending both mouse and touch input?  For example, Microsoft Surface
// devices are touch devices that run Windows 10 but also allow the connection of USB mice.  In
// such an environment, we may not be able to auto-detect that touch input is present, so the
// switch to hasDualINput: true will only happen at the moment a touch event actually arrives.
//<
isc.Browser.hasDualInput = !!window.isc_useDualInput;

// helper called by EventHandler to switch to dual input mode if a touch event arrives
isc.Browser.setHasDualInput = function () {

    if (this.hasDualInput == true) return;



    if (isc.logInfo) {
        isc.logInfo("Switching to dual input mode to handle touch events");
    }

    this.setIsTouch(true);
    this.hasDualInput = true;


    if (isc.Canvas) {
        isc.Canvas.addProperties({
            overflowStyle: "none",
            _browserSupportsNativeTouchScrolling: isc.Browser._getSupportsNativeTouchScrolling
                && isc.Browser._getSupportsNativeTouchScrolling()
        });
    }
    if (isc.ListGrid) {
        isc.ListGrid.addProperties({
            showRollOver: false,
            // if a mouse event is received, switch rollover back on
            handleMouseMove : function (event, eventInfo) {
                return this._handleDualInputMouseMove(event, eventInfo);
            }
        });
    }
};

// iPhone OS including iPad.  Search for iPad or iPhone.

isc.Browser.isIPhone = (isc.Browser.isMobileWebkit &&
                        (navigator.userAgent.indexOf("iPhone") > -1 ||
                         navigator.userAgent.indexOf("iPad") > -1));

if (isc.Browser.isIPhone) {
    // adapted from SmartGWT.mobile
    var match = navigator.userAgent.match(/CPU\s+(?:iPhone\s+)?OS\s*([0-9_]+)/i);
    if (match != null) {
        isc.Browser.iOSMinorVersion = window.parseFloat(match[1].replace('_', '.'));
        isc.Browser.iOSVersion = isc.Browser.iOSMinorVersion << 0;
    }

    // The UIWebView user agent is different from the Mobile Safari user agent in that it does
    // not contain the word "Safari".
    isc.Browser.isUIWebView = navigator.userAgent.indexOf("Safari") < 0;

    // Chrome for iOS
    // https://developers.google.com/chrome/mobile/docs/user-agent#chrome_for_ios_user-agent
    isc.Browser.isIOSChrome = navigator.userAgent.indexOf("CriOS/") >= 0;
    // Firefox for iOS
    // https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/User-Agent/Firefox
    isc.Browser.isIOSFirefox = navigator.userAgent.indexOf("FxiOS/") >= 0;

    isc.Browser.isMobileSafari = !isc.Browser.isUIWebView && !isc.Browser.isIOSChrome
                                    && !isc.Browser.isIOSFirefox;

}

// iPad.  Checks for "iPhone" OS + "iPad" in UA String.
isc.Browser.isIPad = (isc.Browser.isIPhone &&
                        navigator.userAgent.indexOf("iPad") > -1);
// Handle the mobile-safari masquerading as desktop case

if (window.isc_ignoreMobileSafariDesktopMode !== false &&
    isc.Browser.isMobileWebkitDesktopMode && !isc.Browser.isAndroid)
{
    isc.Browser.isIPhone = true;
    isc.Browser.isMobileSafari = true;

    // Assume iPad at this point rather than iPhone.
    // When isc.Page has been created we'll look at page dimensions and set to
    // iPhone/handset if necessary
    isc.Browser.isIPad = true;

    // set the iOS version from the spoofed desktop userAgent reported by iPad

    var match = navigator.userAgent.match(/Mac OS[^)]*\).*Version\/([0-9.]+)/);
    if (match != null) {
        var desktopAgentVersion = window.parseFloat(match[1]);
        isc.Browser.iOSVersion = Math.trunc(desktopAgentVersion);
        isc.Browser.iOSMinorVersion = isc.Browser.iOSVersion;
    }
}

isc.Browser.isWindowsPhone = navigator.userAgent.indexOf("Windows Phone") > -1;


if (isc.Browser.isIPad && isc.Browser.isMobileSafari && isc.Browser.iOSVersion == 7) {

    var iOS7IPadStyleSheetID = "isc_iOS7IPadStyleSheet";
    if (document.getElementById(iOS7IPadStyleSheetID) == null) {
        var styleElement = document.createElement("style");
        styleElement.id = iOS7IPadStyleSheetID;
        document.head.appendChild(styleElement);
        var s = styleElement.sheet;
        s.insertRule("\n@media (orientation:landscape) {\n" +
                         "html {" +
                             "position: fixed;" +
                             "bottom: 0px;" +
                             "width: 100%;" +
                             "height: 672px;" +
                         "}" +
                         "body {" +
                             "position: fixed;" +
                             "top: 0px;" +
                             "margin: 0px;" +
                             "padding: 0px;" +
                             "width: 100%;" +
                             "height: 672px;" +
                         "}\n" +
                     "}\n", 0);
    }


    (function () {
        var isFormItemElement = function (element) {
            if (element == null) return false;
            var tagName = element.tagName;
            return (tagName === "INPUT" ||
                    tagName === "SELECT" ||
                    tagName === "TEXTAREA");
        };

        var scrollToTopTimerID = null;
        window.addEventListener("scroll", function () {
            if (document.body == null) return;
            var scrollTop = document.body.scrollTop;
            if (scrollTop == 0) return;

            var activeElement = document.activeElement;
            if (isFormItemElement(activeElement)) {
                var onBlur = function onBlur(blurEvent) {
                    activeElement.removeEventListener("blur", onBlur, true);

                    if (scrollToTopTimerID != null) clearTimeout(scrollToTopTimerID);
                    scrollToTopTimerID = setTimeout(function () {
                        scrollToTopTimerID = null;

                        activeElement = document.activeElement;

                        // If another form item element is active, then wait for that element to lose focus.
                        if (activeElement !== blurEvent.target && isFormItemElement(activeElement)) {
                            activeElement.addEventListener("blur", onBlur, true);

                        } else {
                            document.body.scrollTop = 0;
                        }
                    }, 1);
                };
                activeElement.addEventListener("blur", onBlur, true);
            } else {
                document.body.scrollTop = 0;
            }
        }, false);
    })();
}


//> @type DeviceMode
// Possible layout modes for UI components that are sensitive to the device type being used
// (a.k.a. "responsive design").  See for example +link{SplitPane.deviceMode}.
// @value "handset" mode intended for handset-size devices (phones).  Generally only one UI
//                  panel will be shown at a time.
// @value "tablet" mode intended for tablet-size devices.  Generally, up to two panels are
//                 shown side by side in "landscape" +link{type:PageOrientation}, and only one
//                 panel is shown in "portrait" orientation.
// @value "desktop" mode intended for desktop browsers.  Three or more panels may be shown
//                  simultaneously.
// @visibility external
//<

//> @classAttr browser.isTablet (boolean : auto-detected based on device : RW)
// Is the application running on a tablet device (e.g. iPad, Nexus 7)?
// <p>
// SmartClient can correctly determine whether the device is a tablet in most cases. On any
// uncommon device for which this variable is incorrect, you can define the <code>isc_isTablet</code>
// global with the correct value, and SmartClient will use <code>isc_isTablet</code> for
// <code>Browser.isTablet</code> instead of its own detection logic. Alternatively, you can use
// +link{Browser.setIsTablet()} to change this global variable before any components are
// created.
// <p>
// The value of this variable is only meaningful on touch devices.
//
// @setter setIsTablet()
// @visibility external
//<

if (window.isc_isTablet != null) {
    isc.Browser.isTablet = !!window.isc_isTablet;
} else {
    isc.Browser.isTablet = isc.Browser.isIPad ||
                           (isc.Browser.isRIM && navigator.userAgent.indexOf("Tablet") > -1) ||
                           (isc.Browser.isAndroid && navigator.userAgent.indexOf("Mobile") == -1);
}
isc.Browser._origIsTablet = isc.Browser.isTablet;

//> @classMethod browser.setIsTablet() (A)
// Setter for +link{Browser.isTablet} to allow this global variable to be changed at runtime.
// This advanced method is provided to override SmartClient's detection of devices, since the
// framework can only detect devices that existed at the time the platform was released. Any
// changes to +link{Browser.isDesktop}, +link{Browser.isHandset}, or +link{Browser.isTablet}
// must be made before any component is created;
// <strong>it is an application error</strong> to attempt to change <code>isDesktop</code>,
// <code>isHandset</code>, or <code>isTablet</code> after components have been created.
// <p>
// Note that setting <code>Browser.isTablet</code> might affect the values of
// +link{Browser.isDesktop} and +link{Browser.isHandset}.
//
// @param isTablet (boolean) new setting for <code>Browser.isTablet</code>.
// @visibility external
//<
isc.Browser.setIsTablet = function (isTablet) {
    isTablet = isc.Browser.isTablet = !!isTablet;
    isc.Browser.isHandset = (isc.Browser.isTouch && !isc.Browser.isTablet);
    isc.Browser.isDesktop = (!isc.Browser.isTablet && !isc.Browser.isHandset);


};

//> @classAttr browser.isHandset (boolean : auto-detected based on device: RW)
// Is the application running on a handset-sized device, with a typical screen width of around
// 3-4 inches?
// <p>
// This typically implies that the application will be working with only 300-400 pixels.
//
// @setter setIsHandset()
// @visibility external
//<


isc.Browser.isHandset = (isc.Browser._mobileBrowsers && !isc.Browser.isTablet);

//> @classMethod browser.setIsHandset() (A)
// Setter for +link{Browser.isHandset} to allow this global variable to be changed at runtime.
// This advanced method is provided to override SmartClient's detection of devices, since the
// framework can only detect devices that existed at the time the platform was released. Any
// changes to +link{Browser.isDesktop}, +link{Browser.isHandset}, or +link{Browser.isTablet}
// must be made before any component is created;
// <strong>it is an application error</strong> to attempt to change <code>isDesktop</code>,
// <code>isHandset</code>, or <code>isTablet</code> after components have been created.
// <p>
// Note that setting <code>Browser.isHandset</code> might affect the values of
// +link{Browser.isDesktop} and +link{Browser.isTablet}.
//
// @param isHandset (boolean) new setting for <code>Browser.isHandset</code>.
// @visibility external
//<
isc.Browser.setIsHandset = function (isHandset) {
    isHandset = isc.Browser.isHandset = !!isHandset;
    isc.Browser.isTablet = (isc.Browser.isTouch && !isc.Browser.isHandset);
    isc.Browser.isDesktop = (!isc.Browser.isTablet && !isc.Browser.isHandset);


};

//> @classAttr browser.isDesktop (boolean : auto-detected based on device : RW)
// Is the application running in a desktop browser? This is true if +link{Browser.isTablet}
// and +link{Browser.isHandset} are both <code>false</code>.
//
// @setter setIsDesktop()
// @visibility external
//<

isc.Browser.isDesktop = (!isc.Browser.isTablet && !isc.Browser.isHandset);

//> @classMethod browser.setIsDesktop() (A)
// Setter for +link{Browser.isDesktop} to allow this global variable to be changed at runtime.
// This advanced method is provided to override SmartClient's detection of devices, since the
// framework can only detect devices that existed at the time the platform was released. Any
// changes to +link{Browser.isDesktop}, +link{Browser.isHandset}, or +link{Browser.isTablet}
// must be made before any component is created;
// <strong>it is an application error</strong> to attempt to change <code>isDesktop</code>,
// <code>isHandset</code>, or <code>isTablet</code> after components have been created.
// <p>
// Note that setting <code>Browser.isDesktop</code> might affect the values of
// +link{Browser.isHandset} and +link{Browser.isTablet}.
//
// @param isDesktop (boolean) new setting for <code>Browser.isDesktop</code>.
// @visibility external
//<
isc.Browser.setIsDesktop = function (isDesktop) {
    isDesktop = isc.Browser.isDesktop = !!isDesktop;
    if (isDesktop) {
        isc.Browser.isHandset = false;
        isc.Browser.isTablet = false;
    } else {
        isc.Browser.isTablet = isc.Browser._origIsTablet;
        isc.Browser.isHandset = !isc.Browser.isTablet;
    }


};

//> @classAttr  Browser.isBorderBox    (boolean : ? : R)
// Do divs render out with "border-box" sizing by default.
//<
// See comments in Canvas.adjustHandleSize() for a discussion of border-box vs content-box sizing

isc.Browser.isBorderBox = (isc.Browser.isIE && !isc.Browser.isStrict);

//>    @classAttr    Browser.lineFeed    (String : ? : RA)
//        Linefeed for this platform
//<

isc.Browser.lineFeed = (isc.Browser.isWin ? "\r\n" : "\n");

//>    @classAttr    Browser._supportsMethodTimeout    (String : ? : RA)
//        setTimeout() requires text string parameter in MacIE or IE 4
//<
isc.Browser._supportsMethodTimeout = false;//!(isc.Browser.isIE && (isc.Browser.isMac || isc.Browser.version == 4));

//>    @classAttr    Browser.isDOM (String : ? : RA)
//        Whether this is a DOM-compliant browser.  Indicates general compliance with DOM standards,
//      not perfect compliance.
//<
isc.Browser.isDOM = (isc.Browser.isMoz || isc.Browser.isOpera ||
                     isc.Browser.isSafari || (isc.Browser.isIE && isc.Browser.version >= 5));

//> @classAttr browser.isSupported (boolean : auto-detected based on browser : R)
// Whether SmartClient supports the current browser.
// <P>
// Note that this flag will only be available on browsers that at least support basic
// JavaScript.
//
// @visibility external
//<
isc.Browser.isSupported = (
    // we support all versions of IE 5.5 and greater on Windows only
    (isc.Browser.isIE && isc.Browser.minorVersion >= 5.5 && isc.Browser.isWin) ||
    // Mozilla and Netscape 6, all platforms
    isc.Browser.isMoz ||
    isc.Browser.isOpera ||
    isc.Browser.isSafari || // NB: really means "is Webkit", so includes Chrome, mobile Safari
    isc.Browser.isAIR
);


isc.Browser.nativeMouseMoveOnCanvasScroll =
    !isc.Browser.isTouch && (isc.Browser.isSafari || isc.Browser.isChrome);

//> @classAttr Browser.seleniumPresent (boolean : varies : R)
// Whether current page has been loaded by Selenium WebDriver.
//<
isc.Browser.seleniumPresent = (function () {
    var match = location.href.match(/[?&](?:sc_selenium)=([^&#]*)/);
    return match && match.length > 1 && "true" == match[1];
})();

//> @classAttr Browser.isKatalon (boolean : null : R)
// Whether the current page was loaded by a Katalon-driven browser.
//<

isc.Browser.isKatalon = navigator.webdriver && !!window.katalonWaiter;


if (window.isc_useLongDOMIDs == null) {
    if (isc.Browser.isKatalon

       )
    {
        window.isc_useLongDOMIDs = true;
    }
}
isc._longDOMIds = window.isc_useLongDOMIDs;


if (isc.Browser.isSafariStrict) {
    isc.Browser._writingModeCSS = {
        vertical_ltr: "vertical-rl;",
        vertical_rtl: "vertical-lr;",
        rotate_ltr: true,
        rotate_rtl: true,
        horizontal: "horizontal-tb;"
    };
} else if (isc.Browser.isEdge) {
    isc.Browser._writingModeCSS = {
        vertical_ltr: "tb-rl;",
        vertical_rtl: "tb;",
        rotate_ltr: true,
        rotate_rtl: true,
        horizontal: "unset;"
    };
} else {
    isc.Browser._writingModeCSS = {
        vertical_ltr: "tb-rl;",
        vertical_rtl: "tb;",
        rotate_ltr: true,
        rotate_rtl: true,
        horizontal: "lr;"
    };
}

//> @type Autotest
// @value isc.Browser.SHOWCASE autotest is targeting SmartClient or SGWT showcases
// @value isc.Browser.SELENESE autotest is targeting a single sample with Selenese
// @value isc.Browser.RUNNER autotest is targeting TestRunner-based JS tests
//<

//> @classAttr Browser.SHOWCASE (Constant : "showcase" : [R])
// A declared value of the enum type
// +link{type:Autotest,Autotest}.
// @constant
//<
isc.Browser.SHOWCASE = "showcase";

//> @classAttr Browser.SELENESE (Constant : "selenese" : [R])
// A declared value of the enum type
// +link{type:Autotest,Autotest}.
// @constant
//<
isc.Browser.SELENESE = "selenese";

//> @classAttr Browser.RUNNER (Constant : "runner" : [R])
// A declared value of the enum type
// +link{type:Autotest,Autotest}.
// @constant
//<
isc.Browser.RUNNER = "runner";

//> @classAttr Browser.autotest (Autotest : varies : R)
// The current mode of the autotest system (null if not in autotest mode)
//<
isc.Browser.autotest = (function () {
    var match = location.href.match(/[?&](?:autotest)=([^&#]*)/);
    return match && match.length > 1 ? match[1] : null;
})();

//>    @classAttr    Browser.allowsXSXHR    (boolean : ? : RA)
//    Traditionally, web browsers reject attempts to make an XmlHttpRequest of a server other than the origin
//  server. However, some more recent browsers allow cross-site XmlHttpRequests to be made, relying on the
//  server to accept or reject them depending on what the origin server is.
//<
isc.Browser.allowsXSXHR = (
    (isc.Browser.isFirefox && isc.Browser.firefoxMajorMinorNumber >= 3.5) ||
    // Chrome auto-updates to latest stable version every time you start it, and there is no option to prevent
    // this from happening, so there's no point in querying version
    (isc.Browser.isChrome) ||
    (isc.Browser.isSafari && isc.Browser.safariVersion >= 531)
);

//> @classAttr Browser.useCSSFilters (boolean : ? : R)
// Whether the current browser supports gradients and whether SmartClient is
// configured to use gradients (via the setting of window.isc_useGradientsPreIE9).
//<


var isc_useGradientsPreIE9 = window.isc_useGradientsPreIE9;
isc.Browser.useCSSFilters =
    !isc.Browser.isIE || isc.Browser.isIE9 || isc_useGradientsPreIE9 != false;

//> @classAttr Browser.isSGWT (boolean : ? : RA)
// Are we running in SGWT.
// This is set up by SmartGWT wrapper code in JsObject.init().
// Obviously only applies to internal SmartClient code since developer code for an SGWT app
// would be written in Java and there'd be no need to check this var!
// @visibility internal
//<

//> @classAttr browser.useCSS3 (boolean : see below : R)
// Whether the current browser supports CSS3 and whether SmartClient is configured to use
// CSS3 features (via the setting of window.isc_css3Mode).
// <P>
// If isc_css3Mode is "on" then useCSS3 is set to true.  If isc_css3Mode is set to
// "supported", "partialSupport", or is unset, then useCSS3 is set to true only if the browser
// is a WebKit-based browser, Firefox, IE 9 in standards mode, or IE 10+.  If isc_css3Mode is set
// to "off" then useCSS3 is set to false.
// @visibility external
//<
var isc_css3Mode = window.isc_css3Mode;
if (isc_css3Mode == "on") {
    isc.Browser.useCSS3 = true;
} else if (isc_css3Mode == "off") {
    isc.Browser.useCSS3 = false;
} else if (isc_css3Mode == "supported" ||
           isc_css3Mode == "partialSupport" ||
           (typeof isc_css3Mode) === "undefined")
{
    isc.Browser.useCSS3 = isc.Browser.isWebKit ||
                          isc.Browser.isFirefox ||
                          (isc.Browser.isIE && (isc.Browser.isIE9 || isc.Browser.version >= 10));
} else {
    isc.Browser.useCSS3 = false;
}

var isc_spriting = window.isc_spriting;
if (isc_spriting == "off") {
    isc.Browser.useSpriting = false;
} else {
    isc.Browser.useSpriting = (!isc.Browser.isIE || isc.Browser.version >= 7);
}

isc.Browser.useInsertAdjacentHTML = !!document.documentElement.insertAdjacentHTML;

//> @classAttr Browser.supportsFlatSkins (boolean : varies : IR)
// Whether browser is capable of rendering flat skins (e.g. Tahoe).
// @visibility sgwt
//<
isc.Browser.supportsFlatSkins = isc.Browser.useCSS3 && isc.Browser.useSpriting;

//> @classAttr Browser.defaultSkin (String : varies : IR)
// Preferred default skin if none is specified.
// @visibility sgwt
//<
isc.Browser.defaultSkin = isc.Browser.supportsFlatSkins ? "Shiva" : "Enterprise";

//> @classAttr Browser.defaultFontIncrease (int : varies : IR)
// Preferred font size increase if none is specified.
// @visibility sgwt
//<
isc.Browser.defaultFontIncrease = isc.Browser.seleniumPresent ? 0 :
        (isc.Browser.supportsFlatSkins ? 3 : 1);

//> @classAttr Browser.defaultSizeIncrease (int : varies : IR)
// Preferred control size increase if none is specified.
// @visibility sgwt
//<
isc.Browser.defaultSizeIncrease = isc.Browser.seleniumPresent ? 0 :
        (isc.Browser.supportsFlatSkins ? 10 : 2);


isc.Browser.useInsertAdjacentHTMLForSVG = (function () {
    if (!!document.createElementNS) {
        var svgGElem = document.createElementNS("http://www.w3.org/2000/svg", "g");
        if ((typeof svgGElem.insertAdjacentHTML) === "function") {
            try {
                svgGElem.insertAdjacentHTML("beforeend", "<rect/><ellipse/>");
                return (svgGElem.childNodes.length == 2 &&
                        svgGElem.childNodes[1].namespaceURI === "http://www.w3.org/2000/svg");
            } catch (e) {
                // ignored
            }
        }
    }
    return false;
})();

// Test for availability of the Range.getBoundingClientRect() method which was added to
// CSSOM View as of the 04 August 2009 Working Draft.
// http://www.w3.org/TR/2009/WD-cssom-view-20090804/

isc.Browser.hasNativeGetRect = (!isc.Browser.isIE &&
                                (!isc.Browser.isSafari || !isc.Browser.isMac || isc.Browser.version >= 6) &&
                                !!document.createRange &&
                                !!(document.createRange().getBoundingClientRect));


// isc.Browser.useClipDiv - if true we write out 2 handles for each widget
// the content div and the clip div. This is required to allow reliable measuring of content,
// sizing, etc. in some browsers


isc.Browser.useClipDiv = (isc.Browser.isMoz || isc.Browser.isSafari || isc.Browser.isOpera);

// _useNewSingleDivSizing: Use a single div rather than double-div structure for
// widgets with overflow settings where this is supportable.
// Only has an impact if useClipDiv is true.

isc.Browser._useNewSingleDivSizing = !((isc.Browser.isIE && isc.Browser.version < 10 && !isc.Browser.isIE9) ||
                                       (isc.Browser.isWebKit && !(parseFloat(isc.Browser.rawSafariVersion) >= 532.3)));


isc.Browser._useSingleDivForVisible = false;
isc.Browser._useSingleDivForVisibleStrict = false;


isc.Browser._autoSkipTitleClipper = false;


isc.Browser._useCentralizedCSS = false;


isc.Browser._useCachedStyleClasses = false;


isc.Browser.hasTextOverflowEllipsis = (!isc.Browser.isMoz || isc.Browser.version >= 7) &&
                                      (!isc.Browser.isOpera || isc.Browser.version >= 9);

// https://developer.mozilla.org/en-US/docs/CSS/text-overflow
isc.Browser._textOverflowPropertyName = (!isc.Browser.isOpera || isc.Browser.version >= 11 ? "text-overflow" : "-o-text-overflow");


isc.Browser._hasGetBCR = !isc.Browser.isSafari || isc.Browser.version >= 4;


isc.Browser._hasElementPointerEvents = ("pointerEvents" in document.documentElement.style &&
                                        !isc.Browser.isOpera &&
                                        (!isc.Browser.isIE || isc.Browser.version >= 11));

// Does the browser support HTML5 drag and drop?
// http://caniuse.com/#feat=dragndrop
// http://www.whatwg.org/specs/web-apps/current-work/multipage/dnd.html#dnd
//
// This is set to false in IE and Legacy Edge because cross-window drags are not possible.

//> @classAttr Browser.hasNativeDrag (boolean : varies : R)
// Does this browser support native HTML5 drag and drop? This is false on touch devices and
// on IE/Edge Legacy due to limitations in their native drag implementations.
// @visibility external
//<
isc.Browser.hasNativeDrag = !isc.Browser.isTouch && "draggable" in document.documentElement &&
        !(isc.Browser.isIE || isc.Browser.isEdge);

// http://dom.spec.whatwg.org/#ranges
isc.Browser._hasDOMRanges = !!(window.getSelection && document.createRange && window.Range);

// Whether the browser supports Range.createContextualFragment() generally.

isc.Browser._supportsCreateContextualFragment = isc.Browser._hasDOMRanges && !!document.createRange().createContextualFragment;

// Whether the browser supports Range.createContextualFragment() in SVG contexts.

isc.Browser._supportsSVGCreateContextualFragment = ((isc.Browser.isMoz && isc.Browser.version >= 36) ||
                                                    (isc.Browser.isChrome && isc.Browser.version >= 42));

// Whether the browser supports the CSS `background-size' property.
// https://developer.mozilla.org/en-US/docs/Web/CSS/background-size
isc.Browser._supportsBackgroundSize = "backgroundSize" in document.documentElement.style;

// Does the browser support CSS3 transitions?
// http://caniuse.com/#feat=css-transitions
// Note: No need to check for "msTransition" because IE10 was the first version of IE to have
// CSS3 transitions support and this is unprefixed.

isc.Browser._supportsCSSTransitions = (("transition" in document.documentElement.style ||
                                        "WebkitTransition" in document.documentElement.style ||
                                        "OTransition" in document.documentElement.style) &&
                                       (!isc.Browser.isMoz ||
                                        (!isc.Browser.isTouch && isc.Browser.version >= 34)));


isc.Browser._transitionEndEventType = ("WebkitTransition" in document.documentElement.style
                                       ? "webkitTransitionEnd"
                                       : ("OTransition" in document.documentElement.style
                                          ? (isc.Browser.isOpera && isc.Browser.version >= 12 ? "otransitionend" : "oTransitionEnd")
                                          : "transitionend"));

// Whether the browser supports native touch scrolling.
// This is a classMethod rather than a classAttr because it depends on isTouch, which is settable
// by the application any time up to creation of the first widget. See setIsTouch().
isc.Browser._getSupportsNativeTouchScrolling = function () {
    if (window.isc_useNativeTouchScrolling == false) return false;
    return this.isTouch && (!this.isMoz || !this.isWin) &&
        (!(this.isIPhone || this.isIPad) || this.iOSVersion >= 6);
};

isc.Browser._supportsWebkitOverflowScrolling = isc.Browser.iOSVersion >= 6 &&
                   ("webkitOverflowScrolling" in document.documentElement.style)
;

// Does the browser support CanvasRenderingContext2D.isPointInStroke()?
isc.Browser._supportsCanvasIsPointInStroke = (function () {
    var canvas = document.createElement("canvas");
    if (canvas.getContext != null) {
        var context = canvas.getContext("2d");
        return !!context.isPointInStroke;
    }
    return false;
})();


isc.Browser._supportsNativeNodeContains = ("contains" in document.documentElement);
// Node.contains() was introduced in Gecko 9.
if (!isc.Browser._supportsNativeNodeContains && window.Node != null) {
    Node.prototype.contains = function (otherNode) {
        for (; otherNode != null; otherNode = otherNode.parentNode) {
            if (this === otherNode) return true;
        }
        return false;
    };
}


isc.Browser._svgElementsHaveParentElement = (!!document.createElementNS && "parentElement" in document.createElementNS("http://www.w3.org/2000/svg", "svg"));
if (!isc.Browser._svgElementsHaveParentElement && window.SVGElement != null && Object.defineProperty) {
    Object.defineProperty(SVGElement.prototype, "parentElement", {
        enumerable: true,
        "get" : function () {
            var parentElement = this.parentNode;
            while (parentElement != null && parentElement.nodeType != 1) {
                parentElement = parentElement.parentNode;
            }
            return parentElement;
        }
    });
}

isc.Browser._svgElementsHaveContains = (!!document.createElementNS && "contains" in document.createElementNS("http://www.w3.org/2000/svg", "svg"));
if (!isc.Browser._svgElementsHaveContains && window.SVGElement != null) {
    SVGElement.prototype.contains = function (otherNode) {
        for (; otherNode != null; otherNode = otherNode.parentNode) {
            if (this === otherNode) return true;
        }
        return false;
    };
}

// Does the browser support the HTML5 'placeholder' attribute?

isc.Browser._supportsPlaceholderAttribute = ("placeholder" in document.createElement("input") &&
                                             "placeholder" in document.createElement("textarea"));

isc.Browser._supportsIOSTabs = isc.Browser.isMobileWebkit && "webkitMaskBoxImage" in document.documentElement.style;

// Does the browser support the Screen Orientation API?
// https://w3c.github.io/screen-orientation/
// http://caniuse.com/#feat=screen-orientation

isc.Browser._supportsScreenOrientationAPI = (window.screen != null && "orientation" in screen && "type" in screen.orientation);

// Does the browser support the SVGSVGElement.getIntersectionList() SVG 1.1 DOM method?

isc.Browser._supportsSVGGetIntersectionList = (!isc.Browser.isSafari &&
                                               !isc.Browser.isChrome &&
                                               !!document.createElementNS &&
                                               "getIntersectionList" in document.createElementNS("http://www.w3.org/2000/svg", "svg") &&
                                               "createSVGRect" in document.createElementNS("http://www.w3.org/2000/svg", "svg"));

isc.Browser._supportsJSONObject = (window.JSON != null &&
                                   typeof window.JSON.parse === "function" &&
                                   typeof window.JSON.stringify === "function" &&
                                   window.JSON.stringify("\u0013") === "\"\\u0013\"");

// whether the browser supports the Object.create() API.

isc.Browser._supportsObjectCreate = !!Object.create && (function () {
    var proto = {abc: "def"},
        obj = Object.create(proto);
    if (obj == null || typeof obj !== "object") return false;
    if (obj.abc !== "def") return false;
    return !Object.hasOwn(obj, "abc");
})();



//> @type RotationContentClippingMode
// How do we avoid handheld devices unexpectedly scaling the viewport larger during rotation?
//
// @value "clip" when viewport rotation is detected, temporarily reduce the width of any
//               top-level canvii to the expected width of the viewport after rotation
// @value "hide" when viewport rotation is detected, temporarily set the divs for all top-level
//               canvii to display:none
// @value "none" do nothing when viewport rotation is detected
//<

//> @classAttr Browser.rotationContentClippingMode (RotationContentClippingMode : "clip" : R)
// Approach for preventing unexpected scaling in handheld browser viewport during rotation.
// Defaulted to "clip" for Safari on iPad/iOS where problem was observed, otherwise to "none".
//<
if (!isc.Browser.isDesktop) {
    isc.Browser.rotationContentClippingMode = isc.Browser.isIPad &&
                                              isc.Browser.isSafariStrict ? "clip" : "none";
}

//> @classAttr Browser.useHighPerformanceGridTimings (boolean : see below : I)
// Controls how agressive components based on the +link{class:GridRenderer} are with respect to
// redraws and data fetches. Modern browsers can generally handle much more frequent redraws
// and most server configurations can handle fetching more data more frequently in order to
// reduce the lag the end user perceives when scrolling through databound grids.  Starting with
// SmartClient 11.0/SmartGWT 6.0, this more aggressive redraw and fetch behavior us the
// default, but can be reverted to the old behavior if desired - see below.
// <P>
// This flag controls the defaults for several other properties (value on left is default for
// high performance mode, value on right is default when this mode is disabled.
// <ul>
// <li> +link{attr:ListGrid.dataFetchDelay} 1 -> 300
// <li> +link{attr:ListGrid.drawAheadRatio} 2.0 -> 1.3
// <li> +link{attr:ListGrid.quickDrawAheadRatio} 2.0 -> 1.3
// <li> +link{attr:ListGrid.scrollRedrawDelay} 0 -> 75
// <li> +link{attr:ListGrid.scrollWheelRedrawDelay} 0 -> 250
// <li> +link{attr:ListGrid.touchScrollRedrawDelay} 0 -> 300
// </ul>
// Note: since +link{class:TreeGrid} is a subclass of +link{class:ListGrid}, the above settings
// also apply to +link{class:TreeGrid}s.
// <ul>
// <li> +link{attr:GridRenderer.drawAheadRatio} 2.0 -> 1.3
// <li> +link{attr:GridRenderer.quickDrawAheadRatio} 2.0 -> 1.3
// <li> +link{attr:GridRenderer.scrollRedrawDelay} 0 -> 75
// <li> +link{attr:GridRenderer.touchScrollRedrawDelay} 0 -> 300
// </ul>
// <P>
// By default, for all browsers except Android-based Chrome, this flag is set to true, but can
// be explicitly disabled by setting <code>isc_useHighPerformanceGridTimings=false</code> in a
// script block before loading SmartClient modules.  Turning off high performance timings
// effectively enables the original SmartClient/SmartGWT behavior prior to the SmartClient
// 11.0/SmartGWT 6.0 release.
//
// @visibility external
//<
isc.Browser.canUseAggressiveGridTimings = !isc.Browser.isAndroid;
isc.Browser.useHighPerformanceGridTimings = window.isc_useHighPerformanceGridTimings == null ?
    isc.Browser.canUseAggressiveGridTimings : window.isc_useHighPerformanceGridTimings && isc.Browser.canUseAggressiveGridTimings;


isc.Browser._usePointerCursorForHand =
        isc.Browser.isMoz || (isc.Browser.isSafari && isc.Browser.isStrict) ||
        (isc.Browser.isIE && isc.Browser.version >= 9 && isc.Browser.isStrict);

//> @classAttr Browser.isOpenFin (boolean : varies : R)
// Are we in an +externalLink{https://developers.openfin.co/of-docs/docs,OpenFin} environment?
// See class +link{OpenFin} for ways to call OpenFin methods from within SmartClient.
// @visibility external
//<

isc.Browser.isOpenFin = (function () {
    var application = window.fin && window.fin.Application;
    if (application) {
        var isOpenFin = application.isOpenFinEnvironment;
        if (isOpenFin && isOpenFin()) {
            return true;
        }
    }
    return false;
})();

//> @classAttr Browser.isMultiWindow (boolean : varies : RW)
// Are the +link{MultiWindow} APIs supported and cross-window optimizations enabled?  By
// default this is true in the +link{MultiWindow.isMainWindow,main window} if
// +link{isOpenFin,OpenFin} is loaded, false otherwise.  In
// +link{MultiWindow.open(),child windows}, this property is read-only, and assumes the
// value from the main window.
// <p>
// <b>Note:</b> +link{MultiWindow} is currently an experimental feature and not supported
// except by special arrangement
// @setter setIsMultiWindow()
// @visibility external
//<

//> @classMethod browser.setIsMultiWindow() (A)
// Sets a non-default value for +link{isMultiWindow}, such as enabling it even if
// +link{isOpenFin,OpenFin} isn't present.
// <p>
// Note that this method may only be called from the
// +link{MultiWindow.isMainWindow,main window}, and only once.
//
// @param isMultiWindow (boolean) new setting for <code>Browser.isMultiWindow</code>.
// @visibility external
//<
isc.Browser.setIsMultiWindow = function (isMultiWindow) {
    if (!isc.MultiWindow || isMultiWindow == this.isMultiWindow) return;

    var loggerName = "Browser.setIsMultiWindow(): ";


    if (!isc.MultiWindow.isMainWindow()) {
        isc.logWarn(loggerName + "can only be called from the main window");
        return;
    }

    var actionMethod = this.isMultiWindow ? "stop" : "init";
    if (isc.MultiWindow[actionMethod]() == false) {
        isc.logWarn(loggerName + "failed to " + actionMethod + " MultiWindow mode");
        return;
    }

    isc.logInfo(loggerName + "call to " + actionMethod + " MultiWindow mode succeeded");
    this.isMultiWindow = isMultiWindow;
}

//> @classAttr Browser._hasLocalStorage (boolean : varies : RA)
// One-time cached check for whether localStorage is accessible. In CSP sandbox environments
// without 'allow-same-origin', accessing window.localStorage throws a SecurityError.
// @visibility internal
//<

//> @classAttr Browser._hasSessionStorage (boolean : varies : RA)
// One-time cached check for whether sessionStorage is accessible. In CSP sandbox environments
// without 'allow-same-origin', accessing window.sessionStorage throws a SecurityError.
// @visibility internal
//<

//> @classMethod Browser.hasLocalStorage()
// Returns whether localStorage is accessible in the current environment. This method performs
// a one-time check and caches the result. In CSP sandbox environments without
// 'allow-same-origin', localStorage access throws a SecurityError.
// @return (boolean) true if localStorage is accessible, false otherwise
// @visibility external
//<
isc.Browser.hasLocalStorage = function () {
    if (this._hasLocalStorage == null) {
        try {
            var storage = window.localStorage;
            // Verify we can actually use it (some browsers allow access but throw on use)
            if (storage) {
                storage.getItem("_isc_test");
            }
            this._hasLocalStorage = (storage != null);
        } catch (e) {
            // SecurityError in CSP sandbox without allow-same-origin
            this._hasLocalStorage = false;
        }
    }
    return this._hasLocalStorage;
};

//> @classMethod Browser.hasSessionStorage()
// Returns whether sessionStorage is accessible in the current environment. This method
// performs a one-time check and caches the result. In CSP sandbox environments without
// 'allow-same-origin', sessionStorage access throws a SecurityError.
// @return (boolean) true if sessionStorage is accessible, false otherwise
// @visibility external
//<
isc.Browser.hasSessionStorage = function () {
    if (this._hasSessionStorage == null) {
        try {
            var storage = window.sessionStorage;
            // Verify we can actually use it (some browsers allow access but throw on use)
            if (storage) {
                storage.getItem("_isc_test");
            }
            this._hasSessionStorage = (storage != null);
        } catch (e) {
            // SecurityError in CSP sandbox without allow-same-origin
            this._hasSessionStorage = false;
        }
    }
    return this._hasSessionStorage;
};

//> @classAttr Browser.allowsNewFunction (boolean : varies : RA)
// Whether <code>new Function()</code> is allowed. This is true by default, but if the page
// has a CSP (Content Security Policy) header with a <code>script-src</code> directive that
// omits <code>'unsafe-eval'</code>, <code>new Function()</code> throws an EvalError.
// <P>
// CSP's <code>'unsafe-eval'</code> controls all string-to-code evaluation methods identically,
// so when this flag is false, <code>eval()</code>, <code>setTimeout(string)</code>, and
// <code>setInterval(string)</code> are also blocked.
// @visibility external
//<
isc.Browser.allowsNewFunction = true;
try {
    new Function("");
} catch (e) {
    isc.Browser.allowsNewFunction = false;
}

isc.Browser.supportsAsynchFunctions = true;
try {
    new Function('async () => {}')();
} catch (e) {
    isc.Browser.supportsAsynchFunctions = false;
}

//> @classAttr Browser.supportsSpeechRecognition (Boolean : null : RA)
// Whether this browser exposes a SpeechRecognition implementation (API is present).
// This indicates that browser-provided speech-to-text *may* be available for features
// such as +link{class:VoiceAssist}, but does not guarantee that recognition sessions can be
// started.  See +link{isc.Browser.allowsSpeechRecognition} for runtime viability.
// @visibility external
//<
//
// false indicates that the browser does not implement SpeechRecognition at all
// (for example, Firefox).
isc.Browser.supportsSpeechRecognition =
    (window.SpeechRecognition || window.webkitSpeechRecognition) != null;


//> @classAttr Browser.allowsSpeechRecognition (Boolean : null : RA)
// Whether this browser allows speech recognition sessions to be started using its
// SpeechRecognition implementation. Some browsers expose the API but prevent sessions
// from starting (for example, by blocking access to the vendor-operated speech-to-text
// service used by the implementation), typically surfacing as an immediate service or
// "network" error.
// <p>
// This flag is set on the first attempt to start speech recognition.
// @visibility external
//<
//
// false indicates that the browser blocks built-in speech-to-text services
// (for example, Brave).
isc.Browser.allowsSpeechRecognition = null;

//> @classAttr Browser.micAvailable (Boolean : null : RA)
// Whether at least one audio input device (microphone) is available to the browser.
// This reflects device presence only and does not imply that the site has
// +link{Browser.micPermission, permission} to access the microphone. In some browsers,
// microphone enumeration may be limited or partially obscured until permission is granted.
// @visibility external
//<
isc.Browser.micAvailable = null;

//> @classAttr Browser.micPermission (String : null : RA)
// The browser's current permission state for microphone access for the current site
// (origin). Possible values are "granted", "denied", or "prompt", consistent with the
// Permissions API.
// <p>
// "prompt" indicates that the user has not yet made a decision for this site and that
// the browser will request permission when microphone access is first attempted, typically
// in response to a user interaction.
// <p>
// Note that not all browsers support querying microphone permission state in advance;
// in such cases this value may remain null until an access attempt is made.
// @visibility external
//<
isc.Browser.micPermission = null;

// check for a microphone and permissions
(function () {
    function checkMicrophoneStatus () {
        // defensive API checks
        if (
            !navigator.mediaDevices ||
            typeof navigator.mediaDevices.enumerateDevices !== 'function' ||
            !navigator.permissions ||
            typeof navigator.permissions.query !== 'function'
        ) {
            return Promise.resolve({ exists: false, permission: null });
        }

        return navigator.mediaDevices.enumerateDevices()
            .then(function (devices) {
                const hasMic = devices.some(function (device) {
                    return device.kind === 'audioinput';
                });

                if (!hasMic) {
                    return { exists: false, permission: null };
                }

                // check permission status (no dialog)
                return navigator.permissions
                    .query({ name: 'microphone' })
                    .then(function (permission) {
                        return {
                            exists: true,
                            permission: permission.state
                        };
                    })
                    .catch(function () {
                        // permission API failed
                        return { exists: true, permission: null };
                    });
            })
            .catch(function () {
                // enumerateDevices failed
                return { exists: false, permission: null };
            });
    }

    checkMicrophoneStatus()
        .then(function (status) {
            isc.Browser.micAvailable = status.exists;
            isc.Browser.micPermission = status.permission;
        })
        .catch(function () {
            // Absolute final safety net
            isc.Browser.micAvailable = false;
            isc.Browser.micPermission = null;
        });
})();


//<ServerExclude

} // end `if (typeof isc.Browser != "object")`






isc.noOp = function isc_noOp() {};
isc.emptyObject = {};
isc._emptyArray = [];
// normal and obfuscatable name
isc.emptyString = isc._emptyString = "";
isc.space = " ";
isc.dot = ".";
isc.semi = ";";
isc.colon = ":";
isc.slash = "/";
isc.star = "*";
isc.apos = "'";
isc.percent = "%";
isc.auto = "auto";
isc.px = "px";
isc.nbsp = "&nbsp;";
isc.xnbsp = "&amp;nbsp;"; // XHTML
isc._false = "false";
isc._falseUC = "FALSE";
isc._underscore = "_";
isc._dollar = "$";
isc._obsPrefix = "_$observed_";
isc._superProtoPrefix = "_$SuperProto_";

isc.gwtRef = "__ref";
isc.gwtModule = "__module";

//> @staticMethod isc.logWarn()
// Same as +link{classMethod:Log.logWarn}.
//
// @param message      (String)  message to log
// @param [category]   (String)  category to log in, defaults to "Log"
//
// @visibility external
//<
isc.logWarn = function isc_logWarn(message, category) { isc.Log.logWarn(message, category); };

//> @staticMethod isc.logInfo()
// Same as +link{classMethod:Log.logInfo}.
//
// @param message      (String)  message to log
// @param [category]   (String)  category to log in, defaults to "Log"
//
// @visibility external
//<
isc.logInfo = function isc_logInfo(message, category) { isc.Log.logInfo(message, category); };

//> @staticMethod isc.echo()
// Same as +link{classMethod:Log.echo}.
//
// @param value    (Any)  object to echo
// @return (String) a short string representation of the object
//
// @visibility external
//<
isc.echo = function isc_echo(value, multiLine) { return isc.Log.echo(value, multiLine); };

//> @staticMethod isc.echoAll()
// Same as +link{classMethod:Log.echoAll}.
//
// @param value    (Any)  object to echo
// @return (String) a short string representation of the object
//
// @visibility external
//<
isc.echoAll = function isc_echoAll(value) { return isc.Log.echoAll(value); };

//> @staticMethod isc.echoLeaf()
// Same as +link{classMethod:Log.echoLeaf}.
//
// @param value    (Any)  object to echo
// @return (String) a short string representation of the object
//
// @visibility external
//<
isc.echoLeaf = function isc_echoLeaf(value) { return isc.Log.echoLeaf(value); };

isc.echoFull = function isc_echoFull(value) { return isc.Log.echoFull(value); };

//> @staticMethod isc.logEcho()
// Logs the echoed object (using +link{staticMethod:isc.echo}) as a warning, prefixed with an
// optional message.
//
//     @param value    (Any)  object to echo
//     @param message    (String)  message to log
//
// @see Log.logWarn() for logging info
// @visibility external
//<
isc.logEcho = function isc_logEcho(value, message) {
    if (message) message += ": ";
    isc.Log.logWarn((message || isc._emptyString) + isc.echo(value));
};

//> @staticMethod isc.logEchoAll()
// Logs the echoed object (using +link{staticMethod:isc.echoAll}) as a warning, prefixed with an
// optional message.
//
//     @param value    (Any)  object to echo
//     @param message    (String)  message to log
//
// @see Log.logWarn() for logging info
// @visibility external
//<
isc.logEchoAll = function isc_logEchoAll(value, message) {
    if (message) message += ": ";
    isc.Log.logWarn((message || isc._emptyString) + isc.echoAll(value));
};

// OutputAsString / StackWalking / Tracing
// ---------------------------------------------------------------------------------------








isc._makeFunction = function isc__makeFunction(args, script) {


    // CSP check: if new Function() is blocked, return a stub without attempting it
    if (!isc.Browser.allowsNewFunction) {
        var code = script || args;
        var errorCode = code.length > 100 ? code.substring(0, 100) + "..." : code;
        var returnVal = function() {
            throw new Error("CSP blocks dynamic function creation. Code: " + errorCode);
        };
        returnVal._cspBlocked = true;
        // _argString must be a string; args may be an array from fireCallback
        var argString = isc.isAn.Array(args) ? args.join(",") : args;
        returnVal._argString = argString || isc._emptyString;
        return returnVal;
    }

    var code = script || args;

    var returnVal;
    if (script == null) {
        returnVal = new Function(code);
        returnVal._argString = isc._emptyString;
    } else {
        returnVal = new Function(args, code);
        // _argString must be a string; args may be an array from fireCallback
        returnVal._argString = isc.isAn.Array(args) ? args.join(",") : args;
    }
    return returnVal;
};


isc.doEval = function isc_doEval(code) {
    // transform code and eval inline
    if (isc.Browser.isMoz) return isc._transformCode(code);
    //return isc._transformCode(code);

    if (!isc._evalSet) isc._evalSet = [];
    isc._evalSet[isc._evalSet.length] = code;
    return null;
};
// called at module end
isc.finalEval = function isc_finalEval() {
    //!OBFUSCATEOK
    if (isc._evalSet) {
        if (isc.Browser.isMoz) {
            for (var i = 0; i < isc._evalSet.length; i++) {
                isc.eval(isc._evalSet[i]);
            }
        }
        var code = isc._evalSet.join("");

        if (isc.Browser.isSafari) code = isc._transformCode(code);
        // uncomment to use catch/rethrow stacks in IE as well
        //else if (isc.Browser.isIE) code = isc._transformCode(code);

        if (isc.Browser.isIE) {
            if (window.execScript != null) {
                window.execScript(code, "javascript");
            } else {
                window.eval(code);
            }

        // Safari
        } else {
            isc.eval(code);
        }

        // Init pipelining: set a timeout to eval so that the module init time takes place
        // while the next module is being downloaded (except for the last module)
        // Can't be used for real until
        /*
        var evalFunc = function () {
        if (isc.Browser.isIE) {
            if (window.execScript != null) {
                window.execScript(code, "javascript");
            } else {
                window.eval(code);
            }

        // Safari
        } else {
            isc.eval(code);
        }
        };

        if (isc.module_DataBinding != 1) {
            //if (isc.Log) isc.Log.logWarn("delaying eval");
            setTimeout(evalFunc, 0)
        } else {
            evalFunc();
        }
        */
    }
    isc._evalSet = null;
};

//isc._eitherMarker = /\/\/\$[01]/;
isc._startMarker = "//$0";
isc._endMarker = "//$1";
isc._totalTransformTime = 0;
// code transform time, all modules
//    - Moz: about 140ms
//      - NOTE: overall init time rises by about 400ms, the balance is due to slower parsing
//        because of the added try/catch constructs.  This can be demonstrated by doing the
//        split/join, but just restoring the markers
//    - Safari: about 300ms
//    - IE: 266ms
// - NOTE: some key advantages of this approach as compared to server-side generation *aside
//   from* not hosing IE's ability to do full stack traces w/o try/catch:
//    - allows arbitrary start/end code to be added with only client-side changes
//    - can be conditional per load
//    - much smaller code size impact: could ship w/o local vars for production use

isc._addCallouts = true;
isc._transformCode = function isc__transformCode(code) {
    // set flag indicating stack walking is enabled so that we will also add try..catch to
    // generated functions
    isc._stackWalkEnabled = true;

    var start = isc.timeStamp ? isc.timeStamp() : new Date().getTime();

    var startCode = isc._tryBlock, endCode = isc._evalFromCatchBlock;
    if (isc._addCallouts) startCode = isc._methodEnter + startCode;

    var chunks = code.split(isc._eitherMarker),
        finalCode = [];

    var chunks = code.split(isc._startMarker);
    code = chunks.join(startCode);
    chunks = code.split(isc._endMarker);
    code = chunks.join(endCode);

    if (isc._addCallouts) {
        chunks = code.split("//$2");
        code = chunks.join(isc._methodExit);
    }

    /*
    // approach of single split and join to cut down on String churn.
    // Problem is that because of nested functions, markers do not alternate.  Would need to
    // detect which kind of marker is needed for a given slot, by eg checking the next char
    // over, which might be expensive enough to wipe out any advantage; untested.
    var pos = 0;
    for (var i = 0; i < chunks.length; i++) {
        finalCode[pos++] = chunks[i];
        if (i < chunks.length-1) {
            finalCode[pos++] = i % 2 == 0 ? isc._tryBlock : isc._evalFromCatchBlock;
        }
    }
    finalCode = finalCode.join("");

    try {
        window.isc.eval(finalCode);
    } catch (e) {
        //if (!this._alerted) alert(finalCode.substring(0,5000));
        //this._alerted = true;
        document.write("chunks<br><TEXTAREA style='width:760px;height:400px'>" +
                        chunks.join("\n***") + "</" + "TEXTAREA>");
        document.write("finalCode<br><TEXTAREA style='width:760px;height:400px'>" +
                        finalCode + "</" + "TEXTAREA>");
        throw e;
    }
    //return finalCode;
    */

    var end = isc.timeStamp ? isc.timeStamp() : new Date().getTime();
    isc._totalTransformTime += (end-start);
    return code;
};

isc._evalFromCatchBlock = "}catch(_e){isc.eval(isc._handleError(";
isc._handleError = function isc__handleError(varList) {
    var code = "var _ = {";
    if (varList != "") {
        var varNames = varList.split(",");
        for (var i = 0; i < varNames.length; i++) {
            var varName = varNames[i];
            code += varName + ":" + varName;
            if (i < varNames.length-1) code += ",";
        }
    }
    code += "};";
    code += "if(isc.Log)isc.Log._reportJSError(_e,arguments,this,_);throw _e;";
    return code;
};



// fillList - utility to concat a number of individual arguments into an array
// ---------------------------------------------------------------------------------------
isc.fillList = function isc_fillList(array, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X, Y, Z) {

    if (array == null) array = [];
    else array.length = 0;

    var undef;
    // avoid touching the arguments object if possible

    if (X === undef && Y === undef && Z === undef) {
        array[0] = A;
        array[1] = B;
        array[2] = C;
        array[3] = D;
        array[4] = E;
        array[5] = F;
        array[6] = G;
        array[7] = H;
        array[8] = I;
        array[9] = J;
        array[10] = K;
        array[11] = L;
        array[12] = M;
        array[13] = N;
        array[14] = O;
        array[15] = P;
        array[16] = Q;
        array[17] = R;
        array[18] = S;
        array[19] = T;
        array[20] = U;
        array[21] = V;
        array[22] = W;
    } else {
        for (var i = 1; i < arguments.length; i++) {
            array[i-1] = arguments[i];
        }
    }

    return array;
};



//>    @staticMethod isc.addProperties()
//
// Add all own properties and methods from any number of objects to a destination object,
// overwriting properties in the destination object.
// <p>
// Common uses of <code>addProperties</code> include creating a shallow copy of an object:<pre>
//
//     isc.addProperties({}, someObject);
//
// </pre>Combining settings in order of precedence:<pre>
//
//     isc.addProperties({}, defaults, overrides, skinOverrides);
//
// </pre>
// <P>
// <b>NOTES</b>:<ul>
// <li>Do not use <code>addProperties</code> to add defaults to an ISC class.
// Use +link{classMethod:Class.addProperties()}, as in:
// <i>MyClassName</i><code>.addProperties()</code>.
// <li>You may find it more convenient to use the instance method +link{class.addProperties()},
// as in: <i>myClassInstance</i><code>.addProperties()</code>, but there's no functional
// difference from using this method.
// </ul>
//
// @see classMethod:Class.addProperties()
// @see Class.addProperties()
//
//    @param    destination            (Object)    object to add properties to
//    @param    [arguments 1-N]    (Object)    objects to obtain properties from.  Properties of all
//                                            arguments other than destination are applied in turn.
// @return (Object) returns the destination object
// @visibility external
//<

/*
// code to count all methods according to what they are added to
isc.methodCount = 0;
isc.classMethodCount = 0;
isc.otherMethods = 0;
isc.otherMethodTargets = [];
*/

isc._sourceList = [];
isc._inAddProps = 0;

isc.addGlobal("addProperties", function isc_addProperties(destination, A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z) {

    // count recursive calls and avoid reusing the global isc._sourceList in this case.  Recursive calls
    // can happen if addPropertyList() logs something.
    var undef,
        sourceList = isc._inAddProps ? [] : isc._sourceList;
    isc._inAddProps++;

    if (X === undef && Y=== undef && Z === undef) {
        isc.fillList(sourceList, A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z);
    } else {
        sourceList.length = 0;
        for (var i = 1; i < arguments.length; i++) {
            sourceList[i -1] = arguments[i];
        }
    }


    var result = isc.addPropertyList(destination, sourceList);
    // reset the sourceList so we don't hang onto the objects in memory unnecessarily
    sourceList.length = 0;
    isc._inAddProps--;
    return result;
});


isc.addGlobal("addPropertiesWithAssign", Object.assign ? Object.assign : isc.addProperties);


isc._interfaceInstanceProps = {};
isc._interfaceClassProps = {};
isc._getInterfaceProps = function isc__getInterfaceProps(destination) {
    var className = destination.Class,
        props;
    if (isc.isA.ClassObject(destination)) {
        props = isc._interfaceClassProps[className] =
                    isc._interfaceClassProps[className] || [];
    } else if (isc.isAn.InstancePrototype(destination)) {
        props = isc._interfaceInstanceProps[className] =
                    isc._interfaceInstanceProps[className] || [];
    }
    return props;
};

//>    @method ClassFactory.addPropertyList() or isc.addPropertyList()
//
// Add all own properties of any number of objects to a destination object.
//
// This differs from addProperties() in that it takes an array as its second argument,
// applying each object in the array as properties in turn.
//
//    @param    destination            (Object)    object to add properties to
//    @param    sourceList            (Array)        array of objects whose own properties to add
//  @return                     (Object)    the object after the own properties have been added to <code>destination</code>
//<
isc.addPropertyList = function isc_addPropertyList(destination, sourceList, warnAboutEmptySharedInstanceArrays) {
    // Don't JS error if passed a null destination

    if (destination == null) {
        if (isc.Log) isc.Log.logWarn("Attempt to add properties to a null object. " +
                                     "Creating a new object for the list of properties."

                                     );
        destination = {};
    }


    if (isc.definingFramework) {

        var ifProps = destination._isInterface ?
            isc._getInterfaceProps(destination) : null;
        for (var i = 0, l = sourceList.length; i < l; i++) {
            var source = sourceList[i];
            if (source == null) continue;
            Object.assign(destination, source);
            for (var propName in source) {
                if (!Object.hasOwn(source, propName)) continue;
                if (ifProps != null) ifProps[ifProps.length] = propName;
                //>DEBUG
                if (typeof source[propName] === isc._$function
                    && isc._nameMethod)
                {
                    isc._nameMethod(source[propName], propName,
                                    destination);
                }
                //<DEBUG
            }
        }
        return destination;
    }

    var methods,
        // detect functions being added as properties.  Doesn't work until after "isA" has
        // initialized
        checkFunctions = (isc.isA != null),
        // don't probe certain objects in Legacy Dev Mode
        sgwtLegacyDevMode = isc.Browser.isSGWTLegacyDevMode,
        // get the registry of string methods on the destination object
        registry = (isc.isAn && isc.isAn.Instance && isc.isAn.Instance(destination) ?
                    destination.getClass()._stringMethodRegistry :
                    destination._stringMethodRegistry);
    if (registry == null) registry = isc.emptyObject;

    var props = destination._isInterface ? isc._getInterfaceProps(destination) : null;

    var undef;
    for (var i = 0, l = sourceList.length; i < l; i++) {
        // add its properties to the destination
        var source = sourceList[i];
        // if <code>source</code> is null, skip it.
        if (source == null) continue;

        // copy properties from source to destination
        for (var propName in source) {
            if (!Object.hasOwn(source, propName)) continue;
            var propValue = source[propName];


            if (sgwtLegacyDevMode) {
                if (propName == isc.gwtRef || propName == isc.gwtModule ||
                    window.SmartGWT.isNativeJavaObject(propValue))
                {
                    destination[propName] = propValue;
                    continue;
                }
            }

            // if any of source's properties are functions
            // or any of the source's properties are registered as stringMethods on the
            //          destination object
            // use addMethods to copy these properties



            var propIsAFunction = checkFunctions && isc.isA.Function(propValue);
            // Check for functions / stringMethods as appropriate.

            if (registry[propName] !== undef || propIsAFunction)
            {
                if (methods == null) methods = {};
                methods[propName] = propValue;

            // don't copy an identical property
            // NOTE: unsafe: a subclass may wish to set a property to the same value as the
            //       default for its superclass, and have the subclass value remain unchanged
            //       if the superclass default is changed.
            //} else if (!(source[property] === destination[property])) {
            } else {
                // property is not a function and this slot is not a StringMethod

                // for Interfaces, keep track of all properties added to them
                if (props != null) props[props.length] = propName;

                // check for clobbering a function with a non-function value, eg setting
                // Canvas.enable:false.
                var destinationProp = destination[propName];
                if (!propIsAFunction && destinationProp != null &&
                    isc.isA.Function(destinationProp) && !isc._allowDeleteFuncProperty)
                {

                    if (isc.Log != null && !isc._suppressNonFunctionMessage) {
                        isc.Log.logWarn("method " + propName + " on " + destination +
                                        " overridden with non-function: '" + propValue + "'");
                    }
                }

                if (propValue != null && propValue._isDynamicProperty && destination.addDynamicProperty) {
                    destination.addDynamicProperty(propName, propValue, true);
                } else {
                    destination[propName] = propValue;
                }

            /*
            } else {

                if (destination.Class && isc.Log &&
                    (!isc.isAn.Instance(destination) ||
                     destination._scPrototype === destination))
                {
                    isc.Log.logWarn("needless override on class: " + destination.Class +
                                    ": " + propName + "->" + propValue);
                }

            */
            }
        }
    }
    if (methods != null) isc.addMethods(destination, methods);
    return destination;
};

//>    @staticMethod isc.addMethods()
//
//    Add all own named methods from <code>source</code> to <code>destination</code>.
//
//    @see addProperties()
//
//    @param    destination    (Object)    object to add methods to
//    @param    source        (Object)    object to get methods from
//  @return             (Object)    the object after methods have been added to it
//
//<
// NOTE: not externally documented since there is essentially no legitimate reason for author
// code to use this instead of Class.addMethods().

isc._$string = "string";
isc._$function = "function";
isc._$constructor = "constructor";
isc._$object = "object";
isc.addGlobal("addMethods", function isc_addMethods(destination, source) {
    if (!destination || !source) return destination;

    // __remap is used by observe(); ensure it exists regardless of
    // which code path runs
    if (!isc.__remap) isc.__remap = {};

    // During framework init, prototypes have no observers and no string
    // method conversion is needed — skip per-property observer rename,
    // registry lookup, conditional assignment, and remap checks.
    //
    // Object.keys() vs for-in+hasOwn: Object.keys() allocates an array but
    // avoids the prototype chain traversal that for-in performs. For the
    // method objects used here (typically 5-30 properties, no inherited
    // enumerable props), Object.keys() is faster (~13ms savings measured).
    if (isc.definingFramework) {
        var props = destination._isInterface ?
                    isc._getInterfaceProps(destination) : null;
        var keys = Object.keys(source);
        for (var i = 0, l = keys.length; i < l; i++) {
            var name = keys[i];
            if (props != null) props[props.length] = name;
            var method = source[name];

            //>DEBUG
            if (method != null) {
                this._nameMethod(method, name, destination);
            } //<DEBUG
            destination[name] = method;
        }
        return destination;
    }



    var props = destination._isInterface ? isc._getInterfaceProps(destination) : null;

    for (var name in source) {
        if (!Object.hasOwn(source, name)) continue;

        if (props != null) props[props.length] = name;
        var method = source[name];

        // if a method was specified as a string or an action-object, see if the
        // destination defines this as a legal string method.
        // NOTE: check typeof object to support Actions, but check non-null because
        // typeof null == "object" and null specified for a method should wipe it out.
        if (isc.isA.instanceMethodsAdded && method != null &&
            (typeof method == isc._$string || typeof method == isc._$object))
        {
            var registry = (isc.isAn.Instance(destination) ?
                                (destination.getClass != null ?
                                    destination.getClass()._stringMethodRegistry : null) :
                            destination._stringMethodRegistry);
            var undef; // check for undefined rather than null
            if (registry && !(registry[name] === undef) &&

                name != isc._$constructor)
            {

                method = isc.Func.expressionToFunction(registry[name], source[name], null, name);
            }
            // XXX If it's not a function or a stringMethod, assume it's ok to add it using the
            // addMethods logic rather than booting back to addProperties
        }

        // If someone's observing this method, the actual method will be stored under a different
        // name
        var observers = destination._observers,
            finalName = (observers != null && observers[name] != null ? isc._obsPrefix + name : name);

        // If the method is already in the correct slot, we're done.

        if ((destination.hasOwnProperty && !destination.hasOwnProperty(finalName))
            || method !== destination[finalName] )
        {

            if (method != null) {
                //>DEBUG take the opportunity to label the function with a name for debug
                // purposes.
                this._nameMethod(method, name, destination); //<DEBUG




            }

            destination[finalName] = method;

            if (method != null) {



                // if the method was previously assigned an obfuscated name, make sure the function is
                // available under the obfuscated name in the object it's being mixed into
                if (isc.__remap[name]) {
                    // same check for observation applies here
                    var finalObfName = (destination._observers != null &&
                                        destination._observers[isc.__remap[name]] != null ?
                                        isc._obsPrefix + isc.__remap[name] : isc.__remap[name]);
                    destination[finalObfName] = method;
                }
            }
        //} else {
        //    alert("skipped identical assignment in slot: " + finalName + " of " + method);
        }
    }

    return destination;
});

// Function naming
// ---------------------------------------------------------------------------------------
//>DEBUG _nameMethod: labels a function with a name for debug purposes.



isc._allFuncs = [];
isc._allFuncs._maxIndex = 0;
isc._funcClasses = new Array(5000);

isc._nameMethod = function isc__nameMethod(method, name, destination) {

    if (typeof method != isc._$function) return;

    // if not being added to a class, just use the property name as the function name
    if (destination.Class == null) return method._name = name;

    // destination is either:
    // - a class Object (eg isc.ListGrid)
    // - an instancePrototype (isc.ListGrid._instancePrototype)
    // - an instance
    // - a handful of other objects on which we've added the Class property, including isc.isA,
    //   ClassFactory, and native prototypes (eg window.Array)


    // only for instance prototypes and class objects, not for instances
    if (isc.isA != null && isc.isA.instanceMethodsAdded &&
        (isc.isAn.InstancePrototype(destination) || isc.isA.ClassObject(destination)))
    {
        var allFuncs = isc._allFuncs;
        // NOTE: functions installed twice, eg interface methods, will appear twice with
        // different classnames, but the first entry will be the one used, so interface methods
        // retain the interface name even when added to other classes.
        allFuncs[allFuncs._maxIndex] = method;
        isc._funcClasses[allFuncs._maxIndex] = destination.Class;
        allFuncs._maxIndex++;
        return;
    }

    // debug: capture all non-Class/Instance methods (eg isA, String extensions, ClassFactory
    // and other bootstrap)
    //if (isc._otherFuncs == null) isc._otherFuncs = [];
    //isc._otherFuncs[isc._otherFuncs.length] = method;

    // special case isA because isA.Class is a method which detects class objects!
    // We need to use a property other than Class for the className.
    var className = (destination == isc.isA ? "isA" : destination.Class);

    method._className = className;


    if (isc[destination.Class] == null) method._name = name;

    if (isc.isA != null && isc.isA.instanceMethodsAdded && isc.isAn.Instance(destination) &&
        !isc.isAn.InstancePrototype(destination))
    {
        // instance methods need to be labelled with their name since we don't want to store a
        // list of instance IDs for function name lookups (it would grow indefinitely)
        method._name = name;
        // this method is an instance-specific override (using an instance as an anonymous
        // class).  Mark it as such.
        method._instanceSpecific = true;
        // if there's already a method on the destination with the same name,
        // this is also an override (as opposed to just a method that was added)
        if (destination[name] != null) method._isOverride = true;
    }
    // XXX Note: we could use a check like the following to detect and label class
    // methods vs instance methods
    // if (ClassFactroy.getClass(destination.Class) === destination) {
};

//<DEBUG










//> @type Object
// An ordinary JavaScript as obtained by "new Object()" or via
// +link{type:ObjectLiteral,Object Literal} syntax.
// <P>
// Methods that return Objects or take Objects as parameters make use of the ability of a
// JavaScript Object to contain an arbitrary set of named properties, without requiring
// declaration in advance.  This capability makes it possible to use a JavaScript Object much
// like a HashMap in Java or .NET, but without the need to call get() or set() to create and
// retrieve properties.
// <P>
// For example if you created an Object using +link{type:ObjectLiteral,Object Literal} syntax
// like so:
// <pre>
//    var request = {
//        actionURL : "/foo.do",
//        showPrompt:false
//    };
// </pre>
// You could then access it's properties like so:
// <pre>
//    var myActionURL = request.actionURL;
//    var myShowPrompt = request.showPrompt;
// </pre>
// .. and you could assign new values to those properties like so:
// <pre>
//    request.actionURL = "<i>newActionURL</i>";
//    request.showPrompt = <i>newShowPromptSetting</i>;
// </pre>
// Note that while JavaScript allows you to get and set properties in this way on any Object,
// SmartClient components require that if a setter or getter exists, it must be called, or no
// action will occur.  For example, if you had a +link{ListGrid} and you wanted to change the
// +link{listGrid.showHeader,showHeader} property:
// <pre>
//     myListGrid.setShowHeader(false); // correct
//     myListGrid.showHeader = false; // incorrect (nothing happens)
// </pre>
// All documented attributes have +link{group:flags,flags} (eg IRW) that indicate when direct
// property access is allowed or not.
//
// @visibility external
//<


// Utility methods for any JavaScript Object
// ---------------------------------------------------------------------------------------

//>    @staticMethod isc.getKeys()
//
//    Return all keys (property names) of a given object
//
//    @param    object            (Object)    object to get properties from
//    @return                    (Array) String names of all properties.  NOTE: never null
// @visibility external
//<
isc.addGlobal("getKeys", function isc_getKeys(object) {
    var list = [];
    if (object != null) {
        for (var key in object) {
            list[list.length] = key;
        }
    }
    return list;
});

//> @staticMethod isc.firstKey()
// Return the first property name in a given Object, according to for..in iteration order.
//
// @param object (Object) Object to get properties from
// @return (String) first property name, or null if Object has no properties
// @visibility external
//<
isc.addGlobal("firstKey", function isc_firstKey(object) {
    for (var key in object) return key;
});

//>    @staticMethod isc.getValues()
//
//    Return all values of a given object
//
//    @param    object            (Object) object to get properties from
//    @return                    (Array) values of all properties.  NOTE: never null
// @visibility external
//<
isc.addGlobal("getValues", function isc_getValues(object) {
    var list = [];
    if (object != null) {
        for (var key in object) {
            list[list.length] = object[key];
        }
    }
    return list;
});

//> @staticMethod isc.sortObject()
// Given a simple javascript object, return that object sorted by keys, such that when iterating
// through the properties of the object, they will show up in sorted order.<br>
// Usage example - may be used to sort a +link{FormItem.valueMap, formItem valueMap} defined
// as an object.
// @param object (Object) Object to sort
// @param [comparator] (Function) Comparator function to use when sorting the objects keys
// @return (Object) sorted version of the object passed in.
// @visibility external
//<
isc.addGlobal("sortObject", function isc_sortObject(object, sortComparator) {
    if (!isc.isA.Object(object)) return object;
    if (isc.isAn.Array(object)) {
        if (sortComparator != null) return object.sort(sortComparator);
        return object.sort();
    }
    var keys = isc.getKeys(object);
    keys = (sortComparator == null ? keys.sort() : keys.sort(sortComparator));
    var sortedObject = {};
    for (var i = 0; i < keys.length; i++) {
        sortedObject[keys[i]] = object[keys[i]];

    }
    return sortedObject;
});

//> @staticMethod isc.sortObjectByProperties()
// Given a simple javascript object, return that object sorted by properties, such that when
// iterating through the properties of the object, values will show up in sorted order.<br>
// Usage example - may be used to sort a +link{FormItem.valueMap, formItem valueMap} defined
// as an object by display value.
// @param object (Object) Object to sort
// @param [comparator] (Function) Comparator function to use when sorting the object properties
// @return (Object) sorted version of the object passed in.
// @visibility external
//<
isc.addGlobal("sortObjectByProperties", function isc_sortObjectByProperties(object, sortComparator) {
    if (!isc.isA.Object(object)) return object;
    if (isc.isAn.Array(object)) {
        if (sortComparator != null) return object.sort(sortComparator);
        return object.sort();
    }
    var values = isc.getValues(object);
    values = (sortComparator == null ? values.sort() : values.sort(sortComparator));
    var sortedObject = {};

    for (var i = 0; i < values.length; i++) {
        var value = values[i];
        for (var key in object) {
            if (object[key] === value) {
                sortedObject[key] = object[key];
                continue;
            }
        }
    }
    return sortedObject;
});

//> @staticMethod isc.addDefaults()
//
// Copy any properties that do not already have a value in destination.  Null and zero values
// are not overwritten, but 'undef' values will be.
//
// @param destination (Object) Object to which properties will be added.
// @param source (Object) Object from which properties will be added.
// @return (Object) The destination object is returned.
// @visibility external
//<
isc.addGlobal("addDefaults", function isc_addDefaults(destination, source) {
    if (destination == null) return;
    var undef;
    for (var propName in source) {
        if (destination[propName] === undef) destination[propName] = source[propName];
    }
    return destination;
});


//> @staticMethod isc.addDefaultsRecursively()
//
// Copy any properties that do not already have a value in destination.  Null and zero values
// are not overwritten, but 'undef' values will be.  This function operates recursively,
// applying defaults in a "deep" fashion (ie, we recurse into sub-objects and apply defaults
// at the lowest level, rather than applying the original sub-objects to the target object)
//
// @param destination (Object) Object to which properties will be added.
// @param source (Object) Object from which properties will be added.
// @return (Object) The destination object is returned.
// @visibility internal for now
//<
isc.addGlobal("addDefaultsRecursively", function isc_addDefaultsRecursively(destination, source, dupList) {
    if (destination == null) return destination;
    if (source == null || isc.isAn.emptyObject(source)) return destination;

    var undef;

    if (isc.isAn.Array(source)) {
        if (!isc.isAn.Array(destination)) {
            isc.logWarn("Error during addDefaultsRecursively: source is an array but destination " +
                        "is not.  Cannot continue");
            return;
        }
        for (var i = 0; i < source.length; i++) {
            var entry = source[i];
            if (isc.isA.Function(entry)) continue;
            if (isc.isAn.Instance(entry) || isc.isA.Class(entry)) continue;

            if (entry == null || isc.isA.String(entry) || isc.isA.Boolean(entry) ||
                isc.isA.Number(entry))
            {
                if (destination[i] === undef) destination[i] = entry;
            } else if (isc.isA.Date(entry)) {
                if (destination[i] === undef) destination[i] = new Date(entry.getTime());
            } else if (isc.isAn.Object(entry)) {
                if (destination[i] === undef) destination[i] = {};
                if (!isc.isAn.Object(destination[i])) {
                    isc.logWarn("Error during addDefaultsRecursively: entry number " + i +
                                " in the source array is an object, but the existing entry " +
                                i + " in the destination is not an object.  Skipping");
                    continue;
                }
                destination[i] = isc.addDefaultsRecursively(destination[i], entry, dupList);
            }
        }
        return destination;
    }

    var propertiesToSkip = {
        __ref: true,
        __module: true
    };

    if (!dupList) dupList = [];
    if (dupList.contains(source)) {
        destination = source;
        return destination;
    }
    dupList.add(source);

    for (var prop in source) {
        if (isc.isA.Function(source[prop])) continue;
        if (propertiesToSkip[prop] == true) continue;
        if (isc.isAn.Instance(source[prop]) || isc.isA.Class(source[prop])) continue;

        var propValue = source[prop];
        if (isc.isA.Date(propValue)) {
            if (destination[prop] === undef) {
                destination[prop] = propValue.duplicate();
            }
        } else if (isc.isAn.Array(propValue)) {
            if (destination[prop] === undef) destination[prop] = [];
            if (!isc.isAn.Array(destination[prop])) {
                isc.logWarn("Error during addDefaultsRecursively: source property '" +
                            prop + "' is an array, but the target object has an existing " +
                            "property of the same name that is not an array.  Skipping");
                continue;
            }
            if (dupList.contains(propValue)) {
                destination[prop] = propValue;
                continue;
            }
            dupList.add(propValue);
            isc.addDefaultsRecursively(destination[prop], propValue, dupList);
        } else if (isc.isAn.Object(propValue)) {
            if (dupList.contains(propValue)) {
                destination[prop] = propValue;
                continue;
            }
            if (destination[prop] === undef) destination[prop] = {};
            if (!isc.isAn.Object(destination[prop])) {
                isc.logWarn("Error during addDefaultsRecursively: source property '" +
                            prop + "' is a sub-object, but the target object has an existing " +
                            "property of the same name that is not an object.  Skipping");
                continue;
            }
            isc.addDefaultsRecursively(destination[prop], propValue, dupList);
        } else {
            if (destination[prop] === undef) destination[prop] = source[prop];
        }

    }
    return destination;
});


//>    @staticMethod isc.propertyDefined()
//
//    Is some property specified on the object passed in?  This will return true if
//  <code>object[propertyName]</code> has ever been set to any value, and not deleted.<br>
//  May return true even if <code>object[propertyName] === undefined</code> if the property
//  is present on the object and has been explicitly set to undefined.
//
// @param object (Object) Object to test
// @param propertyName (String) Which property is being tested for?
// @return (boolean) true if property is defined
//  @visibility external
//<
isc.addGlobal("propertyDefined", function isc_propertyDefined(object, propertyName) {
    if (object == null) return false;

    var undef;
    if (object[propertyName] !== undef) return true;


    var properties = isc.getKeys(object);
    return (properties.contains(propertyName));
});

isc.addGlobal("objectsAreEqual", function isc_objectsAreEqual(object1, object2) {
    // match -> return true

    if (object1 === object2) return true;

    else if (isc.isAn.Object(object1) && isc.isAn.Object(object2)) {
        if (isc.isA.Date(object1)) {
            return isc.isA.Date(object2) && (isc.DateUtil.compareDates(object1,object2) == 0);
        } else if (isc.isAn.Array(object1)) {
            if (isc.isAn.Array(object2) && object1.length == object2.length) {
                for (var i = 0; i < object1.length; i++) {
                    if (!isc.objectsAreEqual(object1[i], object2[i])) return false;
                }
                return true;
            }
            return false;
        } else {
            if (isc.isAn.Array(object2)) return false;
            var numProps = 0;
            for (var prop in object1) {
                if (prop == isc.gwtRef || prop == isc.gwtModule) continue;
                if (!isc.objectsAreEqual(object1[prop],object2[prop])) return false;
                numProps ++;
            }
            var numProps2 = 0;
            for (var prop2 in object2) {
                if (prop == isc.gwtRef || prop == isc.gwtModule) continue;
                numProps2++;
                if (numProps2 > numProps) return false;
            }
            if (numProps2 != numProps) return false;

            return true;
        }
    } else {
        return false;
    }
});


// combineObject() - like addProperties() except it handles nested object data structures
// so if an attribute of the source is an object, properties from that object will be
// combined across to the destination, rather than simply clobbering the previous attribute value
// for the field.
// Note the goal here isn't to avoid the destination pointing to the same objects as the source
// (like a duplicate), it's just to merge field values in for nested objects
isc.addGlobal("combineObjects", function isc_combineObjects(destination, source) {
    if (destination == null || !isc.isAn.Object(destination)) return source;
    if (source == null || !isc.isAn.Object(source)) return destination;

    for (var prop in source) {
        var destProp = destination[prop],
            sourceProp = source[prop];
        // If both the source and destination contain simple objects, iterate through the
        // attributes on the source property object and copy them across to the destination property
        // object
        if (isc.isAn.Object(destProp) && !isc.isAn.Array(destProp) && !isc.isA.Date(destProp)
            && isc.isAn.Object(sourceProp) && !isc.isAn.Array(sourceProp) &&
            !isc.isA.Date(sourceProp))
        {
            isc.combineObjects(destProp, sourceProp);
        // Otherwise we can just copy the value across as with standard addProperties
        } else {
            destination[prop] = sourceProp;
        }

    }
    return destination;
});


//> @staticMethod isc.applyMask()
// Create a copy of an Object or Array of Objects that has been trimmed to a specified set of
// properties.
// <p>
// <code>mask</code> is the list of properties to return.  Can be an array of strings or an object.
// If an object, the properties returned will be those that are present in the object.  NOTE: this
// includes properties that exist because they've been explicitly set to null.
// <p>
// If no mask is specified, returns a duplicate of the input
// If no inputs are specified, returns an empty object.
//
// @param input   (Object | Array)   object to be masked
// @param mask    (Object | Array)   set of properties to limit output to
//
//<
// NOTE: not external because behavior is a little odd:
// - returns non-null for null input
// - if mask is null and provided an Array, returns an Object instead of a dup'd Array
// we need to check out the framework uses of applyMask and makes sure changing the behavior is
// OK
//
// XXX if applyMask with the input as an empty Array, you will get an empty Array as output.
// So applyMask cannot be used to filter properties that exist on an Array instance.
isc.applyMask = function isc_applyMask(input, mask) {
    var output = {};

    // if no input passed in, return empty output
    if (input == null) return output;

    // if no mask passed in, return all fields from input
    if (mask == null) {
        return isc.addProperties(output, input);
    }

    var inputWasSingle = false;
    if (!isc.isAn.Array(input)) {
        inputWasSingle = true;
        input = [input];
    }

    // convert the mask to an Array of property names if it's an object
    if (!isc.isAn.Array(mask)) mask = isc.getKeys(mask);

    var output = [],
        inputObj, outputObj,
        key, undef;
    for (var i = 0; i < input.length; i++) {
        inputObj = input[i];
        outputObj = output[i] = {};
        // return only the specified properties
        for (var j = 0; j < mask.length; j++) {
            key = mask[j];
            if (inputObj[key] === undef) continue;
            outputObj[key] = inputObj[key];
        }
    }
    return (inputWasSingle ? output[0] : output);
};

isc.getProperties = function isc_getProperties(input, propertyList, output) {
    if (input == null) return null;

    output = output || {};
    if (propertyList == null) return output;
    for (var i = 0; i < propertyList.length; i++) {
        var propName = propertyList[i];
        output[propName] = input[propName];
    }
    return output;
};

isc._digits = {};
isc._floor = Math.floor;
isc._$minus = "-";

for (isc._iterator = 0; isc._iterator < 10; isc._iterator++)
    isc._digits[isc._iterator] = isc._iterator.toString();

isc._fillNumber = function isc__fillNumber(template, number, startSlot, numSlots, nullRemainingSlots) {



    var lastSlot = startSlot + numSlots - 1,
        origNumber = number,
        didntFit = false,
        negative;

    if (number < 0) {
        negative = true;
        number = -number;
        template[startSlot] = this._$minus;
        startSlot += 1;
        numSlots -= 1;
    }

    while (number > 9) {
        // reduce by 10x, round off last digit and subtract to find what it was
        var newNumber = this._floor(number/10),
            lastDigit = number - (newNumber*10);
        // fill slots last first
        template[lastSlot] = this._digits[lastDigit];
        number = newNumber;

        if (lastSlot == (startSlot+1) && number > 9) {
            // number to large for allocated number of slots
            isc.Log.logWarn("fillNumber: number too large: " + origNumber +
                            isc.Log.getStackTrace());
            didntFit = true;
            break;
        }
        lastSlot -= 1;
    }

    if (didntFit) {

        lastSlot = startSlot + numSlots - 1;
        template[lastSlot--] = (!negative ? origNumber : -origNumber);
    } else {
        template[lastSlot--] = this._digits[number];
    }

    // null out remaining slots
    for (var i = lastSlot; i >= startSlot; i--) {
        template[i] = null;
    }
};
if (!isc.Browser.isIE || isc.Browser.version > 7) {

    isc._fillNumber = function isc__fillNumber(template, number, startSlot, numSlots, nullRemainingSlots) {
        template[startSlot] = number;
        if (nullRemainingSlots) {
            var endI = startSlot + numSlots;
            for (var i = startSlot + 1; i < endI; ++i) {
                template[i] = null;
            }
        }
    };
}

//> @object Boolean
// Boolean object.  Attributes, parameters, or return values declared as <code>Boolean</code>
// may be null.  Contrast with +link{type:boolean}.
// @treeLocation Client Reference/System
// @visibility external
//<


//> @type boolean
// A Boolean which is either true or false.  May not be null.
// @baseType Boolean
// @treeLocation Client Reference/System
// @visibility external
//<

// try to interpolate different types as a boolean
//
// returns default if value is undefined or null
// returns false if value is
//   - the string "false" or "FALSE"
//   - the number 0
//   - the boolean value false
// otherwise returns true
isc.booleanValue = function isc_booleanValue(value, def) {
    // if the value is unset, return the specified default (so,
    if (value == null) return def;

    if (isc.isA.String(value)) return value != isc._false && value != isc._falseUC;
    return value ? true : false;
};

// isc.objectToLocaleString()
// Centralized, customizable toLocaleString() formatter for objects.
isc.iscToLocaleString = function isc_iscToLocaleString(object) {
    if (object != null) {
        return object.iscToLocaleString ? object.iscToLocaleString() :
                    (object.toLocaleString ? object.toLocaleString() :
                        (object.toString ? object.toString() : isc.emptyString + object));
    }
    return isc.emptyString + object;
};

isc.documentCurrentScriptCapable = document.currentScript != null;
isc.getCurrentScriptSrc = function () {
    if (document.currentScript != null) {
        return document.currentScript.src;
    } else if (isc.documentCurrentScriptCapable) {
        // without this check, a call to this API after script execution (e.g. via eval()) would
        // be indistinguishable from an older browser and would fall through to the logic below
        // which would inevitably return something like "anonymous", but generally, on modern
        // browsers, we would like to be able to distinguish this case (from a possible eval
        // stack mis-detection value)
        return null;
    } else {
        var error = new Error(),
            stack = error.stack
        ;

        if (stack == null) try {
            throw error;
        } catch (error) {
            stack = error.stack;
        }

        if (stack != null) {


            var atText = stack.indexOf(" at ") >= 0 ? " at " : "@";
            var lastAtPos = stack.lastIndexOf(atText);
            if (lastAtPos >= 0) {
                var src = stack.substring(lastAtPos + atText.length);

                // remove outermost parentheses (required for IE10+)
                src = src.replace(/^[^(]*\((.*)\)[^)]*$/, "$1");

                // Remove the trailing lineno/colno.
                var re = new RegExp(":\\d+\\s*$");
                var result = re.exec(src);
                if (result) {
                    src = src.substring(0, result.index);
                    result = re.exec(src);
                    if (result) {
                        src = src.substring(0, result.index);
                    }
                }

                return src;
            }

        // IE9 and below will enter this section

        } else if (document.documentMode >= 8) {
            var oldOnerrorHandler = window.onerror;
            window.onerror = function (message, url, lineno) {
                return url;
                // window.onerror = oldOnerrorHandler;
                // return true;
            };

            window.noSuchMethod();
        } else {
            var scriptElems = document.getElementsByTagName("script");
            var lastScriptElem = scriptElems[scriptElems.length - 1];
            return lastScriptElem.src;
        }
    }
};









//>    @object    isA
//
//    A library of functions for determining the types of other objects.<br><br>
//
//  The "isA" methods for the basic JavaScript types are much faster and more consistent across
//  platforms than JavaScript's "typeof" operator.<br><br>
//
//  An isA method is automatically created for every ISC Class and Interface definition, for
//  example, isA.Canvas().<br><br>
//
//    @example    <code>if (isA.Number(myVariable)) ...</code>
//
//    Note: <code>is</code> and <code>isAn</code> are synonyms of <code>isA</code> and can be used
//            interchangably when it looks better syntactically, eg:
//                <code>if (myObject == null) ...</code>
//            or
//                <code>if (isAn.Array(myObject)) ...</code>
// <P>
// <h4>Global Configuration Flags</h4>
// <P>
// <b><code>window.isc_crossFrameCompat</code></b>
// <P>
// By default, the isA functions use fast <code>typeof</code> checks that work correctly for
// primitive values passed between frames. However, <i>boxed primitives</i> created in another
// frame are not detected:
// <pre>
//    // Boxed primitive created in an iframe
//    var iframe = document.createElement("iframe");
//    document.body.appendChild(iframe);
//    var boxedString = new iframe.contentWindow.String("hello");
//
//    typeof boxedString;           // "object" - not "string"!
//    boxedString instanceof String; // false - different constructor
//    isc.isA.String(boxedString);   // false - cannot detect by default
// </pre>
// This edge case is extremely rare because boxed primitives are almost never used in practice.
// Normal usage such as string literals (<code>"hello"</code>), concatenation
// (<code>"a" + "b"</code>), or any standard string/number/boolean operations produce primitive
// values, not boxed objects. Only explicit constructor calls like <code>new String()</code>,
// <code>new Number()</code>, or <code>new Boolean()</code> produce boxed primitives - and these
// are widely considered a JavaScript antipattern. Primitive values passed cross-frame work
// correctly with the default isA functions.
// <P>
// For applications that need cross-frame boxed primitive detection, set
// <code>window.isc_crossFrameCompat = true</code> before loading SmartClient. This installs
// slower versions that use <code>Object.prototype.toString.call()</code>. These versions are
// also always available as <code>isc.isA.crossFrame.String()</code>,
// <code>isc.isA.crossFrame.Number()</code>, and <code>isc.isA.crossFrame.Boolean()</code>.
// <P>
// <b><code>window.isc_legacyGWT</code></b>
// <P>
// GWT versions prior to 2.5 (released 2012) had a bug where Java String objects passed to
// JavaScript would have a <code>.Class</code> property set to "String" but would not be
// detected as strings by <code>typeof</code>. Set <code>window.isc_legacyGWT = true</code>
// before loading SmartClient if using GWT versions older than 2.5.
//
// @treeLocation Client Reference/System
// @visibility external
//<
// create the "isA", "isAn" and "is" objects
isc.addGlobal("isA", {});
isc.addGlobal("isAn", isc.isA);
isc.addGlobal("is", isc.isA);

  //>DEBUG
// give it a class name so that methods added to it get labelled
isc.isA.Class = "isA";
  //<DEBUG

isc.isA.isc = isc.isA; // so you can do isc.isA.isc.Canvas(object)


Function.__nativeType = 1;
Array.__nativeType = 2;
Date.__nativeType = 3;
String.__nativeType = 4;
Number.__nativeType = 5;
Boolean.__nativeType = 6;
RegExp.__nativeType = 7;
Object.__nativeType = 8;



Function.prototype.__nativeType = 1;




// See isA class docs for flag documentation
isc._legacyGWTWorkaround = window.isc_legacyGWT;
isc._crossFrameCompat = window.isc_crossFrameCompat;

// add methods to determine the type of various simple objects
isc.addMethods(isc.isA, {

    //> @staticMethod isA.emptyString()
    //
    //    Is <code>object</code> the empty string?<br><br>
    //
    //    NOTE: if you prefer, you can call this as <code>isAn.emptyString()</code>
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a null string
    //    @visibility external
    //<
    emptyString : function (object) {return isc.isA.String(object) && object == isc.emptyString},


    //> @staticMethod isA.nonemptyString()
    //
    //    Is <code>object</code> a non-empty String?<br><br>
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a non-empty string
    //    @visibility external
    //<
    nonemptyString : function (object) {return isc.isA.String(object) && object != isc.emptyString},


    //> @staticMethod isA.Object()
    // Returns whether the passed value is a non-<code>null</code> Object.
    // <p>
    // Returns <code>false</code> for values that are numbers, strings, booleans, functions or
    // are <code>null</code> or <code>undefined</code>.  (Note: Returns <code>true</code> for
    // the wrapper types, e.g. <code>new String("some string")</code>.)
    // <p>
    // Returns true for Object, Array, Regular Expression, Date and other kinds of
    // native objects which are considered to extend from window.Object.
    //
    // @param object (Any) value to test for whether it's an object
    // @return (boolean) whether passed value is an Object
    // @visibility external
    //<
    //  With the exception of returning false for the null value, this function's return value
    //  matches the ECMA spec for the typeof operator.  It also seems to be a reasonable expected
    //  implementation of this method as it guarantees the programmer can work with properties of
    //  the object as with a standard Object returned by "new Object()".
    _$object:"object",
    _$String :"String",
    Object : function (object) {
        if (object == null) return false;

        // GWT workaround for Issue 4301, fixed in GWT 2.5. Only applied if isc_legacyGWT is set.
        if (isc._legacyGWTWorkaround &&
            object.Class != null && object.Class == this._$String)
        {
            return false;
        }

        // typeof reliably returns "object" for all objects (including RegExp, Date, Array)
        // and "function" for functions in all modern browsers
        return typeof object == "object";
    },

    //> @staticMethod isA.emptyObject()
    //
    // Is <code>object</code> an object with no properties (i.e.: <code>{}</code>)?
    // <P>
    // Note that an object that has properties with null values is considered non-empty, eg
    // <code>{ propName:null }</code> is non-empty.
    // <P>
    // NOTE: if you prefer, you can call this as <code>isAn.emptyObject()</code>
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is the empty object
    //    @visibility external
    //<
    emptyObject : function (object) {
        if (!isc.isAn.Object(object)) return false;
        for (var i in object) {
            // if we have a single property we're non-empty!
            return false;
        }
        return true;
    },

    //> @staticMethod isA.emptyArray()
    //
    // Is <code>object</code> an Array with no items?
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is an empty array
    //    @visibility external
    //<
    emptyArray : function (object) {
        return isc.isAn.Array(object) && object.length == 0;
    },

    //> @staticMethod isA.nonemptyArray()
    // Is <code>object</code> an array with at least one item?
    // <p>
    // Note: <code>null</code>, <code>undefined</code>, and empty slots in an array are still
    // considered an item.
    //
    // @param object (Any) The object or value to test.
    // @return (boolean) <code>true</code> if <code>object</code> is an array with at least
    // one item; <code>false</code> otherwise (i.e. <code>object</code> isn't an array, or
    // it has no items)
    // @visibility external
    //<
    nonemptyArray : function (object) {
        return this.Array(object) && object.length >= 1;
    },

    //> @staticMethod isA.String()
    //
    //    Is <code>object</code> a String object?
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a String
    //    @visibility external
    //<
    // ==========================================================================================
    // IMPORTANT: If you update this function, also update its copy in FileLoader.js
    // ==========================================================================================
    String : function (object) {
        if (object == null) return false;

        // GWT workaround for Issue 4301, fixed in GWT 2.5. Only applied if isc_legacyGWT is set.
        if (isc._legacyGWTWorkaround &&
            object.Class != null && object.Class == this._$String)
        {
            return true;
        }

        // typeof is the fastest check and works for all primitive strings and same-frame
        // String objects. Cross-frame boxed primitives (new otherFrame.String()) return
        // "object" for typeof - use isc.isA.crossFrame.String() for that rare case.
        return typeof object == "string";
    },

    //> @staticMethod isA.Array()
    //
    //    Is <code>object</code> an Array object?<br><br>
    //
    //    NOTE: if you prefer, you can call this as <code>isAn.Array()</code>
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is an Array
    //    @visibility external
    //<
    Array : function (object) {
        if (object == null) return false;


        return Array.isArray(object);
    },

    //> @staticMethod isA.Function()
    //
    //    Is <code>object</code> a Function object?
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Function
    //    @visibility external
    //<
    _$function : "function",
    Function : function (object) {
        if (object == null) return false;


        return typeof object == this._$function;
    },

    //> @staticMethod isA.Number()
    //
    //    Is <code>object</code> a Number object?<br><br>
    //
    //    NOTE: this returns false if <code>object</code> is an invalid number (<code>isNaN(object) == true</code>)
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Number
    //    @visibility external
    //<
    Number : function (object) {
        // typeof + finite check. This is equivalent to Number.isFinite(object) but slightly
        // faster because we avoid the function call overhead. Cross-frame boxed primitives
        // (new otherFrame.Number()) return "object" - use isc.isA.crossFrame.Number() for that.
        return typeof object == "number" &&
            !isNaN(object) &&
            object != Number.POSITIVE_INFINITY &&
            object != Number.NEGATIVE_INFINITY;
    },

    SpecialNumber : function (object) {
        // NOTE: we do need to first determine if it's a number because isNaN({}) is true
        if (typeof object != "number") return false;
        return isNaN(object) ||
            object == Number.POSITIVE_INFINITY ||
            object == Number.NEGATIVE_INFINITY;
    },

    //> @staticMethod isA.Boolean()
    //
    //    Is <code>object</code> a Boolean object?
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Boolean
    //    @visibility external
    //<
    Boolean    : function (object) {
        // typeof is the fastest check. Cross-frame boxed primitives (new otherFrame.Boolean())
        // return "object" - use isc.isA.crossFrame.Boolean() for that rare case.
        return typeof object == "boolean";
    },

    //> @staticMethod isA.Date()
    //
    // Is <code>object</code> a Date object?
    // <P>
    // This method should be used instead of <code>instanceof Date</code> when the object may
    // have been created in a different frame (e.g., iframe or popup window), as
    // <code>instanceof</code> fails cross-frame. This method includes fallback detection
    // using constructor toString comparison.
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Date
    //    @visibility external
    //<
    Date : function (object, validate) {
        if (object == null) return false;

        // Fast rejection of primitives - Dates are always objects
        if (typeof object != "object") return false;

        // instanceof handles same-frame Dates efficiently
        if (object instanceof Date) {
            // Validation for pseudo-dates from bad string parsing
            if (validate && !isc.isA.Number(object.getDate())) return false;
            return true;
        }

        // Cross-frame detection: instanceof fails because constructors differ, but
        // constructor.toString() matches. SGWT: avoid crash on Java objects.
        if (isc.Browser.isSGWT && window.SmartGWT.isNativeJavaObject(object)) return false;

        if (("" + object.constructor) == ("" + Date)) {
            // Cache the type for future checks on objects from this frame
            object.constructor.__nativeType = 3;
            if (validate && !isc.isA.Number(object.getDate())) return false;
            return true;
        }
        return false;
    },

    //> @staticMethod isA.RegularExpression()
    //
    // Is <code>object</code> a Regular Expression (RegExp) object?
    // <P>
    // This method should be used instead of <code>instanceof RegExp</code> when the object may
    // have been created in a different frame (e.g., iframe or popup window), as
    // <code>instanceof</code> fails cross-frame. This method includes fallback detection
    // using constructor toString comparison.
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a RegExp
    //    @visibility external
    //<
    RegularExpression : function (object) {
        if (object == null) return false;

        // Fast rejection of primitives - RegExps are always objects
        if (typeof object != "object") return false;

        // instanceof handles same-frame RegExps efficiently
        if (object instanceof RegExp) return true;

        // Cross-frame detection: instanceof fails because constructors differ, but
        // constructor.toString() matches. SGWT: avoid crash on Java objects.
        if (isc.Browser.isSGWT && window.SmartGWT.isNativeJavaObject(object)) return false;

        if (("" + object.constructor) == ("" + RegExp)) {
            // Cache the type for future checks on objects from this frame
            object.constructor.__nativeType = 7;
            return true;
        }
        return false;
    },


    _$textXML : "text/xml",
    XMLNode : function (object) {
        if (object == null) return false;
        if (isc.Browser.isIE) {
            return object.specified != null && object.parsed != null &&
                   object.nodeType != null && object.hasChildNodes != null;
        }
        var doc = object.ownerDocument;
        if (doc == null) return false;
        return doc.contentType == this._$textXML;
    },


    // ---------------------------------------------------------------------------------------
    // NOTE: the following few functions are used strictly in expressionToFunction(), are not
    // i18n-safe, and should not be externally visible
    // ---------------------------------------------------------------------------------------

     //> @staticMethod isA.AlphaChar()
     //
     //  Is the character passed in an alpha character?
     //
     //  @param  char    (String)        character to test
     //  @return                 (boolean)       true == character is alpha
     //<
     AlphaChar : function (character) {
         // XXX: does not yet deal with unicode characters or extended ASCII characters.
         var code = character.charCodeAt(0);
         return ((code >= 65 &&
                  code <= 90) ||
                 (code >= 97 &&
                  code <= 122))
     },

     //> @staticMethod isA.NumChar()
     //
     //  Is the character passed in a Decimal (0-9) character?
     //
     //  @param  char    (String)        character to test
     //  @return                 (boolean)       true == character is a decimal character
     //<
     NumChar : function (character) {
         // XXX: does not yet deal with unicode characters
         var code = character.charCodeAt(0)
         return (code >= 48 &&
                 code <= 57)
     },

     //> @staticMethod isA.AlphaNumericChar()
     //
     //  Is the character passed in alphanumeric?
     //
     //  @param  char    (String)        character to test
     //  @return                 (boolean)       true == character is alphanumeric
     //<
     AlphaNumericChar : function (character) {
        return (isc.isA.AlphaChar(character) || isc.isA.NumChar(character))
    },

     //> @staticMethod isA.WhitespaceChar()
     //
     //  Is the character passed in a whitespace character?
     //  This method considers any ascii character from 0-32 to be a whitespace character.
     //
     //  @param  char    (String)        character to test
     //  @return                 (boolean)       true == character is a whitespace character
     //<
     WhitespaceChar : function (character) {
         // XXX: does not yet deal with unicode characters
         var code = character.charCodeAt(0)
         return (code >= 0 &&
                code <= 32)
     },

    //> @staticMethod isA.color
    //  Is this a valid css color.  Used by the isColor() validator
    //<

    color : function (object) {
        if (!isc.isA.String(object)) return false;

        if (!this._cssColorRegexp) {
            this._cssColorRegexp = new RegExp(
                            // hex:         "#D3D3D3", etc
                            "^(#([\\dA-F]{2}){3}|" +
                            "#([\\dA-F]{2}){4}|" +
                            // rgb:         "rgb(255,255,255)", etc.

                                "rgb\\((\\s*[\\d]{1,3}\\s*,\\s*){2}\\s*[\\d]{1,3}\\s*\\)" +
                            // colorname:   "white", "black", "pink", etc.

                                ")$",

                            // Case insensitive
                            "i"
            );
        }


        var result = this._cssColorRegexp.test(object);
        if (!result) {
            if (object == "transparent" || isc.ColorUtils.colorNames[object]) {
                // support 'transparent' and standard color-names
                result = true;
            }
        }
        return result;
    },

    // Module Dependencies:
    // ResultSet / ResultTree are both defined as part of the Databinding module but are frequently
    // checked for within grids.
    // Implement default isA functions for these classes so we can check isc.isA.ResultSet() without
    // needing an explicit check for the function being present
    ResultSet : function (data) {
        return false;
    },
    ResultTree : function (data) {
        return false;
    },

    // Overridding isA.className methods:
    // We provide custom isc.isA implementations for the following class names which we don't
    // want to be clobberred when the class method is defined

    _customClassIsA:{
        SelectItem:true,
        Time:true
    },

    // SelectItem IsA Overrides
    // ---------------------------------------------------------------------------------------

    // isc.isA.SelectItem() default implementation would come from the definition of the
    // selectItem class.
    // However we want this method to return true for NativeSelectItems (not a subclass of
    // SelectItem).
    SelectItem : function (object) {
        if(object==null||object.isA==null||
            object.ns==null||object.ns.isA==null||object.isA===object.ns.isA){
            return false;
        }
        return object.isA("SelectItem") || object.isA("NativeSelectItem");
    },

    // Support 'isA.SelectOtherItem()' to test for SelectItems or NativeSelectItems where
    // isSelectOther is true.
    SelectOtherItem : function (item) {
        return isc.isA.SelectItem(item) && item.isSelectOther == true;
    },

    // SmartClient stores Times in JavaScript Date objects so make isA.Time a synonym for isA.Date
    Time : function (object) {
        return isc.isA.Date(object);
    }

});

if (Array.isArray) {
    isc.addMethods(isc.isA, {

        Array : Array.isArray
    });
}


// =============================================================================
// Cross-Frame Boxed Primitive Detection
// =============================================================================
// These versions use Object.prototype.toString.call() which correctly identifies boxed
// primitives from other frames. They are slower than the typeof-based versions but handle
// the rare case of cross-frame boxed primitives (new otherFrame.String("text"), etc.).
//
// Always available as isc.isA.crossFrame.String(), etc.
// Installed as default isc.isA.String() etc. if window.isc_crossFrameCompat = true.

isc.isA.crossFrame = {
    _$toString: Object.prototype.toString,
    _$objectString: "[object String]",
    _$objectNumber: "[object Number]",
    _$objectBoolean: "[object Boolean]",

    String : function (object) {
        if (object == null) return false;
        // GWT workaround for Issue 4301, fixed in GWT 2.5
        if (isc._legacyGWTWorkaround &&
            object.Class != null && object.Class == "String")
        {
            return true;
        }
        // typeof handles primitives; toString handles boxed primitives from any frame
        var type = typeof object;
        if (type == "string") return true;
        if (type != "object") return false;
        return isc.isA.crossFrame._$toString.call(object) == isc.isA.crossFrame._$objectString;
    },

    Number : function (object) {
        if (object == null) return false;
        var type = typeof object;
        if (type == "number") {
            return !isNaN(object) &&
                object != Number.POSITIVE_INFINITY &&
                object != Number.NEGATIVE_INFINITY;
        }
        if (type != "object") return false;
        // Boxed number - check via toString, then validate
        if (isc.isA.crossFrame._$toString.call(object) != isc.isA.crossFrame._$objectNumber) {
            return false;
        }
        var val = object.valueOf();
        return !isNaN(val) &&
            val != Number.POSITIVE_INFINITY &&
            val != Number.NEGATIVE_INFINITY;
    },

    Boolean : function (object) {
        if (object == null) return false;
        var type = typeof object;
        if (type == "boolean") return true;
        if (type != "object") return false;
        return isc.isA.crossFrame._$toString.call(object) == isc.isA.crossFrame._$objectBoolean;
    }
};

// If cross-frame boxed primitive detection is enabled, replace the fast versions with
// the slower cross-frame compatible versions
if (isc._crossFrameCompat) {
    isc.isA.String = isc.isA.crossFrame.String;
    isc.isA.Number = isc.isA.crossFrame.Number;
    isc.isA.Boolean = isc.isA.crossFrame.Boolean;
}


//    @end @object isA


//--------------------------------------------------------------------------------------------------
// partial addProperties support
//--------------------------------------------------------------------------------------------------
// define addProperties(), but don't redefine it if FileLoader was loaded after ISC
// Note: copied partially from Object.js
if (isc.addProperties == null) {
    isc.addGlobal("addProperties", function (destination, source) {
        for (var propName in source)
            destination[propName] = source[propName];
        return destination;
    });
}

isc.addGlobal("evalSA", function (expression) {
    //!OBFUSCATEOK
    if (isc.eval) isc.eval(expression);
    else eval(expression);
});

isc.addGlobal("defineStandaloneClass", function (className, classObj) {
    if (isc[className]) {
        if (className == "FileLoader" && isc.FileLoader._isStub) {
            // redefinition of FileLoader stub is allowed
            isc[className] = null;
        } else {
            return;  // don't redefine
        }
    }

    isc.addGlobal(className, classObj);
    isc.addProperties(classObj, {
        _saClassName: className,

        fireSimpleCallback : function (callback) {
            callback.method.apply(callback.target ? callback.target : window,
                                  callback.args ? callback.args : []);
        },

        // Logging - log to a special array that gets dumped into the the DevConsole logs by
        // Log.js.  Timestamps will be accurate.  If you're not loading Core, you can use
        // getLogs() to get the logs.
        logMessage : function (priority, message, category) {
            if (isc.Log) {
                isc.Log.logMessage(priority, message, category);
                return;
            }
            if (!isc._preLog) isc._preLog = [];
            isc._preLog[isc._preLog.length] = {
                priority: priority,
                message: message,
                category: category,
                timestamp: new Date()
            };
        },


        // NOTE: log priorities copied from Log.js
        logError : function (message) {
            this.logMessage(2, message, this._saClassName);
        },
        logWarn : function (message) {
            this.logMessage(3, message, this._saClassName);
        },
        logInfo : function (message) {
            this.logMessage(4, message, this._saClassName);
        },
        logDebug : function (message) {
            this.logMessage(5, message, this._saClassName);
        },
        // end logging

        _assert : function (b, message) {
            if (!b) {
                throw (message || "assertion failed");
            }
        },

        //--------------------------------------------------------------------------------------------------
        // IsA support
        //--------------------------------------------------------------------------------------------------
        // Note: can't provide this as isc.isA because in Core.js we load Object before isA and Object
        // has conditional logic that uses isA
        //
        // Also, ClassFactory.makeIsAFunc() expect isA to always be a function, so don't stick
        // an isA object literal on here or it will crash
        isAString : function (object) {
            // upgrade: when ISC_Core is available, defer to that code
            if (isc.isA) return isc.isA.String(object);
            return typeof object == "string";
        },

        isAnArray : function (object) {
            // upgrade: when ISC_Core is available, defer to that code
            if (isc.isA) return isc.isAn.Array(object);
            return typeof object == "array";
        },

        _singleQuoteRegex: new RegExp("'", "g"),
        _doubleQuoteRegex: new RegExp("\"", "g"),
        _asSource : function (string, singleQuote) {
            if (!this.isAString(string)) string = String(string);

            var quoteRegex = singleQuote ? this._singleQuoteRegex : this._doubleQuoteRegex,
                outerQuote = singleQuote ? "'" : '"';
            return outerQuote +
                       string.replace(/\\/g, "\\\\")
                             // quote whichever quote we use on the outside
                             .replace(quoteRegex, '\\' + outerQuote)
                             .replace(/\t/g, "\\t")
                             .replace(/\r/g, "\\r")
                             .replace(/\n/g, "\\n")
                             .replace(/\u2028/g, "\\u2028")
                             .replace(/\u2029/g, "\\u2029") + outerQuote;
        },

        _asHTML : function (string, noAutoWrap) {
            if (!this.isAString(string)) string = String(string);
            var s = string.replace(/&/g, "&amp;")
                        .replace(/</g, "&lt;")
                        .replace(/>/g,"&gt;")
                        // if we don't do this, we lose the leading space after a crlf because all
                        // browsers except IE in compat (non-standards) mode treat a <BR> followed by a
                        // space as just a <BR> (the space is ignored)
                        .replace(/(\r\n|\r|\n) /g,"<BR>&nbsp;")
                        .replace(/(\r\n|\r|\n)/g,"<BR>")
                        .replace(/\t/g,"&nbsp;&nbsp;&nbsp;&nbsp;");
            // in autoWrap mode, replace two spaces with a space and an &nbsp; to preserve wrapping to
            // the maximum extent possible
            return (noAutoWrap ? s.replace(/ /g, "&nbsp;") : s.replace(/  /g, " &nbsp;"));
        }

    });

    // alias
    classObj.isAn = classObj.isA;

    return classObj;
});

if (!String.prototype.contains) {
    String.prototype.contains = function (substring) {
        return this.indexOf(substring) >= 0;
    };
}


isc.defineStandaloneClass("SA_Page", {

_isLoaded: (isc.Page && isc.Page.isLoaded()) || false,
_pageLoadCallbacks: [],

isLoaded : function () {
    return this._isLoaded;
},

onLoad : function (callback, target, args) {
    this._pageLoadCallbacks.push({
        method: callback,
        target: target,
        args: args
    });

    if (!this._registeredOnload) {
        this._registeredOnload = true;
        // HACK: Opera: addEventListener("load") fires seemingly on every externally loaded
        // file in Opera.  But Opera emulates IE's attachEvent(), and fires load normally.
        if ((isc.Browser.isIE && isc.Browser.version < 11) || isc.Browser.isOpera) {
            window.attachEvent("onload", function () { isc.SA_Page._firePageLoadCallbacks(); });
        } else {
            window.addEventListener("load", function () { isc.SA_Page._firePageLoadCallbacks(); }, true);
        }
    }
},

_firePageLoadCallbacks : function () {
    // Moz/FF has a bug: if you register a page onload event, but navigate away from the page
    // before the page finishes loading, the onload event may fire on the page that you
    // navigated away to - even if it's a completely different site.  This typically results in
    // a JS error.
    //
    // Also - this can be fored from EventHandler.handeLoad(), so trap double call.
    if (!window.isc || this._isLoaded) return;

    // flag page as loaded
    this._isLoaded = true;

    // process all callbacks
    for (var i = 0; i < this._pageLoadCallbacks.length; i++) {
        var callback = this._pageLoadCallbacks[i];
        this.fireSimpleCallback(callback);
    }
    delete this._pageLoadCallbacks;
}

});

if (!isc.SA_Page.isLoaded()) {
    isc.SA_Page.onLoad(function () { this._isLoaded = true; }, isc.SA_Page);
}






// Synthetic History Support
// --------------------------------------------------------------------------------------------
//



//> @object History
//
// This class provides synthetic history support.  Using this class, you can create history
// entries at any point and be called back when the user next navigates to any of these history
// entries via any of the browser mechanisms that enable navigation: back/forward buttons,
// history dropdown and bookmarks.
// <p>
// The history entries created using this mechanism work just like history entries created
// natively by the browser, except you get a callback whenever a transition occurs.  This
// implementation correctly handles "deep" history - i.e. it correctly maintains forward and
// back history when the user navigates forward or back away from the page that uses this
// module.
// <p>
// This module is usable independent of the rest of SmartClient - you can use it on pages that
// don't load any other modules.
// <p>
// <b>Platform Notes:</b><br>
// In Safari (4.0 and above), this module has the limitation that the arbitrary data parameter
// in addHistoryEntry() is not reliable.<br>
// Internet Explorer: If you set document.domain on the top-level page, the History
// mechanism will behave sub-optimally in IE - three clicks one the forward/back buttons will
// be required to transition to the next history entry.
// <p>
// <b>Usage overview</b><br>
// Synthetic history entries are added to the browser history via +link{History.addHistoryEntry()}.
// When this method is called, the page's URL will be modified and the native browser back button
// will become active.<br>
// The +link{History.registerCallback()} allows the developer to register a callback method to
// fire when the user navigates to these generated history entries. This method will be fired
// with an appropriate history ID when the user hits the back-button or explicitly navigates to
// the URL generated for some synthetic history entry.
//
// @treeLocation Client Reference/System
// @visibility external
//<
//--------------------------------------------------------------------------------------------------
isc.defineStandaloneClass("History", {

//> @staticMethod History.registerCallback()
// Registers a callback to be called when the user navigates to a synthetic history entry.
// <p>
// <b>NOTE:</b> Only one primary callback can be registered at a time. Unless <code>isAdditional</code>
// is true, then <code>registerCallback()</code> registers the primary callback. To register
// a callback that is called in addition to the primary callback, if set, pass <code>true</code>
// for <code>isAdditional</code>.
// <p>
// If the SmartClient Core module is loaded on the page where you're using the History module,
// you can use any format acceptable to +link{Class.fireCallback} as the callback.  The
// parameters 'id' and 'data' will be passed to your callback, in that order.
// <p>
// If the SmartClient Core module is not loaded on the page, you can use one of the following
// formats:
// <ul>
// <li>A function that takes an id and a data argument, in that order.
// <li>An object literal with a property named 'method' whose value is a function that takes
// an id and a data argument, in that order; and a property named 'target' that specifies the
// object on which the callback function should be applied.  So, e.g:
// <pre>
// {target: myObj, method: myObj.myFunction}
// </pre>
// </ul>
// The user can navigate to a synthetic history entry (and trip this callback) in one of two ways:
// <ul>
// <li>When +link{History.addHistoryEntry()} method is called, a new URL associated with the
//     history entry is generated, and the browser's back/forward navigation buttons become active.
//     The user can then navigate back to a stored history entry via standard browser history
//     navigation, or by explicitly hitting the appropriate URL. In this case both the ID and
//     data parameter passed to +link{History.addHistoryEntry()} will be available when the
//     callback fires.</li>
// <li>Alternatively the user can store a generated history URL (for example in a browser bookmark)
//     and navigate directly to it in a new browser session. In this case the 'addHistoryEntry()'
//     may not have been fired within the browser session. This callback will still fire with the
//     appropriate history ID but the data parameter will be null. You can disable this behavior
//     by passing in the <code>requiresData</code> parameter.</li>
// </ul>
//
// If this method is called before the page has loaded, and the page initially has a URL with
// a history ID, the callback will be fired with the appropriate ID on page load.
// However if a history callback is registered after the page has loaded, it will not be fired
// until the user moves to a new synthetic history entry. If you wish to explicitly check the
// current URL for a history entry, you can use the +link{History.getCurrentHistoryId()} method.
// <p>
// When the user transitions to the history entry immediately before the first synthetic
// history entry, the callback is fired with an id of null.
//
// @param callback (String | Object) The callback to invoke when the user navigates to a
// synthetic history entry.
// @param requiresData (boolean) If passed, this callback will only be fired if the user is
// navigating to a history entry that was explicitly generated in this browser session.
// @param [isAdditional] (boolean) If false or unspecified, then the callback is considered to
// be the primary callback, replacing the previous primary callback if the primary callback was
// previously registered. If true, then the callback is an additive callback; that is, it is
// called in addition to the primary callback, and after the primary callback is called.
// @return (int) the ID of the callback. This can be passed to +link{History.unregisterCallback()}
// to remove the callback.
// @visibility external
//<
_callbacksRegistry: [],
_nextCallbackID: 1, // 0 is currently reserved for the primary callback, but this is an internal
                    // detail that may change without notice
registerCallback : function (callback, requiresData, isAdditional) {

    if (callback == null) {
        if (!isAdditional) this.unregisterCallback(0);
        return -1;
    }

    var historyId;
    if (isAdditional) {
        historyId = this._nextCallbackID++;
    } else {
        // unregister the previous primary callback, if set
        this.unregisterCallback(0);

        historyId = 0;
    }

    var r = {
        callback: callback,
        requiresData: !!requiresData,
        ID: historyId
    };

    if (isAdditional) {
        this._callbacksRegistry[this._callbacksRegistry.length] = r;
    } else {
        // make sure that the primary callback is at the beginning of the _callbacksRegistry
        // array so that it is called first.
        this._callbacksRegistry.unshift(r);
    }
    return historyId;
},

//> @staticMethod History.unregisterCallback()
// Unregisters a callback so that it will no longer be called when the user navigates to a synthetic
// history entry.
//
// @param id (int) the ID of the callback that was returned by +link{History.registerCallback()}.
// @return (boolean) <code>true</code> if the callback registration was located and removed;
// <code>false</code> otherwise.
// @visibility external
//<
unregisterCallback : function (historyId) {
    var pos;
    var registry = this._callbacksRegistry;

    // we can't use the Array.findIndex() utility here because the History module may be
    // used standalone, without ISC_Core being loaded
    for (pos = 0; pos < registry.length; ++pos) {
        var r = registry[pos];
        if (r.ID == historyId) break;
    }

    // not found
    if (pos >= registry.length) return false;


    registry.splice(pos, 1);
    return true;
},

//> @staticMethod History.getCurrentHistoryId()
//
// Returns the current history id as reflected by the current URL.
//
// @return (String) The current history id as reflected by the current URL.
// @visibility external
//<
getCurrentHistoryId : function () {
    var historyId = this._getHistory(location.href);
    if (historyId == "_isc_H_init") return null;
    return historyId;
},


//> @staticMethod History.getHistoryData()
//
// Returns the data associated with the specified history id.
//
// @param id (String) The id for which to fetch history data.
// @return (Any) The data associated with the specified history id.
// @visibility external
//<
getHistoryData : function (historyId) {
    return this.historyState ? this.historyState.data[historyId] : null;
},


//> @staticMethod History.setHistoryTitle()
//
// Sets the title associated with all history entries.  This is the string that appears in the
// history drop-down.  If left unset, this default to the history id that is passed into
// +link{History.addHistoryEntry}.
// <p>
// Note: Currently, this works in IE only.  You may call this method in all other browsers,
// but it will not change what's displayed in the history drop-down.
//
// @param title (String) The title to show in the history drop-down.
// @visibility external
//<
setHistoryTitle : function (title) {
    this.historyTitle = title;
},

//> @staticMethod History.addHistoryEntry()
//
// Call this method to add a synthetic history entry.  The new history entry is added in the
// history stack after the currently visible page - in exactly the same way as the browser
// would treat a new page transition at this point.  In other words, if the user has navigated
// ten pages using, say, a mixture of synthetic and real history entries, then presses back
// five times and then triggers a call to this method, the history entry will be created at the
// 6th position in the history stack and any history entries forward of that will be discarded.
// <p>
// <b>NOTE:</b> Browsers including Chrome and Firefox require a delay, even a minimal 1 millisecond
// timeout, between additions to the browser's history stack or else only the last addition
// will have an effect. The History module does not allow two different (by id) history entries
// to be added in the same thread of execution. To check whether another history entry can be
// added by the current thread, call +link{History.readyForAnotherHistoryEntry()}.
// <p>
// This method must be called with an id.  This id can be any string - it will be URL-encoded
// and added to the current page URL as an anchor (e.g. #foo).  This URL change allows the user
// to bookmark this particular application state.  When the user next navigates to this history
// entry, the id you supplied here will be passed back to the callback you supplied via
// +link{History.registerCallback}.
// <p>
// You may also optionally supply some arbitrary data to associate with this history entry.
// If you do this, the data you passed in will be passed back to you as part of the callback
// you specified via +link{History.registerCallback}.  This data object can be anything you
// want, but there are some caveats:
// <ul>
// <li>The data parameter is currently supported by all SmartClient-supported browsers except
// <b>Safari</b></li>
// <li>As long as the user has not navigated away from the top-level page (i.e. the user is
// navigating within synthetic history entries only), whatever data you pass in will be handed
// back to you.
// <li>When the user navigates away from the current page, SmartClient will attempt to
// serialize the data into a string so that when/if the user comes back to this history entry,
// it can be deserialized and passed back to your logic.  To take advantage of this, you need
// to make sure that your data is serializeable.  As long as your data is a native datatype
// (String, Number, Boolean) or a collection of such datatypes (collections meaning object
// literals and arrays), then it will serialize correctly.  Things like pointers to the
// document object and functions cannot be serialized.
// <li>In order for the serialization to occur on a page transition, you must have the
// SmartClient Core module loaded on the page at the time of the transition.  If it's not
// available, the data will be lost, but you will still get a callback with the id you specify
// if the user navigates back to this history entry later.
// <li>The data associated with this history entry will persist as long as at least one
// instance of the browser remains open on the user's machine.  Once the user closes all
// browser instances, the data will be lost.
// <li>Also, the user can trigger a history callback at any time by navigating to a bookmarked
// history entry that may have been created in a past session, such that no data is associated
// with that id in the current session.  How you choose to handle that situation is up to you.
// </ul>
// <p>
// You're always guaranteed to receive the id you associate with a history entry in the
// callback that you specify, but the data you associated may or may not be available, so be
// careful about how you use it. Note that by passing the <code>requiresData</code> parameter
// to +link{History.registerCallback()} you can suppress the callback from firing unless the stored
// data object is actually available.
//
// @param id (String) The id you want to associate with this history entry.  This value will
// appear as an anchor reference at the end of the URL string.  For example, if you pass in
// "foo" as the id, the URL will then have a #foo tacked on the end of it.  This id will be
// passed back to the callback you specified in +link{History.registerCallback} when the user
// navigates to this history entry in the future.
//
// @param [title] (String) The title to show in the history drop-down for this history entry.  If
// not specified, the <code>id</code> is used, unless you've set an explicit history title via
// +link{History.setHistoryTitle}.  Note: this currently works in IE only.  You may pass a
// title in any other browser, but it will not change what's displayed in the history
// drop-down.
//
// @param [data] (Any) Arbitrary data to associate with this history entry.  When the user next
// navigates to this history entry, this data will be provided as an argument to your callback
// function.  Note that the SmartClient Core module is also required to be loaded on the page
// for this particular feature to work.
//
// @visibility external
//<
_finishAddingHistoryEntryTEAScheduled: false,
addHistoryEntry : function (historyId, title, data) {
    //>DEBUG
    this.logDebug("addHistoryEntry: id=" + historyId + " data=" + (isc.echoAll && isc.Log ? isc.echoAll(data) : String(data)));
    //<DEBUG

    // Avoid #null situations. Unfortunately we can't remove the anchor entirely (see below)
    if (historyId == null) historyId = "";

    if (isc.Browser.isSafari && isc.Browser.safariVersion < 500) {
        // We'd like to simply change the hash in the URL and call it a day.  That would at
        // least allow the user to bookmark the page.  Unfortunately this doesn't work - Canvas
        // rendering magically breaks after this is done, producing "DOM Exception 8".
        //
        // I tried dynamically inserting an anchor tag with the name of the id, just in case
        // Safari was angry with the lack of an actual anchor target for the new URL, but that
        // didn't change anything.  Revisit later.
        //
        // Last tested in Safari 2.0.4 (419.3)
        //location.href = this._addHistory(location.href, historyId);
        return;
    }


    if (!isc.SA_Page.isLoaded()) {
        this.logWarn("You must wait until the page has loaded before calling "
                     +"isc.History.addHistoryEntry()");
        return;
    }



    // clean up the history stack if the ID of the current URL isn't at the top of the stack.
    var currentId = this._lastHistoryId;

    // if no data was passed in, store explicit null rather than leaving undefined
    // we use this to detect that this was a registered history entry (this session)
    var undef;
    if (data === undef) data = null;

    // disallow sequentual duplicate entries
    if (currentId == historyId) {
        // treat it as overwrite of data
        if (this.historyState.data.hasOwnProperty(historyId)) {
            this.historyState.data[historyId] = data;
            this._saveHistoryState();
        }
        return;
    }

    if (this._finishAddingHistoryEntryTEAScheduled) {
        this.logError("History.addHistoryEntry() cannot be called with different IDs in the " +
                      "same thread. In the current thread of execution, addHistoryEntry() was " +
                      "previously called with id:'" + this.historyState.stack[this.historyState.stack.length - 1] +
                      "', but an attempt was made to add a history entry with id:'" + historyId + "'. " +
                      "Only the first history entry will be added.");
        return;
    }

    // remove orphaned history entries
    while (this.historyState.stack.length) {
        var topOfStack = this.historyState.stack.pop();
        if (topOfStack == currentId) {
            this.historyState.stack.push(topOfStack);
            break;
        }
        // delete data associated with this id
        delete this.historyState.data[topOfStack];
    }
    this.historyState.stack[this.historyState.stack.length] = historyId;
    this.historyState.data[historyId] = data;

    this._saveHistoryState();

    if (this.usePushState) {

        if (this.pushStateMode == "queryParam" && this._handleHashChange && location.hash) {
            window.history.replaceState({historyId: decodeURI(location.hash.substring(1))}, '');
        }
        window.history.pushState({historyId: historyId}, '', this._addHistory(location.href, historyId));
    } else {
        if (isc.Browser.isIE) {
            if (historyId != null && document.getElementById(historyId) != null) {
                this.logWarn("Warning - attempt to add synthetic history entry with id that conflicts"
                             +" with an existing DOM element node ID - this is known to break in IE");
            }

            // navigate the iframe forward
            //

            // if this is the very-first synthetic history entry, add an extra entry for the
            // current URL
            if (currentId == null) {
                // the title for this first entry is the title of this page - which is the <title>
                // if there's one on the page, or, failing that, the href of the page.
                var initTitle = location.href;
                var docTitle = document.getElementsByTagName("title");
                if (docTitle.length) initTitle = docTitle[0].innerHTML;
                this._iframeNavigate("_isc_H_init", initTitle);
            }
            this._iframeNavigate(historyId, title);
        } else {
            // Moz/FF
            // update the visible URL (this actually creates the history entry)
            location.href = this._addHistory(location.href, historyId);
        }
    }
    this._lastURL = location.href;

    if (isc.EH) {
        isc.EH._setThreadExitAction(this._finishAddingHistoryEntry);
    } else {
        setTimeout(this._finishAddingHistoryEntry, 0);
    }
    this._finishAddingHistoryEntryTEAScheduled = true;
    this._lastHistoryId = historyId;
},

_finishAddingHistoryEntry : function () {

    // _finishAddingHistoryEntry() will be called with `this === window'
    if (isc.History._finishAddingHistoryEntryTEAScheduled) {
        isc.History._finishAddingHistoryEntryTEAScheduled = false;
    }
},

//> @staticMethod History.readyForAnotherHistoryEntry()
//
// Can another history entry be added to the browser's history stack in the current thread?
// <p>
// Browsers including Chrome and Firefox require a delay, even a minimal 1 millisecond
// timeout, between additions to the browser's history stack or else only the last addition
// will have an effect. The History module does not allow two different (by id) history entries
// to be added in the same thread of execution.
//
// @return (boolean) whether another history entry can be added via +link{History.addHistoryEntry()}.
// @visibility external
//<
readyForAnotherHistoryEntry : function () {
    return !this._finishAddingHistoryEntryTEAScheduled;
},

_iframeNavigate : function (historyId, title) {
    this._ignoreHistoryCallback = true;

    // need to quote special chars because we're document writing this id into the the iframe
    var escapedId = this._asSource(historyId);
    title = (title != null ? title
                           : (this.historyTitle != null ? this.historyTitle
                                                        : historyId));

    var html = "<HTML><HEAD><TITLE>"+
               (title == null ? "" : this._asHTML(title))+
               "</TITLE></HEAD><BODY><SCRIPT>var pwin = window.parent;if (pwin && pwin.isc)pwin.isc.History.historyCallback(window, " + escapedId.replace(/<\/script\s*>/gi, "</\"+\"script>") + ");</SCRIPT></BODY></HTML>";
    var win = this._historyFrame.contentWindow;
    win.document.open();
    win.document.write(html);
    win.document.close();
},

// in IE, this method will always return false before pageLoad because historyState is not
// available until then.  In Moz/FF, this method will return accurate data before pageLoad.
haveHistoryState : function (historyId) {
    if (isc.Browser.isIE && !isc.SA_Page.isLoaded()) {
        this.logWarn("haveHistoryState() called before pageLoad - this always returns false"
                    +" in IE because state information is not available before pageLoad");
    }
    var undef;
    return this.historyState && this.historyState.data[historyId] !== undef;
},


_getIsomorphicDir : function () {
    return window.isomorphicDir ? window.isomorphicDir : "../isomorphic/";
},

// prefer pushState if browser supports it and not explicitly disabled
usePushState: window.history != null && window.history.pushState != null && window.isc_history_usePushState !== false,
// valid values: 'queryParam', 'hashFragment'
pushStateMode: "hashFragment",
pushStateQueryParamName: "hid",

// this method is called before pageLoad at the end of this file
_init : function () {
    this.logInfo("History initializing");
    if (this._trackingHistory) return;
    this._trackingHistory = true;

    // in safari we only support chaning the top-level URL to something bookmarkable, but
    // history support is non-existant at present
    if (isc.Browser.isSafari && isc.Browser.safariVersion < 500) return;

    // write out a form that will store serialized data associated with each history id.  We'll
    // use this to support cross-page transition history in IE.  Also, this allows the user to
    // associate arbitrary data with an id, which will be available in his callback.
    //
    // This allows the pattern of registering a callback that simply does eval(data) where
    // that's appropriate.
    //
    // Note: setting visibility:hidden on the form breaks body styling in IE.  Setting
    // display:none on the form breaks page rendering completely in IE.   But setting
    // display:none on the textarea works around that problem.
    //
    var formHTML = "<form style='position:absolute;top:-1000px' id='isc_historyForm'>"
           + "<textarea id='isc_historyField' style='display:none'></textarea></form>";
    document.write(formHTML);

    if (isc.Browser.isIE) {
        var frameHTML = "<iframe id='isc_historyFrame' src='" + this.getBlankFrameURL() +
                        "' style='position:absolute;visibility:hidden;top:-1000px'></iframe>";
        document.write(frameHTML);
        this._historyFrame = document.getElementById('isc_historyFrame');

        // make sure the frame isn't the last thing in the BODY tag - see comments in
        // createAbsoluteElement() for notes on this.
        document.write("<span id='isc_history_buffer_marker' style='display:none'></span>");
    }

    // init() calls _completeInit() in Moz, but in IE we must wait for page load before we can
    // get the form auto-fill data out.
    if (isc.Browser.isIE) {
        isc.SA_Page.onLoad(function () { this._completeInit() }, this);
    } else {
        this._completeInit();
    }

    if (this.usePushState) {
        this._initialURL = location.href;
        window.onpopstate = function (event) {
            // we get an onpopstate with a null state on a hash fragment change - ignore here
            // and handle below with onhashchange
            if (!event.state) return;
            isc.History._fireHistoryCallback(event.state.historyId);
        }

        if (this.pushStateMode == "hashFragment" && !isc.Browser.isIE) {
            // also support firing callbacks on location.hash changes in this mode

            window.onhashchange = function (event) {
                if (event.newURL && event.newURL.indexOf("#") != -1) {
                    var historyId = decodeURIComponent(event.newURL.substring(
                                                           event.newURL.indexOf("#") + 1));
                    isc.History._fireHistoryCallback(historyId);
                } else {
                    isc.History.logWarn("Unable to fire history callback onhashchange from: " +
                        event.oldURL + " to: " + event.newURL + "  - reason: no hash in newURL");
                }
            }
            // explicit flag since onhashchange() might have been set elsewhere
            this._handleHashChange = true;
        }
    }
},

// getBlankFrameURL(): When we write out the history frame, we need to give it an explicit src URL
// to avoid warnings about secure/non-secure items in IE6 / https

getBlankFrameURL : function () {
    if (isc.Page) return isc.Page.getBlankFrameURL();

    // the special directories handling hasn't been set up yet so figure out the URL
    // explicitly
    if (isc.Browser.isIE && ("https:" == window.location.protocol ||
                                document.domain != location.hostname ))
    {
        var path,
            isomorphicDir = window.isomorphicDir;
        // check for absolute isomorphicDir get the path
        if (isomorphicDir &&
            (isomorphicDir.indexOf("/") == 0 || isomorphicDir.indexOf("http") == 0))
        {
            path = isomorphicDir;
        } else {
            // combine the page base URL with the (relative) isomorphicDir
            path = window.location.href;
            if (path.charAt(path.length-1) != "/") {
                path = path.substring(0, path.lastIndexOf("/") + 1);
            }
            path += (isomorphicDir == null ? "../isomorphic/" : isomorphicDir);
        }
        path += "system/helpers/empty.html";
        return path;
    }
    return "about:blank";

},

_getFormValue : function () {
    var field = document.getElementById("isc_historyField");
    return field ? field.value : null;
},

_setFormValue : function (value) {
    var field = document.getElementById("isc_historyField");
    if (field) field.value = value;
},

// this method is called at the end of this file - after pageLoad in IE and synchronously after
// init() in Moz/FF
_completeInit : function () {
    // grab the serialized historyState from form auto-fill
    var historyState = this._getFormValue();
    if (historyState) {
        // Try to parse the serialized history state. Use isc._makeFunction which handles CSP
        // restrictions gracefully. If CSP blocks new Function(), fall back to JSON.decodeSafeWithDates()
        // if available or else JSON.parse() (these only work if the data was serialized as strict JSON).
        try {
            var parseFn = isc._makeFunction("return (" + historyState + ")");
            if (parseFn._cspBlocked) {
                // CSP blocked new Function - try JSON.decodeSafeWithDates()/JSON.parse() as fallback
                if (isc.JSON) historyState = isc.JSON.decodeSafeWithDates(historyState, /* dontCatchErrors */ true);
                else historyState = window.JSON.parse(historyState);
            } else {
                historyState = parseFn();
            }
        } catch (e) {
            this.logWarn("Failed to restore history state: " + e);
            historyState = null;
        }
    }

    // historyState = {
    //     stack: [id1, id2, id3 ... idN],
    //     data: {
    //         id1: data,
    //         id2: data
    //         ...
    //         idN: data
    //     }
    // }

    // if we had no persisted historyState, init a skeleton
    if (!historyState) historyState = { stack: [], data: {} };
    this.historyState = historyState;
    this.logInfo("History init complete");

    // in Moz, the only way to detect history changes is to watch the URL of the top-level page
    // for a delta.  In IE, we don't need this because we get an onload event from the iframe,
    // but we still need to watch the top-level URL because the user may use a bookmark to
    // navigate to a different history entry, or click on a series of links in another page
    // that points to history ids on this page and since, in that case, there is no navigation
    // of the iframe, we won't get a history navigation event.
    //
    // FIXME: We currently use the Moz workaround for Opera as well, but Opera has the
    // mindnumbing feature of suspending timeouts whenever the chrome back/forward buttons are
    // pressed and only resuming them when the mouse moves over the page.  So if you're just
    // hitting back/forward in the chrome, you're out of luck - until you mouse over the page.
    // Using z/x keyboard shortcuts works and so does the page context menu.  This sucks and
    // is completely stupid because it's not like that's what you'd ever want.  This
    // problem would affect sites that set up timers to do things on the page (like rotate ads)
    // and also use anchors on the page.  User hits an anchor, hits back, and all animations
    // stop. Nice one guys.
    this._lastURL = location.href;
    if (!this.usePushState) {
        // no need to poll if we have pushState support
        this._historyTimer = window.setInterval(function () { isc.History._statHistory(); }, this._historyStatInterval);
    }

    // fire the initial history callback here
    // Note In IE we use an IFRAME to track state across page transitions.
    // 2 possibilities here:
    // 1) we are hitting the page directly with a URL matching a history entry. In this case
    //    the iframe contains no info about any stored current history entries.
    //    In this case we do the same logic as in Moz and simply fireInitialHistoryCallback on load
    // 2) If a history entry was added, then the user navigated off this page, then came back to it
    //    the IFRAME load event will trigger a standard history navigation.
    // In this second case we'll essentially get two calls to the history callback method.
    // We catch this by simply suppressing firing the history callback twice in a row with the
    // same history entry ID.
    isc.SA_Page.onLoad(this._fireInitialHistoryCallback, this);
},

_fireInitialHistoryCallback : function () {

    // only fire once
    if (this._firedInitialHistoryCallback) return;

    // fire the initial history callback once we a) have a callback registered and b) pageLoad
    // has occurred.
    if (this._callbacksRegistry.length != 0 && isc.SA_Page.isLoaded()) {
        this._firedInitialHistoryCallback = true;

        // if we have history state, then it's a history transition for the initial load.
        var historyId = this._getHistory(location.href);
        this._fireHistoryCallback(historyId);
    }
},

// helper methods to get and add history to URLs.  Anchor values are automatically
// encoded/decoded by these.

_addHistory : function (url, historyId) {
    if (this.usePushState && this.pushStateMode == "queryParam") {
        url = this._initialURL;
        var paramName = this.pushStateQueryParamName;
        if (new RegExp("(\\?|&)"+paramName+"=").test(url)) {
            // already contains this query param - overwrite value
            url = url.replace(new RegExp("(\\?|&)"+paramName+"=(.*?)(&|$)"), "$1"+paramName+"="+encodeURIComponent(historyId)+"$3");
        } else {
            url += (url.contains("?") ? "&" : "?") + encodeURIComponent(paramName)+"="+encodeURIComponent(historyId);
        }
        return url;
    } else {
        var match = url.match(/([^#]*).*/);
        return match[1]+"#"+encodeURI(historyId);
    }
},

_getHistory : function (url) {
    if (this.usePushState && this.pushStateMode == "queryParam") {
        url = this._initialURL;
        var paramName = this.pushStateQueryParamName;
        var match = new RegExp("(\\?|&)"+paramName+"=(.*?)(&|$)").exec(url);
        return match ? decodeURIComponent(match[2]) : null;
    } else {
        var match = location.href.match(/([^#]*)#(.*)/);
        return match ? decodeURIComponent(match[2]) : null;
    }
},


// How often do we poll to see if the URL has changed?
_historyStatInterval: 100,


_saveHistoryState : function() {
    // In CSP mode where eval/new Function() are blocked, use strict JSON so that
    // JSON.decodeSafeWithDates() can restore the state, even if there are Date values in it.
    let historyState = this.historyState;
    if (!isc.Browser.allowsNewFunction) {
        if (isc.JSON) {
            historyState = isc.JSON.encode(historyState, {
                strictQuoting: true,
                dateFormat: "logicalDateString",
                prettyPrint: false
            });
        } else {
            historyState = window.JSON.stringify(historyState);
        }
        this._setFormValue(historyState);
    } else if (isc.Comm && isc.Comm.serialize) {
        this._setFormValue(isc.Comm.serialize(historyState));
    }
},

// Moz, Opera
_statHistory : function () {
    if (location.href != this._lastURL) {
        var historyId = this._getHistory(location.href);
        this._fireHistoryCallback(historyId);
    }
    this._lastURL = location.href;
},


// IE only - called by callback.html
historyCallback : function (win, currentFrameHistoryId) {
    // never show the user the special "init" ID
    if (currentFrameHistoryId == "_isc_H_init") currentFrameHistoryId = "";
    var newURL = this._addHistory(location.href, currentFrameHistoryId);
    // navigation has occurred, update the top-level URL to reflect the current id
    if (isc.SA_Page.isLoaded()) {
        location.href = newURL;
        // update _lastURL so that _statHistory() doesn't double-fire this callback
        this._lastURL = newURL;
    } else {
        // update _lastURL so that _statHistory() doesn't double-fire this callback
        isc.SA_Page.onLoad(function () {
            location.href = this._addHistory(location.href, currentFrameHistoryId);
            this._lastURL = newURL;
        }, this);
    }

    // if this callback is the result of the creation of a new synthetic history entry, don't
    // fire the callback
    if (this._ignoreHistoryCallback) {
        this._ignoreHistoryCallback = false;
        return;
    }

    if (isc.SA_Page.isLoaded()) {
        this._fireHistoryCallback(currentFrameHistoryId);
    } else {
        isc.SA_Page.onLoad(function () { this._fireHistoryCallback(currentFrameHistoryId) }, this);
    }
},

_fireHistoryCallback : function (historyId) {
    // suppress calling the same history callback twice in a row
    if (this._lastHistoryId == historyId) {
        // if this is the first time the callback is fired and _lastHistoryId==historyId,
        // the user has transitioned back to an anchorless URL - let that fire
        if (this._firedHistoryCallback) return;
    }
    this._firedHistoryCallback=true;

    var registry = this._callbacksRegistry;
    if (registry.length == 0) {
        this.logWarn("ready to fire history callback, but no callback registered."
                    +"Please call isc.History.registerCallback() before pageLoad."
                    +" If you can't register your callback before pageLoad, you"
                    +" can call isc.History.getCurrentHistoryId() to get the ID"
                    +" when you're ready.");
        return;
    }

    if (historyId == "_isc_H_init") historyId = null;

    var haveData = this.haveHistoryState(historyId);

    // create a copy of _callbacksRegistry, but appropriately filtered. If, for example, the
    // callback requires data, but we don't have data, then the callback is excluded from the
    // filtered copy.
    var filteredRegistry;
    if (haveData) {
        // no need to go through all of the registrations if we have data. Just create a duplicate.
        filteredRegistry = registry.slice();
    } else {
        filteredRegistry = [];
        for (var i = 0, len = registry.length; i < len; ++i) {
            var r = registry[i];
            if (!r.requiresData) filteredRegistry[filteredRegistry.length] = r;
        }
    }

    if (!haveData) {
        if (filteredRegistry.length == 0) {
            this.logWarn("User navigated to URL associated with synthetic history ID:" + historyId +
            ". This ID is not associated with any synthetic history entry generated via " +
            "History.addHistoryEntry(). Not firing a registered historyCallback as " +
            "all callbacks were registered with parameter requiring a data object. " +
            "This can commonly occur when the user navigates to a stored history entry " +
            "via a bookmarked URL.");
            return;
        }
    }

    var data = this.historyState.data[historyId];

    // store for getLastHistoryId()
    this._lastHistoryId = historyId;

    //>DEBUG
    this.logDebug("history callback: " + historyId);
    //<DEBUG

    // fire all of the callbacks
    for (var i = 0, len = filteredRegistry.length; i < len; ++i) {
        var r = filteredRegistry[i],
            callback = r.callback;
        if (isc.Class) {
            isc.Class.fireCallback(callback, ["id", "data"], [historyId, data]);

        } else {
            var args = [historyId, data];
            if (callback.method != null) {
                callback = isc.addProperties({}, callback);
                callback.args = args;
                this.fireSimpleCallback(callback);
            } else {
                callback.apply(null, args);
            }
        }
    }
}

}); // end History class


// mandatory pre-page load init
isc.History._init();
isc._debugModules = (isc._debugModules != null ? isc._debugModules : []);isc._debugModules.push('History');isc.checkForDebugAndNonDebugModules();isc._moduleEnd=isc._History_end=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc.Log&&isc.Log.logIsInfoEnabled('loadTime'))isc.Log.logInfo('History module init time: ' + (isc._moduleEnd-isc._moduleStart) + 'ms','loadTime');delete isc.definingFramework;if (isc.Page) isc.Page.handleEvent(null, "moduleLoaded", { moduleName: 'History', loadTime: (isc._moduleEnd-isc._moduleStart)});}else{if(window.isc && isc.Log && isc.Log.logWarn)isc.Log.logWarn("Duplicate load of module 'History'.");}
/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2026-02-04/LGPL Development Only (2026-02-04)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/

