import React from 'react';
import { FormItem, FormItemProps } from './FormItem';
import { AsComponentXML } from './core/ReactComponent';


declare interface AIDataQuestionItemProps extends FormItemProps {

/**
 * See {@link isc.AIDataQuestionItem.answerEngineOperationProperties AIDataQuestionItem.answerEngineOperationProperties}.
 */
answerEngineOperationProperties?: AnswerEngineOperation;

/**
 * See {@link isc.AIDataQuestionItem.dataQuestionSettings AIDataQuestionItem.dataQuestionSettings}.
 */
dataQuestionSettings?: DataQuestionSettings;


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * AIDataQuestionItem wraps the SmartClient widget class
 * {@link isc.AIDataQuestionItem AIDataQuestionItem} for React, allowing you to import
 * AIDataQuestionItem for use in React JS and JSX.
 * @class
 * @extends FormItem
 */
declare class AIDataQuestionItem extends FormItem {
    props: AsComponentXML<AIDataQuestionItemProps>;
}
