/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import jakarta.persistence.TupleElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.sql.results.spi.RowTransformer;

public class RowTransformerMapImpl
implements RowTransformer<Map<String, Object>> {
    private final TupleMetadata tupleMetadata;

    public RowTransformerMapImpl(TupleMetadata tupleMetadata) {
        this.tupleMetadata = tupleMetadata;
    }

    @Override
    public Map<String, Object> transformRow(Object[] row) {
        HashMap<String, Object> map = new HashMap<String, Object>(row.length);
        List<TupleElement<?>> list = this.tupleMetadata.getList();
        for (int i = 0; i < row.length; ++i) {
            String alias = list.get(i).getAlias();
            if (alias == null) {
                alias = Integer.toString(i);
            }
            map.put(alias, row[i]);
        }
        return map;
    }

    @Override
    public int determineNumberOfResultElements(int rawElementCount) {
        return 1;
    }
}

