/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.BitSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.internal.CollectionFetch;
import org.hibernate.sql.results.graph.collection.internal.SelectEagerCollectionInitializer;
import org.hibernate.type.descriptor.java.JavaType;

public class SelectEagerCollectionFetch
extends CollectionFetch {
    private final @Nullable DomainResult<?> collectionKeyDomainResult;

    public SelectEagerCollectionFetch(NavigablePath fetchedPath, PluralAttributeMapping fetchedAttribute, DomainResult<?> collectionKeyDomainResult, FetchParent fetchParent) {
        super(fetchedPath, fetchedAttribute, fetchParent);
        this.collectionKeyDomainResult = collectionKeyDomainResult;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.DELAYED;
    }

    @Override
    public boolean hasTableGroup() {
        return false;
    }

    @Override
    public CollectionInitializer createInitializer(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return new SelectEagerCollectionInitializer(this.getNavigablePath(), this.getFetchedMapping(), parentAccess, this.collectionKeyDomainResult, creationState);
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.getFetchedMapping().getJavaType();
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        if (this.collectionKeyDomainResult != null) {
            this.collectionKeyDomainResult.collectValueIndexesToCache(valueIndexes);
        }
    }
}

