/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

@Incubating
public interface Initializer {
    public NavigablePath getNavigablePath();

    public ModelPart getInitializedPart();

    public Object getInitializedInstance();

    default public void startLoading(RowProcessingState rowProcessingState) {
    }

    default public void markShallowCached() {
    }

    public void resolveKey(RowProcessingState var1);

    public void resolveInstance(RowProcessingState var1);

    public void initializeInstance(RowProcessingState var1);

    default public void initializeInstanceFromParent(Object parentInstance, RowProcessingState rowProcessingState) {
    }

    public void finishUpRow(RowProcessingState var1);

    default public void endLoading(ExecutionContext executionContext) {
    }

    public boolean isPartOfKey();

    public static boolean isPartOfKey(NavigablePath navigablePath, FetchParentAccess parentAccess) {
        return parentAccess != null && parentAccess.isEmbeddableInitializer() && parentAccess.isPartOfKey() || navigablePath instanceof EntityIdentifierNavigablePath || "{fk}".equals(navigablePath.getLocalName()) || "{fk-target}".equals(navigablePath.getLocalName());
    }

    public boolean isResultInitializer();

    default public boolean isEmbeddableInitializer() {
        return false;
    }

    default public boolean isEntityInitializer() {
        return false;
    }

    default public boolean isCollectionInitializer() {
        return false;
    }

    default public @Nullable EntityInitializer asEntityInitializer() {
        return null;
    }

    default public @Nullable EmbeddableInitializer asEmbeddableInitializer() {
        return null;
    }

    default public @Nullable CollectionInitializer asCollectionInitializer() {
        return null;
    }
}

