/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.Authentication;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.rpc.BuiltinRPC;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.URIRegexFilter;
import com.isomorphic.util.DataTools;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DevModeAuthFilter
extends URIRegexFilter {
    private static String authAttribute = "isc.devModeAuthorized";
    public List authorizedUsers = new ArrayList();
    public String getLogin;

    public void setAuthorizedUsers(String value) {
        Iterator<String> i = DataTools.simpleSplit(value, ",").iterator();
        while (i.hasNext()) {
            String user = i.next().trim();
            this.authorizedUsers.add(user);
        }
    }

    public void setGetLogin(String value) {
        this.getLogin = value;
    }

    @Override
    public void match(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        String userId = this.getUserId((HttpServletRequest)req, (HttpServletResponse)res);
        if (userId != null && this.authorizedUsers.contains(userId)) {
            req.setAttribute(authAttribute, (Object)userId);
        }
        chain.doFilter(req, res);
    }

    public static boolean devModeAuthorized(HttpServletRequest request) {
        return config != null && config.getBoolean((Object)"devModeAuthorized", false) || request.getAttribute(authAttribute) != null;
    }

    public static String getAuthorizedUserId(HttpServletRequest request) {
        return (String)request.getAttribute(authAttribute);
    }

    public String getUserId(HttpServletRequest request, HttpServletResponse response) {
        String login;
        if (this.getLogin != null) {
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            bindings.put("request", request);
            bindings.put("response", response);
            bindings.put("filter", this);
            bindings.put("log", this.log);
            DataTypeMap<String, Object> params = new DataTypeMap<String, Object>();
            params.put("engineName", "groovy");
            params.put("script", this.getLogin);
            params.put("bindings", bindings);
            try {
                RPCResponse rpcResponse = BuiltinRPC.evalServerScript(params);
                Map result = (Map)rpcResponse.getData();
                Object returnValue = result.get("evalResult");
                if (returnValue != null) {
                    return returnValue.toString();
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Unable to get user login", e);
                return null;
            }
        }
        try {
            Principal principal = request.getUserPrincipal();
            login = principal.getName();
            if (login != null) {
                return login;
            }
        }
        catch (Exception principal) {
            // empty catch block
        }
        try {
            RequestContext context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
            if (Authentication.isAuthenticated(context)) {
                // empty if block
            }
            if ((login = Authentication.getUsername(context)) != null) {
                return login;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

