/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.hibernate;

import java.util.List;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class CastToBinaryFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public CastToBinaryFunction(TypeConfiguration config) {
        super("isc_cast_to_binary", StandardArgumentsValidators.exactly((int)1), StandardFunctionReturnTypeResolvers.invariant((BasicType)config.getBasicTypeForJavaType(String.class)), StandardFunctionArgumentTypeResolvers.invariant((FunctionParameterType[])new FunctionParameterType[]{FunctionParameterType.STRING}));
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (sqlAstArguments.size() != 1) {
            throw new IllegalArgumentException("ISC_CAST_TO_BINARY function requires exactly one argument");
        }
        sqlAppender.appendSql("CAST(");
        sqlAstArguments.get(0).accept(walker);
        sqlAppender.appendSql(" AS BINARY)");
    }
}

