/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.FreeResourcesHandler;
import com.isomorphic.datasource.UnionDataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.sql.SQLClauseType;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.store.DataStructCache;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SQLUnionDataSource
extends UnionDataSource {
    private SQLDataSource sqlExecutor;
    private String _sqlExecutorXML;
    private static final List supportedSummaryFunctions = new ArrayList(){
        {
            this.add("MIN");
            this.add("MAX");
            this.add("AVG");
            this.add("SUM");
            this.add("COUNT");
        }
    };

    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        super.init(theConfig, dsRequest);
        this.allSql = !Boolean.FALSE.equals(theConfig.get("_unionDataSourceAllSql"));
        this.createSQLExecutor(dsRequest);
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        req.setAttribute("unionDataSource", (Object)this);
        ArrayList<String> subQueries = new ArrayList<String>();
        for (int i = 0; i < this.unionOf.size(); ++i) {
            BasicDataSource memberDs = (BasicDataSource)this.unionOf.get(i);
            String subquery = null;
            if (memberDs instanceof UnionDataSource) {
                if (!(memberDs instanceof SQLUnionDataSource)) {
                    log.warn((Object)("SQLUnionDataSsource " + this.getName() + " has a unionOf member dataSource " + memberDs.getName() + " which is a UnionDataSource but not an SQLUnionDataSource.  This is unexpected and cannot be handled.  Skipping member dataSource " + memberDs.getName()));
                    continue;
                }
                DSRequest dummyReq = new DSRequest((DataSource)memberDs, "fetch");
                dummyReq.setCriteria((Object)req.getCriteria());
                dummyReq.setTextMatchStyle(req.getTextMatchStyle());
                dummyReq.setAttribute("unionMode", (Object)true);
                dummyReq.setAttribute("unionDataSource", (Object)this);
                dummyReq.setAttribute("unionParentRequest", (Object)req);
                subquery = this.processSQLUnionDataSource((SQLUnionDataSource)memberDs, dummyReq);
            } else {
                if (!(memberDs instanceof SQLDataSource)) continue;
                subquery = this.processSQLDataSource((SQLDataSource)memberDs, req);
            }
            subQueries.add(subquery);
        }
        return this.processSubQueries(subQueries, req);
    }

    protected DSResponse processSubQueries(List<String> subQueries, DSRequest req) throws Exception {
        List results;
        StringBuffer sqlText = new StringBuffer();
        for (int i = 0; i < subQueries.size(); ++i) {
            if (i > 0) {
                sqlText.append("\nUNION\n");
            }
            sqlText.append(subQueries.get(i));
        }
        Object sqlTextWithoutOrderClause = sqlText.toString();
        DSRequest unionReq = new DSRequest((DataSource)this.sqlExecutor, "fetch", req.getRPCManager());
        SQLDriver driver = this.sqlExecutor.getDriver();
        unionReq.setAttribute("unionMode", (Object)true);
        unionReq.setAttribute("unionDataSource", (Object)this);
        unionReq.setAttribute("unionParentRequest", (Object)req);
        unionReq.setStartRow(req.getStartRow());
        unionReq.setEndRow(req.getEndRow());
        unionReq._setBatchSize(req.getEndRow() - req.getStartRow());
        boolean freeConnection = false;
        if (!this.sqlExecutor.shouldAutoJoinTransaction(unionReq)) {
            freeConnection = true;
            unionReq.setFreeOnExecute(true);
            unionReq.registerFreeResourcesHandler((FreeResourcesHandler)this.sqlExecutor);
        } else {
            req.setFreeOnExecute(false);
        }
        if (config.getBoolean((Object)"union.dataSource.return.explicit.nulls", false)) {
            unionReq.setAttribute("retainNullValues", (Object)true);
        }
        boolean summary = false;
        if (this.allSql && req.getSummaryFields() != null && req.getSummaryFields().size() > 0) {
            summary = true;
            Object groupTextPrelude = "SELECT ";
            String groupText = this.sqlExecutor.getSQLClauseForThisDS(SQLClauseType.Group, req, false);
            String summaryText = this.sqlExecutor.getSQLClauseForThisDS(SQLClauseType.Select, req, false);
            String groupWhereText = this.sqlExecutor.getSQLClauseForThisDS(SQLClauseType.GroupWhere, req, false);
            groupTextPrelude = (String)groupTextPrelude + summaryText + " FROM (\n";
            String firstFieldName = (String)req.getSummaryFields().get(0);
            String alias = this.sqlExecutor.getID();
            String groupTextCoda = ") AS " + alias;
            if (groupText != null && groupText.trim().length() > 0 && !"$defaultGroupClause".equals(groupText)) {
                groupTextCoda = groupTextCoda + "\nGROUP BY " + groupText;
            }
            sqlText.insert(0, (String)groupTextPrelude);
            sqlText.append(groupTextCoda);
            sqlTextWithoutOrderClause = (String)groupTextPrelude + (String)sqlTextWithoutOrderClause;
            sqlTextWithoutOrderClause = (String)sqlTextWithoutOrderClause + groupTextCoda;
            if (groupWhereText != null && groupWhereText.trim().length() > 0 && !"$defaultGroupWhereClause".equals(groupWhereText) && !"('1'='1')".equals(groupWhereText)) {
                sqlText.append("\nHAVING " + groupWhereText);
                sqlTextWithoutOrderClause = (String)sqlTextWithoutOrderClause + "\nHAVING " + groupWhereText;
            }
        }
        Object orderClause = "";
        if (req.getSortByFields() != null && req.getSortByFields().size() > 0) {
            orderClause = (String)orderClause + "ORDER BY ";
            DSRequest workReq = new DSRequest((DataSource)this.sqlExecutor, "fetch");
            workReq.setCriteria((Object)req.getCriteria());
            workReq.setOutputs(this.getUnionFieldNames(req));
            workReq.setSortBy((Object)req.getSortByFields());
            workReq.setAttribute("enforceOutputsFieldOrder", (Object)true);
            workReq.setAttribute("unionMode", (Object)true);
            workReq.setAttribute("unionDataSource", (Object)this);
            orderClause = (String)orderClause + SQLDataSource.getSQLClause(SQLClauseType.Order, workReq);
            sqlText.append("\n" + (String)orderClause);
        }
        log.debug((Object)("Ready to run UnionDataSource fetch with query: " + sqlText.toString()));
        String query = sqlText.toString();
        ArrayList<SQLDataSource> dataSources = new ArrayList<SQLDataSource>();
        dataSources.add(this.sqlExecutor);
        DSResponse result = new DSResponse((DataSource)this.sqlExecutor);
        result.setStartRow(req.getStartRow());
        if (!this.sqlExecutor.isProgressiveLoading(req)) {
            unionReq.setAttribute("_runningRowCountQuery", (Object)true);
            Object oCount = driver.executeScalar("SELECT COUNT(*) FROM (" + (String)sqlTextWithoutOrderClause + ") a", unionReq);
            unionReq.removeAttribute("_runningRowCountQuery");
            if (oCount != null) {
                Integer count;
                block25: {
                    String sCount = oCount.toString();
                    count = null;
                    try {
                        count = Integer.valueOf(sCount);
                    }
                    catch (NumberFormatException nfe) {
                        int dotIndex = sCount.indexOf(".");
                        if (dotIndex == -1) break block25;
                        sCount = sCount.substring(0, dotIndex);
                        count = Integer.valueOf(sCount);
                    }
                }
                result.setTotalRows((long)count.intValue());
            }
        } else {
            unionReq._setBatchSize(unionReq.getBatchSize() + (long)this.sqlExecutor.getLookAhead());
            unionReq.setEndRow(unionReq.getStartRow() + unionReq.getBatchSize());
            result.setRequestEndRow(unionReq.getStartRow() + unionReq.getBatchSize());
        }
        if (unionReq.getStartRow() > 0L || unionReq.getEndRow() > 0L) {
            long totalRows = unionReq.getEndRow() - unionReq.getStartRow() - 1L;
            DataTypeMap opBinding = this.getOperationBinding(req);
            String paging = SQLDataSource.getPaging(req, (Map)opBinding, this.sqlExecutor);
            if ("sqlLimit".equals(paging) && driver.supportsSQLLimit()) {
                HashMap context = new HashMap(){
                    {
                        this.put("isUnionFetch", true);
                    }
                };
                if (summary) {
                    context.put("isUnionSummary", true);
                    String defaultSortField = this.getConfig().getString((Object)"defaultSortField");
                    if (defaultSortField == null) {
                        defaultSortField = req.getGroupBy() != null && req.getGroupBy().size() > 0 ? (String)req.getGroupBy().get(0) : (String)req.getSummaryFields().get(0);
                    }
                    this.sqlExecutor.getConfig().put((Object)"defaultSortField", (Object)defaultSortField);
                }
                query = SQLDataSource.getDatabaseSpecificFetchQuery(sqlText.toString(), dataSources, unionReq, driver, (String)orderClause, result, context);
                results = driver.executeQuery(query.toString(), dataSources, unionReq);
            } else {
                List work = driver.executeQuery(query.toString(), dataSources, unionReq);
                results = new ArrayList();
                int i = (int)req.getStartRow();
                while ((long)i < req.getEndRow()) {
                    results.add(work.get(i));
                    ++i;
                }
            }
        } else {
            results = req.getEndRow() > req.getStartRow() || req.getEndRow() < 0L ? driver.executeQuery(query.toString(), dataSources, unionReq) : new ArrayList();
        }
        result.setData(results);
        result.setEndRow(unionReq.getStartRow() + (long)results.size());
        if (this.sqlExecutor.isProgressiveLoading(req)) {
            long total = result.getEndRow();
            if ((long)results.size() >= unionReq.getBatchSize()) {
                total += (long)this.sqlExecutor.getEndGap();
            }
            result.setTotalRows(total);
            result.setProgressiveLoading(true);
        }
        if (freeConnection) {
            log.debug((Object)("In SQLUnionDS.processSubQueries(), releasing unionReq's connection (" + String.valueOf(driver.dbConnection == null ? "NULL" : Integer.valueOf(driver.dbConnection.hashCode())) + ")"));
            unionReq.freeResources();
        } else {
            log.debug((Object)("In SQLUnionDS.processSubQueries(), we used a transactional connection (" + String.valueOf(this.sqlExecutor.getExistingTransactionalConnection(unionReq) == null ? "NULL" : Integer.valueOf(this.sqlExecutor.getExistingTransactionalConnection(unionReq).hashCode())) + ") - not attempting to free it"));
        }
        return result;
    }

    protected DSResponse processUnionDataSource(UnionDataSource thisUnionDs, DSRequest parentDsRequest) throws Exception {
        if (!(thisUnionDs instanceof SQLUnionDataSource)) {
            return super.processUnionDataSource(thisUnionDs, parentDsRequest);
        }
        final String subquery = this.processSQLUnionDataSource((SQLUnionDataSource)thisUnionDs, parentDsRequest);
        DSResponse resp = this.processSubQueries((List<String>)new ArrayList<String>(){
            {
                this.add(subquery);
            }
        }, parentDsRequest);
        List all = resp.getDataList();
        HashSet collapsed = new HashSet(all);
        if (all.size() > collapsed.size()) {
            resp.setEndRow(resp.getEndRow() + (long)(collapsed.size() - all.size()));
            resp.setTotalRows(resp.getTotalRows() + (long)(collapsed.size() - all.size()));
        }
        resp.setData(collapsed);
        return resp;
    }

    protected String processSQLUnionDataSource(SQLUnionDataSource thisUnionDs, DSRequest parentDsRequest) throws Exception {
        StringBuffer result = new StringBuffer();
        for (BasicDataSource subDs : thisUnionDs.getUnionOf()) {
            if (result.length() > 0) {
                result.append("\nUNION\n");
            }
            if (subDs instanceof SQLUnionDataSource) {
                DSRequest dummyReq = new DSRequest((DataSource)subDs, "fetch");
                dummyReq.setCriteria((Object)parentDsRequest.getCriteria());
                dummyReq.setTextMatchStyle(parentDsRequest.getTextMatchStyle());
                dummyReq.setAttribute("unionMode", (Object)true);
                dummyReq.setAttribute("unionDataSource", (Object)thisUnionDs);
                dummyReq.setAttribute("unionParentRequest", (Object)parentDsRequest);
                SQLUnionDataSource subUnionDs = (SQLUnionDataSource)subDs;
                result.append(thisUnionDs.processSQLUnionDataSource(subUnionDs, dummyReq));
                continue;
            }
            result.append(thisUnionDs.processSQLDataSource((SQLDataSource)subDs, parentDsRequest));
        }
        return result.toString();
    }

    private String processSQLDataSource(SQLDataSource memberDs, DSRequest parentDsRequest) throws Exception {
        DSRequest workReq = this.createMemberDSRequest(memberDs, parentDsRequest);
        workReq.setAttribute("enforceOutputsFieldOrder", (Object)true);
        return SQLDataSource.getSQLClause(SQLClauseType.All, workReq);
    }

    private void createSQLExecutor(DSRequest dsRequest) throws Exception {
        if (this._sqlExecutorXML == null) {
            HashMap instanceFileContext;
            Map fileConfig = SQLUnionDataSource.getLoadDSFileConfig((String)this.dsName, (DSRequest)dsRequest);
            String dsConfigFile = DataStructCache.getInstanceFile((String)this.dsName, (String)"datasources", (String)"DS", null, (Map)fileConfig, instanceFileContext = new HashMap(), (DSRequest)dsRequest);
            if (dsConfigFile == null) {
                return;
            }
            ISCFile iscFileInstance = DataStructCache.newISCFileInstance((String)dsConfigFile, (Map)fileConfig, (DSRequest)dsRequest);
            if (this.dsConfig == null) {
                throw new Exception("Can't locate datasource for name: " + this.dsName);
            }
            StringBuffer basexmlbuf = new StringBuffer();
            InputStream is = iscFileInstance.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                basexmlbuf.append((char)c);
            }
            Object basexml = basexmlbuf.toString();
            int index = ((String)basexml).indexOf("ID=\"");
            if (index == -1) {
                log.warn((Object)("Did not find an 'ID' declaration in DataSOurce '" + this.getID() + "'"));
                return;
            }
            int index2 = ((String)basexml).indexOf("\"", index + "ID=\"".length());
            if ((index = ((String)(basexml = ((String)basexml).substring(0, index2) + "_executor" + ((String)basexml).substring(index2))).indexOf("serverType=\"")) == -1) {
                log.warn((Object)("Did not find an 'serverType' declaration in DataSource '" + this.getID() + "'. Proceeding anyway"));
                index = ((String)basexml).indexOf(" ") + 1;
            } else {
                index2 = ((String)basexml).indexOf("\"", index + "serverType=\"".length());
                basexml = ((String)basexml).substring(0, index) + ((String)basexml).substring(index2 + 1);
            }
            basexml = ((String)basexml).substring(0, index) + "serverType=\"sql\"" + ((String)basexml).substring(index);
            index = ((String)basexml).indexOf("<fields>");
            if (index != -1) {
                index2 = ((String)basexml).indexOf("</fields>", index);
                if (index2 == -1) {
                    log.warn((Object)("Did not find closing </fields> tag parsing XML for DataSource '" + this.getName() + "'.  Is the dataSource descriptor well-formed XML?"));
                    return;
                }
                basexml = ((String)basexml).substring(0, index) + ((String)basexml).substring(index2 + 1);
            }
            StringBuffer xml = new StringBuffer();
            xml.append("<fields>");
            for (int i = 0; i < this.unionFields.size(); ++i) {
                DSField field = (DSField)this.unionFields.get(i);
                xml.append("<field name=\"" + field.getName() + "\" type=\"" + field.getType() + "\"");
                if (field.getString((Object)"sqlStorageStrategy") != null) {
                    xml.append(" sqlStorageStrategy=\"" + field.getString((Object)"sqlStorageStrategy") + "\"");
                }
                xml.append("/>");
            }
            xml.append("</fields>");
            index = ((String)basexml).indexOf("</DataSource>");
            if (index == -1) {
                log.warn((Object)("Did not find a closing '</DataSource>' tag parsing DataSource '" + this.getID() + "'. Is the descriptor well-formed XML?"));
                return;
            }
            this._sqlExecutorXML = basexml = ((String)basexml).substring(0, index) + xml.toString() + ((String)basexml).substring(index);
        }
        log.error((Object)("sqlExecutor XML source: " + this._sqlExecutorXML));
        try {
            this.sqlExecutor = (SQLDataSource)DataSource.fromXML((String)this._sqlExecutorXML);
        }
        catch (Exception e) {
            log.warn((Object)"Error when trying to create the executor SQLDataSource", (Throwable)e);
        }
    }

    public void freeResources(DSRequest req) {
        if (this.sqlExecutor == null) {
            log.warn((Object)("sqlExecutor dataSource was null in freeResources.  This should never happen - it implies that we are trying to free resources before the SQLUnionDS (" + this.getID() + ") has even been initialized"), (Throwable)new Exception());
        } else {
            this.sqlExecutor.freeResources(req);
        }
    }

    public void freeQueueResources(DSRequest req) {
        if (this.sqlExecutor == null) {
            log.warn((Object)("sqlExecutor dataSource was null in freeQueueResources.  This should never happen - it implies that we are trying to free resources before the SQLUnionDS (" + this.getID() + ") has even been initialized"), (Throwable)new Exception());
        } else {
            this.sqlExecutor.freeQueueResources(req);
        }
    }

    public boolean canJoinIncludedFields() {
        return true;
    }

    public boolean supportsAggregationInherently() {
        return this.allSql;
    }

    public boolean supportsSummaryFunction(String functionName) {
        if (!this.allSql || functionName == null) {
            return false;
        }
        return supportedSummaryFunctions.contains(functionName.toUpperCase());
    }

    public boolean isSQLDataSource() {
        return true;
    }
}

