/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.base.Config;
import com.isomorphic.base.ISCInit;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.messaging.ISCMessage;
import com.isomorphic.messaging.ISCMessageDispatcher;
import com.isomorphic.messaging.ISubscriber;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerApplicationConfig;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MessagingWebSocketEndpoint
extends Endpoint
implements ServerApplicationConfig {
    protected static Config config;
    protected static Logger log;
    protected static JSTranslater jsTrans;
    protected int keepaliveInterval = -1;
    protected int connectionTTL = 0;
    protected int keepaliveReestablishDelay = -1;
    protected int connectTimeout = -1;
    protected long asyncTimeout = 20000L;
    protected String clientID = null;
    protected String connectionID = null;
    protected ISCMessageDispatcher dispatcher = null;
    protected ISubscriber subscriber = null;
    protected Session session = null;
    protected RemoteEndpoint.Basic remoteEndpointBasic = null;
    protected RemoteEndpoint.Async remoteEndpointAsync = null;
    protected Future asyncSendFuture = null;
    private final Object BASIC_LOCK = new Object();
    private final Object ASYNC_LOCK = new Object();

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        log.debug((Object)("In WebsocketEndpoint.onOpen() for endpoint '" + ((Object)((Object)this)).hashCode() + "'"));
        this.keepaliveInterval = config.getInt((Object)"messaging.websocket.keepaliveInterval", -1);
        this.connectionTTL = config.getInt((Object)"messaging.websocket.connectionTTL", 0);
        this.keepaliveReestablishDelay = config.getInt((Object)"messaging.websocket.keepaliveReestablishDelay", -1);
        this.connectTimeout = config.getInt((Object)"messaging.websocket.connectTimeout", -1);
        this.session = session;
        if (config.getBoolean((Object)"messaging.websocket.async", false)) {
            this.remoteEndpointAsync = session.getAsyncRemote();
            this.asyncTimeout = config.getLong((Object)"messaging.websocket.async.timeout", this.asyncTimeout);
            this.remoteEndpointAsync.setSendTimeout(this.asyncTimeout);
            log.debug((Object)("Using async endpoint (messaging.websocket.async: true, timeout: " + this.asyncTimeout + ")"));
            try {
                this.remoteEndpointAsync.setBatchingAllowed(false);
            }
            catch (IOException iOException) {}
        } else {
            log.debug((Object)"Using synchronous endpoint (messaging.websocket.async: false)");
            this.remoteEndpointBasic = session.getBasicRemote();
            try {
                this.remoteEndpointBasic.setBatchingAllowed(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            Map queryParams = ServletTools.parseQueryString((String)session.getQueryString());
            this.clientID = (String)queryParams.get("clientID");
            this.connectionID = (String)queryParams.get("connectionID");
            if (!DataTools.isIdentifier((String)this.connectionID)) {
                throw new Exception("connectionID is not a valid identifier: " + DataTools.escapeHTML((String)this.connectionID));
            }
            Map channels = (Map)jsTrans.fromJS((String)queryParams.get("subscribedChannels"));
            String subscriberImpl = config.getString((Object)"messaging.subscriberImplementer");
            this.subscriber = new ISCWebSocketSubscriber(this);
            this.dispatcher = ISCMessageDispatcher.instance();
            if (this.clientID != null) {
                this.dispatcher.setClientID(this.clientID);
            }
            this.dispatcher.register(this.subscriber);
            this.dispatcher.subscribe(this.subscriber, channels);
            session.addMessageHandler((MessageHandler)new ISCMessageHandler(this));
            this.sendConnectCallback();
        }
        catch (Exception e) {
            log.error((Object)"Exception onOpen", (Throwable)e);
            this.cleanup(false);
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        CloseReason.CloseCode closeCode = closeReason.getCloseCode();
        if (closeCode == CloseReason.CloseCodes.CANNOT_ACCEPT || closeCode == CloseReason.CloseCodes.TOO_BIG || closeCode == CloseReason.CloseCodes.VIOLATED_POLICY || closeCode == CloseReason.CloseCodes.UNEXPECTED_CONDITION) {
            log.error((Object)("Websocket closed unexpectedly: " + String.valueOf(closeReason)));
        }
        if (closeCode == CloseReason.CloseCodes.TOO_BIG) {
            log.warn((Object)("Websocket message size limits - max text: " + this.getWebSocketConfigParam(session, "getMaxTextMessageBufferSize") + ", max binary: " + this.getWebSocketConfigParam(session, "getMaxBinaryMessageBufferSize")));
        }
        log.debug((Object)("In WebsocketEndpoint.onClose() for endpoint '" + ((Object)((Object)this)).hashCode() + "' with close code " + String.valueOf(closeCode)));
        this.cleanup(true);
    }

    public void onError(Session session, Throwable thr) {
        log.debug((Object)("In WebsocketEndpoint.onError() for endpoint '" + ((Object)((Object)this)).hashCode() + "'"));
        this.cleanup(false);
    }

    public void cleanup(boolean calledFromOnClose) {
        log.debug((Object)("In WebsocketEndpoint.cleanup() for endpoint '" + ((Object)((Object)this)).hashCode() + "'"));
        this.stopDispatcher();
        if (this.remoteEndpointBasic != null) {
            this.remoteEndpointBasic = null;
        }
        if (this.remoteEndpointAsync != null) {
            this.remoteEndpointAsync = null;
        }
        if (!calledFromOnClose && this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.session = null;
            }
        }
    }

    public void stopDispatcher() {
        if (this.dispatcher != null) {
            if (this.subscriber != null) {
                try {
                    this.dispatcher.unregister(this.subscriber);
                    this.subscriber = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.dispatcher.stop();
            this.dispatcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSendText(String message) throws Exception {
        if (this.remoteEndpointAsync != null) {
            Object object = this.ASYNC_LOCK;
            synchronized (object) {
                if (this.remoteEndpointAsync != null && this.session != null && this.session.isOpen()) {
                    if (this.asyncSendFuture != null) {
                        try {
                            this.asyncSendFuture.get(this.asyncTimeout, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException te) {
                            log.warn((Object)("Attempt to complete a previous async remote send timed out after " + this.asyncTimeout + "ms.  Connection to this client will now be cleaned up; the client will re-establish the connection in a few seconds if it is still active"));
                            this.asyncSendFuture = null;
                            throw te;
                        }
                    }
                    this.asyncSendFuture = this.remoteEndpointAsync.sendText(message);
                }
                return;
            }
        }
        Object object = this.BASIC_LOCK;
        synchronized (object) {
            if (this.remoteEndpointBasic != null && this.session != null && this.session.isOpen()) {
                this.remoteEndpointBasic.sendText(message);
            }
        }
    }

    public void clientConnTerminate() throws Exception {
        this.stopDispatcher();
        String message = "{  command: 'clientConnTerminateComplete'  ,connectionID: '" + this.connectionID + "'}";
        this.doSendText(message);
    }

    public void sendKeepalive() throws Exception {
        String message = "{  command: 'keepalive'  ,connectionID: '" + this.connectionID + "'}";
        this.doSendText(message);
    }

    public void sendConnectCallback() throws Exception {
        String dispatcherName = this.dispatcher.getClass().getName();
        boolean useDurableTopics = false;
        if (dispatcherName.equals("com.isomorphic.messaging.JMSMessageDispatcher")) {
            useDurableTopics = config.getBoolean((Object)"messaging.jms.useDurableTopics");
        }
        String message = "{  command: 'connectCallback'  ,connectionID: '" + this.connectionID + "'  ,config: {    keepaliveInterval: " + this.keepaliveInterval + "    ,connectionTTL: " + this.connectionTTL + "    ,connectTimeout: " + this.connectTimeout + "    ,keepaliveReestablishDelay: " + this.keepaliveReestablishDelay + "    ,dispatcherImplementer: '" + this.dispatcher.getClass().getName() + "'    ,useDurableTopics: " + useDurableTopics + "  }}";
        this.doSendText(message);
    }

    public void sendMessage(ISCMessage msg) throws Exception {
        DataTypeMap messageMap = DataTools.buildMap((Object[])new Object[]{"connectionID", this.connectionID, "channels", msg.getTargetChannels(), "id", msg.getID(), "data", msg.getData()});
        this.doSendText(jsTrans.toJS((Object)messageMap));
    }

    public void terminateConnection() throws Exception {
        String message = "{  command: 'serverConnTerminate'  ,connectionID: '" + this.connectionID + "'}";
        this.doSendText(message);
    }

    public Set<ServerEndpointConfig> getEndpointConfigs(Set<Class<? extends Endpoint>> scanned) {
        HashSet<ServerEndpointConfig> result = new HashSet<ServerEndpointConfig>();
        if (!config.getBoolean((Object)"messaging.websocket.enabled", false)) {
            log.debug((Object)"Websocket support disabled via server.properties setting: messaging.websocket.enabled");
            return result;
        }
        String endpointURI = config.getString((Object)"messaging.websocket.URI");
        log.info((Object)("Registering Realtime Messaging endpoint at: " + endpointURI));
        result.add(ServerEndpointConfig.Builder.create(MessagingWebSocketEndpoint.class, (String)endpointURI).build());
        return result;
    }

    public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
        return scanned;
    }

    private Integer getWebSocketConfigParam(Session session, String getterName) {
        try {
            Class tomcatSessionClass = Reflection.classForName((String)"org.apache.tomcat.websocket.WsSession");
            if (tomcatSessionClass.isAssignableFrom(session.getClass())) {
                Method getterMethod = tomcatSessionClass.getMethod(getterName, new Class[0]);
                return (Integer)getterMethod.invoke((Object)session, new Object[0]);
            }
        }
        catch (Exception e) {
            log.debug((Object)("Can't extract param " + getterName + " from Tomcat\n"), (Throwable)e);
        }
        try {
            Class jettySessionClass = Reflection.classForName((String)"org.eclipse.jetty.websocket.api.Session");
            Class jettyPolicyClass = Reflection.classForName((String)"org.eclipse.jetty.websocket.api.WebSocketPolicy");
            if (jettySessionClass.isAssignableFrom(session.getClass())) {
                Method policyGetter = jettySessionClass.getMethod("getPolicy", new Class[0]);
                Object policyObject = policyGetter.invoke((Object)session, new Object[0]);
                Method getterMethod = jettyPolicyClass.getMethod(getterName, new Class[0]);
                return (Integer)getterMethod.invoke((Object)session, new Object[0]);
            }
        }
        catch (Exception e) {
            log.error((Object)("Can't extract param " + getterName + " from Jetty\n"), (Throwable)e);
        }
        return null;
    }

    static {
        ISCInit.go(MessagingWebSocketEndpoint.class);
        config = Config.getGlobal();
        log = new Logger(MessagingWebSocketEndpoint.class.getName());
        jsTrans = JSTranslater.instance();
    }

    private static class ISCWebSocketSubscriber
    implements ISubscriber {
        MessagingWebSocketEndpoint webSocketEndpoint;

        private ISCWebSocketSubscriber(MessagingWebSocketEndpoint webSocketEndpoint) {
            this.webSocketEndpoint = webSocketEndpoint;
            log.debug((Object)("Created WebSocketSubscriber '" + this.hashCode() + "' for endpoint '" + ((Object)((Object)webSocketEndpoint)).hashCode() + "'"));
        }

        @Override
        public void send(ISCMessage message) throws Exception {
            log.debug((Object)("In send() for WebSocketSubscriber '" + this.hashCode() + "' for endpoint '" + ((Object)((Object)this.webSocketEndpoint)).hashCode() + "'.  Message is [" + message.getData().toString() + "]"));
            try {
                this.webSocketEndpoint.sendMessage(message);
            }
            catch (Exception e) {
                this.webSocketEndpoint.cleanup(false);
                throw e;
            }
        }

        @Override
        public ISCMessage nextMessage(long timeout) throws Exception {
            throw new Exception("nextMessage() not supported");
        }
    }

    private static class ISCMessageHandler
    implements MessageHandler.Whole<String> {
        MessagingWebSocketEndpoint webSocketEndpoint;

        private ISCMessageHandler(MessagingWebSocketEndpoint webSocketEndpoint) {
            this.webSocketEndpoint = webSocketEndpoint;
        }

        public void onMessage(String message) {
            try {
                Map envelope = (Map)jsTrans.fromJS(message);
                String command = (String)envelope.get("command");
                if (command != null) {
                    if ("send".equals(command)) {
                        List channels = (List)envelope.get("sendToChannels");
                        Object data = envelope.get("data");
                        ISCMessage msg = new ISCMessage(channels, data);
                        log.debug((Object)("In ISCMessageHandler.onMessage() for 'send' to channel(s) " + String.valueOf(channels) + ".  Message is " + String.valueOf(data)));
                        this.webSocketEndpoint.dispatcher.deliver(msg);
                    } else if ("keepalive".equals(command)) {
                        this.webSocketEndpoint.sendKeepalive();
                    } else if ("clientConnTerminate".equals(command)) {
                        this.webSocketEndpoint.clientConnTerminate();
                    } else {
                        log.warn((Object)("Ignored unknown command from client: " + command));
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Failure in onMessage handler", (Throwable)e);
            }
        }
    }
}

