/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Clob;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.ClobImplementer;
import org.hibernate.engine.jdbc.ReaderInputStream;
import org.hibernate.type.descriptor.java.DataHelper;

public class ClobProxy
implements InvocationHandler {
    private static final Class[] PROXY_INTERFACES = new Class[]{Clob.class, ClobImplementer.class};
    private String string;
    private Reader reader;
    private long length;
    private boolean needsReset = false;

    protected ClobProxy(String string) {
        this.string = string;
        this.reader = new StringReader(string);
        this.length = string.length();
    }

    protected ClobProxy(Reader reader, long length) {
        this.reader = reader;
        this.length = length;
    }

    protected long getLength() {
        return this.length;
    }

    protected InputStream getAsciiStream() throws SQLException {
        this.resetIfNeeded();
        return new ReaderInputStream(this.reader);
    }

    protected Reader getCharacterStream() throws SQLException {
        this.resetIfNeeded();
        return this.reader;
    }

    protected String getSubString(long start, int length) {
        if (this.string == null) {
            throw new UnsupportedOperationException("Clob was not created from string; cannot substring");
        }
        int endIndex = Math.min((int)start + length, this.string.length());
        return this.string.substring((int)start, endIndex);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int argCount = method.getParameterTypes().length;
        if ("length".equals(methodName) && argCount == 0) {
            return this.getLength();
        }
        if ("getAsciiStream".equals(methodName) && argCount == 0) {
            return this.getAsciiStream();
        }
        if ("getCharacterStream".equals(methodName)) {
            if (argCount == 0) {
                return this.getCharacterStream();
            }
            if (argCount == 2) {
                long start = (Long)args[0];
                if (start < 1L) {
                    throw new SQLException("Start position 1-based; must be 1 or more.");
                }
                if (start > this.getLength()) {
                    throw new SQLException("Start position [" + start + "] cannot exceed overall CLOB length [" + this.getLength() + "]");
                }
                int length = (Integer)args[1];
                if (length < 0) {
                    throw new SQLException("Length must be great-than-or-equal to zero.");
                }
                return DataHelper.subStream(this.getCharacterStream(), start - 1L, length);
            }
        }
        if ("getSubString".equals(methodName) && argCount == 2) {
            long start = (Long)args[0];
            if (start < 1L) {
                throw new SQLException("Start position 1-based; must be 1 or more.");
            }
            if (start > this.getLength()) {
                throw new SQLException("Start position [" + start + "] cannot exceed overall CLOB length [" + this.getLength() + "]");
            }
            int length = (Integer)args[1];
            if (length < 0) {
                throw new SQLException("Length must be great-than-or-equal to zero.");
            }
            return this.getSubString(start - 1L, length);
        }
        if ("free".equals(methodName) && argCount == 0) {
            this.reader.close();
            return null;
        }
        if ("toString".equals(methodName) && argCount == 0) {
            return this.toString();
        }
        if ("equals".equals(methodName) && argCount == 1) {
            return proxy == args[0];
        }
        if ("hashCode".equals(methodName) && argCount == 0) {
            return new Integer(this.hashCode());
        }
        throw new UnsupportedOperationException("Clob may not be manipulated from creating session");
    }

    protected void resetIfNeeded() throws SQLException {
        try {
            if (this.needsReset) {
                this.reader.reset();
            }
        }
        catch (IOException ioe) {
            throw new SQLException("could not reset reader");
        }
        this.needsReset = true;
    }

    public static Clob generateProxy(String string) {
        return (Clob)Proxy.newProxyInstance(ClobProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new ClobProxy(string));
    }

    public static Clob generateProxy(Reader reader, long length) {
        return (Clob)Proxy.newProxyInstance(ClobProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new ClobProxy(reader, length));
    }

    protected static ClassLoader getProxyClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClobImplementer.class.getClassLoader();
        }
        return cl;
    }
}

