/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.contentexport;

import com.isomorphic.base.Base;
import com.isomorphic.contentexport.SvgImage;
import com.isomorphic.rpc.IImageExporter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class ImageExport
extends Base
implements IImageExporter {
    public void writePNG(OutputStream os, String svgString) throws IOException {
        SvgImage svgImage = new SvgImage(svgString);
        ImageIO.write((RenderedImage)svgImage.createImage(), "png", os);
    }

    public void writeJPEG(OutputStream os, String svgString, Float quality) throws IOException {
        Iterator<ImageWriter> jpegWriters;
        SvgImage svgImage = new SvgImage(svgString);
        BufferedImage bufferedImage = svgImage.createImage();
        if (quality != null && (jpegWriters = ImageIO.getImageWritersByFormatName("jpg")).hasNext()) {
            ImageWriter jpegWriter = jpegWriters.next();
            ImageWriteParam param = jpegWriter.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(quality.floatValue());
            jpegWriter.setOutput(os instanceof ImageOutputStream ? os : new MemoryCacheImageOutputStream(os));
            jpegWriter.write(null, new IIOImage(bufferedImage, null, null), param);
            return;
        }
        ImageIO.write((RenderedImage)bufferedImage, "jpg", os);
    }

    public InputStream getPNG(String svgString) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writePNG(baos, svgString);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public InputStream getJPEG(String svgString, Float quality) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeJPEG(baos, svgString, quality);
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

