/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.io;

import com.isomorphic.base.Service;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.io.ISCFile;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SizeFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class FileMonitor
extends Service
implements FileAlterationListener {
    public String directory;
    public String dataSource;
    public Map criteria;
    public String fileField = "file";
    public boolean ingestMode = false;
    public String ingestCompleteMoveToDir = null;
    public int writeCompleteInterval = 1000;
    public int retryInterval = 60000;
    public List<String> reportEventTypes;
    protected IOFileFilter filter;
    protected FileAlterationObserver observer;
    private long lastRetryTime = -1L;
    DataTypeMap<File, Long> filesPendingCreateNotify = new DataTypeMap(new ConcurrentHashMap());

    @Override
    public String getLogContext() {
        return "dir: " + this.directory;
    }

    @Override
    public void completeInit() throws Exception {
        if (this.directory == null) {
            this.log.error("directory unset - exiting");
            return;
        }
        if (!new File(this.directory).exists()) {
            this.log.warn("Configured directory: " + this.directory + " does not exist - will wait");
        }
        if (this.dataSource == null) {
            this.log.error("dataSource unset - exiting");
            return;
        }
        this.reportEvent("init", new File(this.directory));
        if (this.ingestMode && this.filter == null) {
            this.filter = new AndFileFilter(HiddenFileFilter.VISIBLE, (IOFileFilter)new SizeFileFilter(1L));
        }
        this.observer = this.filter == null ? new FileAlterationObserver(this.directory) : new FileAlterationObserver(this.directory, (FileFilter)this.filter);
        this.observer.addListener((FileAlterationListener)this);
        if (this.ingestMode) {
            this.log.info("init in ingestMode, scanning " + this.directory + " for existing files");
            this.retryExistingFiles();
        }
    }

    protected void retryExistingFiles() {
        this.lastRetryTime = new Date().getTime();
        this.log.debug("running full directory scan on " + this.directory + " to retry any failed create notifications");
        if (!new File(this.directory).exists()) {
            this.log.warn("Configured directory: " + this.directory + " does not exist, deferring scan");
            return;
        }
        for (File file : new File(this.directory).listFiles()) {
            if (!file.isFile() || this.filter != null && !this.filter.accept(file)) continue;
            this.log.info("sending synthetic create event for: " + file.getName());
            this.onFileCreate(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute() {
        this.observer.checkAndNotify();
        if (this.ingestMode && this.filesPendingCreateNotify.size() != 0) {
            long now = new Date().getTime();
            DataTypeMap<File, Long> lengthUpdates = new DataTypeMap<File, Long>(new ConcurrentHashMap());
            Iterator<File> i = this.filesPendingCreateNotify.keySet().iterator();
            while (i.hasNext()) {
                File file = i.next();
                this.log.debug(file.getName() + " checking pending create notify status");
                Long previousFileLength = this.filesPendingCreateNotify.get(file);
                Long currentFileLength = file.length();
                if (!file.exists()) {
                    this.log.debug(file.getName() + " was removed before create notify could be sent");
                    i.remove();
                    continue;
                }
                if (previousFileLength.longValue() != currentFileLength.longValue()) {
                    lengthUpdates.put(file, currentFileLength);
                    this.log.debug(file.getName() + " has changed since last check (was: " + previousFileLength + ", now: " + currentFileLength + ") - delaying create notify");
                    continue;
                }
                if (now - file.lastModified() < (long)this.writeCompleteInterval) {
                    this.log.debug(file.getName() + " is still within writeCompleteInterval (" + this.writeCompleteInterval + "ms) - delaying create notify");
                    continue;
                }
                AbstractInterruptibleChannel fileChannel = null;
                FileLock fileLock = null;
                try {
                    fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.WRITE);
                    fileLock = ((FileChannel)fileChannel).tryLock();
                    this.log.debug(file.getName() + " lock acquired - sending create notify");
                    boolean eventReported = this.reportEvent("create", file);
                    if (eventReported) {
                        i.remove();
                        try {
                            fileLock.release();
                            fileLock = null;
                            fileChannel.close();
                            fileChannel = null;
                            if (this.ingestCompleteMoveToDir == null) {
                                file.delete();
                                continue;
                            }
                            IOUtil.atomicMove(file.getPath(), this.ingestCompleteMoveToDir);
                        }
                        catch (Exception e) {
                            this.log.error((Object)("ingestMode - failed to (re)move file: " + file.getPath()), e);
                        }
                        continue;
                    }
                    this.log.warn("failed to send create notification for: " + file.getPath() + " - deferring for " + this.retryInterval + "ms");
                    i.remove();
                }
                catch (Exception e) {
                    this.log.debug(file.getName() + " unable to acquire lock - delaying create notify");
                }
                finally {
                    if (fileLock != null) {
                        try {
                            fileLock.release();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fileChannel == null) continue;
                    try {
                        fileChannel.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.filesPendingCreateNotify.putAll((Map<File, Long>)((Object)lengthUpdates));
        }
        if (this.ingestMode && new Date().getTime() - this.lastRetryTime > (long)this.retryInterval) {
            this.retryExistingFiles();
        }
        return null;
    }

    public void onStart(FileAlterationObserver observer) {
        if (this.ingestMode) {
            return;
        }
        this.reportEvent("start", new File(this.directory));
    }

    public void onStop(FileAlterationObserver observer) {
        if (this.ingestMode) {
            return;
        }
        this.reportEvent("stop", new File(this.directory));
    }

    public void onDirectoryCreate(File directory) {
        if (this.ingestMode) {
            return;
        }
        this.reportEvent("create", directory);
    }

    public void onDirectoryChange(File directory) {
        if (this.ingestMode) {
            return;
        }
        this.reportEvent("change", directory);
    }

    public void onDirectoryDelete(File directory) {
        if (this.ingestMode) {
            return;
        }
        this.reportEvent("delete", directory);
    }

    public void onFileCreate(File file) {
        if (this.ingestMode) {
            if (this.getReportableEvent("create", file) != null) {
                this.filesPendingCreateNotify.put(file, file.length());
            }
        } else {
            this.reportEvent("create", file);
        }
    }

    public void onFileChange(File file) {
        if (this.ingestMode) {
            return;
        }
        this.reportEvent("change", file);
    }

    public void onFileDelete(File file) {
        if (this.ingestMode) {
            return;
        }
        this.reportEvent("delete", file);
    }

    protected DataTypeMap getReportableEvent(String eventType, File file) {
        block8: {
            if (this.reportEventTypes != null && !this.reportEventTypes.contains(eventType)) {
                return null;
            }
            DataTypeMap event = DataTools.buildMap("eventType", eventType, "fileType", file.isDirectory() ? "directory" : "file", "name", file.getName(), "path", file.getPath(), "length", file.isDirectory() ? Long.valueOf(-1L) : Long.valueOf(file.length()), "lastModified", new Date(file.lastModified()));
            try {
                event.put("canonicalPath", file.getCanonicalPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.criteria != null && !new DSRequest(this.dataSource, "add").getDataSource().matchesCriteria((Map)((Object)event), this.criteria)) break block8;
                if (this.fileField != null && !file.isDirectory() && "create".equals(eventType) || "change".equals(eventType)) {
                    try {
                        event.put(this.fileField, ISCFile.newInstance(file).getAsString());
                    }
                    catch (FileNotFoundException e) {
                        this.log.info(event.getString("path") + " was removed before it could be read");
                        return null;
                    }
                }
                return event;
            }
            catch (Exception e) {
                this.log.error("Error while evaluating event match criteria: " + this.criteria + " for dataSource: " + this.dataSource + " - treating event as non-reportable");
            }
        }
        return null;
    }

    public boolean reportEvent(String eventType, File file) {
        return this.reportEvent(this.getReportableEvent(eventType, file));
    }

    public boolean reportEvent(DataTypeMap event) {
        if (event == null) {
            return false;
        }
        DSResponse dsResponse = null;
        try {
            dsResponse = new DSRequest(this.dataSource, "add").setValues((Object)event).execute();
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to send file event to configured dataSource: " + this.dataSource + " event: " + DataTools.subsetMap((Map)((Object)event), DataTools.buildList("eventType", "fileType", "name"))), e);
            return false;
        }
        return dsResponse != null && dsResponse.statusIsSuccess();
    }
}

