/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.Config;
import com.isomorphic.base.ISCInit;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;

public class InitListener
implements ServletContextListener,
ServletRequestListener {
    public static boolean isRegistered = false;

    public void contextInitialized(ServletContextEvent sce) {
        InitListener.oneTimeIdempotentInit(sce.getServletContext(), this.getClass().getName());
    }

    public static void oneTimeIdempotentInit(ServletContext servletContext, String initializingClassName) {
        if (servletContext != null && ISCFile.servletContext == null) {
            ISCFile.servletContext = servletContext;
        }
        ISCInit.go(initializingClassName);
        isRegistered = true;
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    public void requestInitialized(ServletRequestEvent sre) {
        HttpServletRequest request = (HttpServletRequest)sre.getServletRequest();
        Logger.clearMDC();
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        HttpServletRequest request = (HttpServletRequest)sre.getServletRequest();
        RequestContext.purgeThreadLocal();
        Logger.removeContext();
        Logger.clearMDC();
        Logger.observeThread();
        Logger.enableThread();
        DataSource.purgeThreadDynamicId();
        DataSource.purgeLoadFlags();
        Config.getGlobal().purgeThreadLocal();
        if (request.getAttribute("isc_restart_requested") != null) {
            try {
                ISCInit.restartContainer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

