/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.log.Logger;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.taglib.LoadProjectTag;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProjectLoaderServlet
extends BaseServlet {
    public static final String PARAM_PROJECT_NAME = "projectName";
    public static final String PARAM_SCREEN_NAMES = "screenNames";
    public static final String PARAM_CURRENT_SCREEN_NAME = "currentScreenName";
    public static final String PARAM_DRAW_FIRST_SCREEN = "drawFirstScreen";
    public static final String PARAM_LOCALE = "locale";
    public static final String PARAM_OWNER_ID = "ownerId";
    public static final String PARAM_SHARE_ID = "shareId";
    private static Logger log = new Logger(ProjectLoaderServlet.class.getName());

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = config.getString("RPCManager.defaultCharset", "UTF-8");
        }
        if (!encoding.toLowerCase().equals("none")) {
            request.setCharacterEncoding(encoding);
            response.setContentType("application/javascript;charset=" + encoding);
        } else {
            response.setContentType("application/javascript");
        }
        String locale = request.getParameter(PARAM_LOCALE);
        String ownerId = null;
        String owner = request.getParameter(PARAM_OWNER_ID);
        if (owner != null) {
            ownerId = owner;
        }
        if (ownerId == null) {
            ownerId = request.getRemoteUser();
        }
        String shareId = request.getParameter(PARAM_SHARE_ID);
        List<String> screenNames = null;
        String names = request.getParameter(PARAM_SCREEN_NAMES);
        if (names != null) {
            screenNames = Arrays.asList(names.split(","));
        }
        boolean drawFirstScreen = true;
        String drawFirstScreenParam = request.getParameter(PARAM_DRAW_FIRST_SCREEN);
        if (drawFirstScreenParam != null && ("0".equals(drawFirstScreenParam) || "false".equals(drawFirstScreenParam.toLowerCase()))) {
            drawFirstScreen = false;
        }
        String currentScreenName = request.getParameter(PARAM_CURRENT_SCREEN_NAME);
        try {
            StringWriter writer = new StringWriter();
            String projectName = request.getParameter(PARAM_PROJECT_NAME);
            if (projectName == null) {
                log.warn("Parameter \"projectName\" is not specified.");
            } else if ("".equals(projectName.trim())) {
                log.warn("No data specified in parameter \"projectName\".");
            } else {
                log.debug("Requested projects:" + projectName);
                LoadProjectTag.outputProject(writer, projectName, currentScreenName, ownerId, locale, shareId, screenNames, drawFirstScreen);
            }
            log.debug("Generated response:" + ((Object)writer).toString());
            response.setStatus(200);
            PrintWriter rw = response.getWriter();
            rw.print(((Object)writer).toString());
            rw.close();
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
        finally {
            try {
                response.flushBuffer();
            }
            catch (IOException writer) {}
        }
    }
}

