/*-=-
    Isomorphic SmartClient web presentation layer
    Copyright 2000-2007 Isomorphic Software, Inc.

    OWNERSHIP NOTICE
    Isomorphic Software owns and reserves all rights not expressly granted in this source code,
    including all intellectual property rights to the structure, sequence, and format of this code
    and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.

    CONFIDENTIALITY NOTICE
    The contents of this file are confidential and protected by non-disclosure agreement:
      * You may not expose this file to any person who is not bound by the same obligations.
      * You may not expose or send this file unencrypted on a public network.

    SUPPORTED INTERFACES
    Most interfaces expressed in this source code are internal and unsupported. Isomorphic supports
    only the documented behaviors of properties and methods that are marked "@visibility external"
    in this code. All other interfaces may be changed or removed without notice. The implementation
    of any supported interface may also be changed without notice.
 
    If you have any questions, please email <sourcecode@isomorphic.com>.
 
    This entire comment must accompany any portion of Isomorphic Software source code that is
    copied or moved from this file.
*/

package com.isomorphic.struts;

import java.io.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

import com.isomorphic.base.*;
import com.isomorphic.log.*;
import com.isomorphic.rpc.*;
import com.isomorphic.util.*;
import com.isomorphic.datasource.*;

import org.apache.struts.*;
import org.apache.struts.util.*;
import org.apache.struts.action.*;
import org.apache.struts.validator.*;
import org.apache.commons.validator.*;


public class ValidationFailureAction extends Action {

    private Logger log = new Logger(ValidationFailureAction.class.getName());

    // if we're here, the validation failed.
    public ActionForward execute(ActionMapping mapping, ActionForm form,
                                 HttpServletRequest request, HttpServletResponse response)
        throws Exception 
    {
        RPCManager rpc = new RPCManager(request, response);

        // return the validation errors
        DSRequest dsRequest = (DSRequest)rpc.getRequests().get(0);
        DSResponse dsResponse = new DSResponse(dsRequest == null ? (DataSource)null : 
                                                                    dsRequest.getDataSource());
        dsResponse.setStatus(DSResponse.STATUS_VALIDATION_ERROR);

        // XXX Struts 1.2.1 defines a getErrors() method on the Action class that does exactly this
        // - but we want to be backcompat to Struts 1.1, so we effectively re-implement that method
        // here.
        ActionMessages ae = (ActionMessages)request.getAttribute(Globals.ERROR_KEY);
        if(ae == null) ae = new ActionMessages();
        for(Iterator i = ae.properties(); i.hasNext();) {
            String fieldName = (String)i.next();
            for(Iterator j = ae.get(fieldName); j.hasNext();) {
                ActionMessage am = (ActionMessage)j.next();
                
                //log.warn(am.toString());
                
                String validatorKey = am.getKey();
                Object[] values = am.getValues();
                
                String error = getError(validatorKey, values, request);
                if(error != null) dsResponse.addError(fieldName, new ErrorMessage(error));
            }
        }        
        
        rpc.send(dsRequest, dsResponse);
        return null;
        
    }

       
    // jump through hoops to get the actual localized error for a given error key
    protected String getError(String key, Object args[], HttpServletRequest request) {
        
        MessageResources resources = getResources(request);
        
        Locale locale = RequestUtils.getUserLocale(request, null);
        
        String message = null;
        if(args == null) message = resources.getMessage(locale, key);
        else message = resources.getMessage(locale, key, args);

        if(message == null) log.warn("Missing message for key: " + key);
        
        return message;
    }

}
