/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.res;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.res.ResourceFileSystemConfigBuilder;

public class ResourceFileProvider
extends AbstractFileProvider {
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.DISPATCHER));
    private static final int BUFFER_SIZE = 80;

    @Override
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        URL url;
        StringBuilder buf = new StringBuilder(80);
        UriParser.extractScheme(uri, buf);
        String resourceName = buf.toString();
        ClassLoader cl = ResourceFileSystemConfigBuilder.getInstance().getClassLoader(fileSystemOptions);
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if ((url = cl.getResource(resourceName)) == null) {
            throw new FileSystemException("vfs.provider.url/badly-formed-uri.error", (Object)uri);
        }
        return this.getContext().getFileSystemManager().resolveFile(url.toExternalForm());
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return ResourceFileSystemConfigBuilder.getInstance();
    }

    @Override
    public void closeFileSystem(FileSystem filesystem) {
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

