/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services;

import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.OperaWebElement;
import com.opera.core.systems.model.ScriptResult;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.exceptions.ScopeException;
import com.opera.core.systems.scope.protos.Esdbg6Protos;
import com.opera.core.systems.scope.protos.EsdbgProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.stp.services.ScopeEcmascriptDebugger;
import com.opera.core.systems.scope.stp.services.messages.EcmascriptDebuggerMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.WebElement;

public class ScopeEcmascriptDebugger6
extends ScopeEcmascriptDebugger {
    public ScopeEcmascriptDebugger6(ScopeServices services) {
        super(services, "6.10");
    }

    @Override
    public Object scriptExecutor(String script, Object ... params) {
        String toSend;
        ArrayList elements = Lists.newArrayList();
        if (params != null && params.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (Object object : params) {
                if (builder.toString().length() > 0) {
                    builder.append(",");
                }
                if (object instanceof Collection) {
                    builder.append("[");
                    Collection collection = (Collection)object;
                    for (Object argument : collection) {
                        this.processArgument(argument, builder, elements);
                        builder.append(",");
                    }
                    int lastCharIndex = builder.length() - 1;
                    if (builder.charAt(lastCharIndex) != '[') {
                        builder.deleteCharAt(lastCharIndex);
                    }
                    builder.append("]");
                    continue;
                }
                this.processArgument(object, builder, elements);
            }
            String arguments = builder.toString();
            toSend = "(function(){" + script + "})(" + arguments + ")";
        } else {
            toSend = script;
        }
        EsdbgProtos.EvalData.Builder evalBuilder = this.buildEval(toSend, this.getRuntimeId());
        for (WebElement webElement : elements) {
            EsdbgProtos.EvalData.Variable variable = this.buildVariable(webElement.toString(), ((OperaWebElement)webElement).getObjectId());
            evalBuilder.addVariableList(variable);
        }
        UmsProtos.Response response = this.executeMessage(EcmascriptDebuggerMessage.EVAL, (AbstractMessage.Builder<?>)evalBuilder);
        if (response == null) {
            throw new ScopeException("Internal error while executing script");
        }
        Esdbg6Protos.EvalResult result = this.parseEvalData(response);
        Object parsed = this.parseEvalReply(result);
        if (parsed instanceof Esdbg6Protos.ObjectValue) {
            Esdbg6Protos.ObjectValue data = (Esdbg6Protos.ObjectValue)parsed;
            return new ScriptResult(data.getObjectID(), data.getClassName());
        }
        return parsed;
    }

    private Esdbg6Protos.EvalResult parseEvalData(UmsProtos.Response response) {
        Esdbg6Protos.EvalResult.Builder builder = Esdbg6Protos.EvalResult.newBuilder();
        ScopeEcmascriptDebugger6.buildPayload(response, builder);
        return builder.build();
    }

    @Override
    public Object executeScript(String using, boolean responseExpected) {
        return this.executeScript(using, responseExpected, this.getRuntimeId());
    }

    @Override
    public Object executeScript(String using, boolean responseExpected, int runtimeId) {
        UmsProtos.Response reply = this.eval(using, runtimeId, new EsdbgProtos.EvalData.Variable[0]);
        return responseExpected ? this.parseEvalReply(this.parseEvalData(reply)) : null;
    }

    @Override
    public Integer getObject(String using) {
        Esdbg6Protos.EvalResult reply = this.parseEvalData(this.eval(using, new EsdbgProtos.EvalData.Variable[0]));
        return reply.getType().equals("object") ? Integer.valueOf(reply.getObjectValue().getObjectID()) : null;
    }

    @Override
    public Integer getObject(String using, int runtimeId) {
        Esdbg6Protos.EvalResult reply = this.parseEvalData(this.eval(using, runtimeId, new EsdbgProtos.EvalData.Variable[0]));
        return reply.getType().equals("object") ? Integer.valueOf(reply.getObjectValue().getObjectID()) : null;
    }

    @Override
    public String callFunctionOnObject(String using, int objectId) {
        EsdbgProtos.EvalData.Variable variable = this.buildVariable("locator", objectId);
        Esdbg6Protos.EvalResult reply = this.parseEvalData(this.eval(using, variable));
        return reply.getType().equals("null") ? null : reply.getValue();
    }

    @Override
    public Object callFunctionOnObject(String using, int objectId, boolean responseExpected) {
        EsdbgProtos.EvalData.Variable variable = this.buildVariable("locator", objectId);
        UmsProtos.Response response = this.eval(using, variable);
        return responseExpected ? this.parseEvalReply(this.parseEvalData(response)) : null;
    }

    @Override
    public Integer executeScriptOnObject(String using, int objectId) {
        EsdbgProtos.EvalData.Variable variable = this.buildVariable("locator", objectId);
        Esdbg6Protos.EvalResult reply = this.parseEvalData(this.eval(using, variable));
        Object object = this.parseEvalReply(reply);
        if (object == null || !(object instanceof Esdbg6Protos.ObjectValue)) {
            return null;
        }
        return ((Esdbg6Protos.ObjectValue)object).getObjectID();
    }

    protected Object parseEvalReply(Esdbg6Protos.EvalResult result) {
        String dataType;
        String status = result.getStatus();
        if (!status.equals("completed")) {
            if (status.equals("unhandled-exception")) {
                String message;
                try {
                    message = (String)this.callFunctionOnObject("return locator.name+': '+locator.message;", result.getObjectValue().getObjectID(), true);
                }
                catch (Exception e) {
                    throw new ScopeException("Ecmascript exception");
                }
                throw new ScopeException("Ecmascript exception:\n" + message);
            }
            if (status.equals("cancelled-by-scheduler")) {
                return null;
            }
        }
        if ("string".equals(dataType = result.getType())) {
            return result.getValue();
        }
        if ("number".equals(dataType)) {
            return this.parseNumber(result.getValue());
        }
        if ("boolean".equals(dataType)) {
            return Boolean.valueOf(result.getValue());
        }
        if ("undefined".equals(dataType)) {
            return null;
        }
        if ("object".equals(dataType)) {
            return result.getObjectValue();
        }
        return null;
    }

    @Override
    public List<Integer> examineObjects(Integer id) {
        ArrayList ids = Lists.newArrayList();
        Esdbg6Protos.ObjectChainList list = this.getChainList(id);
        List<Esdbg6Protos.ObjectInfo.Property> properties = list.getObjectChainList(0).getObjectListList().get(0).getPropertyListList();
        for (Esdbg6Protos.ObjectInfo.Property property : properties) {
            if (!property.getType().equals("object")) continue;
            ids.add(property.getObjectValue().getObjectID());
        }
        return ids;
    }

    @Override
    public Object examineScriptResult(Integer id) {
        return this.examineScriptResult(id, new HashSet<Integer>());
    }

    private Object examineScriptResult(Integer id, Set<Integer> visitedIDs) {
        if (visitedIDs.contains(id)) {
            return null;
        }
        visitedIDs.add(id);
        Esdbg6Protos.ObjectChainList list = this.getChainList(id);
        List<Esdbg6Protos.ObjectInfo.Property> properties = list.getObjectChainList(0).getObjectListList().get(0).getPropertyListList();
        String className = list.getObjectChainListList().get(0).getObjectList(0).getValue().getClassName();
        if (className.endsWith("Element")) {
            return new OperaWebElement(this.driver, id);
        }
        if (className.equals("Array")) {
            ArrayList result = Lists.newArrayList();
            for (Esdbg6Protos.ObjectInfo.Property property : properties) {
                if (property.getType().equals("number") && property.getName().equals("length")) continue;
                if (property.getType().equals("object")) {
                    result.add(this.examineScriptResult(property.getObjectValue().getObjectID(), visitedIDs));
                    continue;
                }
                result.add(this.parseValue(property.getType(), property.getValue()));
            }
            return result;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Esdbg6Protos.ObjectInfo.Property property : properties) {
            if (property.getType().equals("number") && property.getName().equals("length")) continue;
            if (property.getType().equals("object")) {
                result.put(property.getName(), this.examineScriptResult(property.getObjectValue().getObjectID(), visitedIDs));
                continue;
            }
            result.put(property.getName(), this.parseValue(property.getType(), property.getValue()));
        }
        return result;
    }

    private Esdbg6Protos.ObjectChainList getChainList(Integer id) {
        Esdbg6Protos.ExamineList.Builder examine = Esdbg6Protos.ExamineList.newBuilder();
        examine.setExaminePrototypes(false);
        examine.setRuntimeID(this.getRuntimeId());
        examine.addObjectList(id);
        UmsProtos.Response response = this.executeMessage(EcmascriptDebuggerMessage.EXAMINE_OBJECTS, (AbstractMessage.Builder<?>)examine);
        Esdbg6Protos.ObjectChainList.Builder builder = Esdbg6Protos.ObjectChainList.newBuilder();
        ScopeEcmascriptDebugger6.buildPayload(response, builder);
        return builder.build();
    }
}

