/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import com.isomorphic.xml.XMLParsingException;
import java.io.File;
import java.io.FileReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class WorkflowLoaderDataSource
extends BasicDataSource {
    private static Logger log = new Logger(WorkflowLoaderDataSource.class.getName());

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        Config iscConfig = Config.getGlobal();
        String webroot = iscConfig.getPath("webroot");
        String processesDirPath = iscConfig.getPath("project.processes", webroot + "/processes");
        DSResponse dsResponse = new DSResponse(this);
        dsResponse.setStatus(0);
        Object id = req.getCriteria().get("id");
        if (id instanceof String) {
            dsResponse.setData((Object)DataTools.buildMap("content", this.loadProcess(processesDirPath, (String)id)));
        } else {
            List ids = (List)id;
            ArrayList<String> content = new ArrayList<String>();
            for (String nextId : ids) {
                content.add(this.loadProcess(processesDirPath, nextId));
            }
            dsResponse.setData((Object)DataTools.buildMap("content", content));
        }
        return dsResponse;
    }

    private String loadProcess(String processesDirPath, String processId) throws Exception {
        String content = null;
        File processFile = new File(processesDirPath = ISCFile.canonicalizePath(processesDirPath + "/" + processId + ".proc.xml"));
        if (processFile.exists()) {
            FileReader procXmlReader = new FileReader(processFile);
            StringWriter out = new StringWriter();
            try {
                XML.toJS(procXmlReader, (Writer)out).freeResources();
            }
            catch (XMLParsingException e) {
                log.info("Error parsing inbound XML - assuming multiple top-level elements and retrying with wrapper tag.");
                SequenceReader reader = new SequenceReader("<isomorphicXML xmlns:xsi=\"nativeType\">", procXmlReader, "</isomorphicXML>");
                out = new StringWriter();
                XML.toJS(reader, (Writer)out);
            }
            content = out.toString();
        }
        return content;
    }
}

