/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.pool;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.pool.ISCKeyedPoolableObjectFactory;
import com.isomorphic.util.DataTools;
import java.util.Map;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class ISCKeyedObjectPool
extends GenericKeyedObjectPool {
    private static Logger log = new Logger(ISCKeyedObjectPool.class.getName());
    private static Config globalConfig = Config.getGlobal();
    private ISCKeyedPoolableObjectFactory factory;

    public ISCKeyedObjectPool(ISCKeyedPoolableObjectFactory factory, Map thisConfig) {
        super((KeyedPoolableObjectFactory)factory);
        this.factory = factory;
        String whenExhaustedAction = (String)thisConfig.remove("whenExhaustedAction");
        Byte action = null;
        if (whenExhaustedAction != null) {
            if ("grow".equals(whenExhaustedAction = whenExhaustedAction.toLowerCase())) {
                action = new Byte(2);
            }
            if ("block".equals(whenExhaustedAction)) {
                action = new Byte(1);
            }
            if ("fail".equals(whenExhaustedAction)) {
                action = new Byte(0);
            }
        }
        if (action != null) {
            thisConfig.put("whenExhaustedAction", action);
        } else {
            log.error("Ignoring unknown value: " + whenExhaustedAction + " for whenExhaustedAction. Valid values are: grow, block, fail.");
        }
        try {
            DataTools.setProperties(thisConfig, (Object)this);
        }
        catch (Exception e) {
            log.warning((Object)"Problem setting requested config parameters on pool.", e);
        }
    }

    public ISCKeyedPoolableObjectFactory getObjectFactory() {
        return this.factory;
    }

    public synchronized Object borrowObject(Object key) throws Exception {
        log.debug("Borrowing object for '" + key + "'");
        Object obj = super.borrowObject(key);
        return obj;
    }
}

