/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.log;

import com.isomorphic.log.LogEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class RevolvingMemoryAppender
extends AppenderSkeleton {
    protected static Map<String, Collection> logs = new LinkedHashMap<String, Collection>();
    protected int maxEntries = 50;

    public static List<String> getLogNames() {
        return new ArrayList<String>(logs.keySet());
    }

    public static Collection getLogEntries(String name) {
        return logs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLogEntries(String name) {
        Map<String, Collection> map = logs;
        synchronized (map) {
            Collection log = logs.get(name);
            if (log != null) {
                log.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        this.name = name;
        Map<String, Collection> map = logs;
        synchronized (map) {
            ArrayList log = logs.get(name);
            if (log == null) {
                log = this.maxEntries == -1 ? new ArrayList() : new CircularFifoQueue(this.maxEntries);
                logs.put(name, log);
            }
        }
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public int getMaxEntires() {
        return this.maxEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void append(LoggingEvent event) {
        Collection logEntries = RevolvingMemoryAppender.getLogEntries(this.name);
        Map<String, Collection> map = logs;
        synchronized (map) {
            String[] throwableRep;
            String formattedMessage = this.layout.format(event);
            ThrowableInformation throwableInfo = event.getThrowableInformation();
            if (throwableInfo != null && this.layout.ignoresThrowable() && (throwableRep = throwableInfo.getThrowableStrRep()) != null) {
                for (int i = 0; i < throwableRep.length; ++i) {
                    formattedMessage = formattedMessage + throwableRep[i] + Layout.LINE_SEP;
                }
            }
            logEntries.add(new LogEntry(formattedMessage, event.getLevel().toString()));
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public void close() {
    }
}

